/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.network.message;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import stevesaddons.naming.NameData;
import stevesaddons.naming.NameRegistry;

public class FullDataSyncMessage
implements IMessage,
IMessageHandler<FullDataSyncMessage, IMessage> {
    Map<Integer, NameData> nameMapping;

    public FullDataSyncMessage() {
        this.nameMapping = new HashMap<Integer, NameData>();
    }

    public FullDataSyncMessage(Map<Integer, NameData> nameMapping) {
        this.nameMapping = nameMapping;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        int length = pb.readInt();
        try {
            for (int i = 0; i < length; ++i) {
                int dim = pb.readInt();
                NBTTagCompound tagCompound = pb.func_150793_b();
                NameData nameData = new NameData();
                nameData.func_76184_a(tagCompound);
                this.nameMapping.put(dim, nameData);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.writeInt(this.nameMapping.entrySet().size());
        try {
            for (Map.Entry<Integer, NameData> entry : this.nameMapping.entrySet()) {
                pb.writeInt(entry.getKey().intValue());
                NBTTagCompound tagCompound = new NBTTagCompound();
                entry.getValue().func_76187_b(tagCompound);
                pb.func_150786_a(tagCompound);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public IMessage onMessage(FullDataSyncMessage message, MessageContext ctx) {
        NameRegistry.setNameData(message.nameMapping);
        return null;
    }
}

