/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import com.google.common.collect.BiMap;
import gregtech.GT_Mod;
import gregtech.api.objects.GT_UO_Dimension;
import gregtech.api.objects.GT_UO_DimensionList;
import gregtech.api.objects.GT_UO_Fluid;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import pers.gwyog.gtneioreplugin.GTNEIOrePlugin;
import pers.gwyog.gtneioreplugin.util.DimensionHelper;

public class GT5UndergroundFluidHelper {
    private static final Map<String, List<UndergroundFluidWrapper>> fluidMap = new HashMap<String, List<UndergroundFluidWrapper>>();

    public static void init() {
        try {
            Field fieldDimensionList = GT_UO_DimensionList.class.getDeclaredField("fDimensionList");
            fieldDimensionList.setAccessible(true);
            BiMap dimensionList = (BiMap)fieldDimensionList.get(GT_Mod.gregtechproxy.mUndergroundOil);
            for (Map.Entry dimensionEntry : dimensionList.entrySet()) {
                String rawDimension = (String)dimensionEntry.getKey();
                String dimension = null;
                try {
                    dimension = GT5UndergroundFluidHelper.getDimensionFromID(Integer.parseInt(rawDimension));
                }
                catch (NumberFormatException ignored) {
                    Field fieldProviders = DimensionManager.class.getDeclaredField("providers");
                    fieldProviders.setAccessible(true);
                    Hashtable providers = (Hashtable)fieldProviders.get(null);
                    List dimensionCandidates = providers.values().stream().filter(p -> p.getName().contains(rawDimension)).collect(Collectors.toList());
                    block5: for (Class candidate : dimensionCandidates) {
                        for (int i = 0; i < DimensionHelper.DimNameTrimmed.length; ++i) {
                            if (!DimensionHelper.DimNameTrimmed[i].equalsIgnoreCase(((WorldProvider)candidate.getConstructor(new Class[0]).newInstance(new Object[0])).func_80007_l())) continue;
                            dimension = DimensionHelper.DimNameDisplayed[i];
                            break block5;
                        }
                    }
                }
                if (dimension == null && (dimension = GT5UndergroundFluidHelper.getDimensionForEdgeCase(rawDimension)) == null) {
                    GTNEIOrePlugin.LOG.warn("Unknown dimension found in GT5 config: " + rawDimension);
                    continue;
                }
                Field fieldFluids = GT_UO_Dimension.class.getDeclaredField("fFluids");
                fieldFluids.setAccessible(true);
                BiMap fluids = (BiMap)fieldFluids.get(dimensionEntry.getValue());
                int maxChance = 0;
                for (Map.Entry fluidEntry : fluids.entrySet()) {
                    maxChance += ((GT_UO_Fluid)fluidEntry.getValue()).Chance;
                }
                for (Map.Entry fluidEntry : fluids.entrySet()) {
                    Fluid fluid = FluidRegistry.getFluid((String)((String)fluidEntry.getKey()));
                    if (fluid == null) continue;
                    UndergroundFluidWrapper wrapper = new UndergroundFluidWrapper(dimension, ((GT_UO_Fluid)fluidEntry.getValue()).Chance * 10000 / maxChance, ((GT_UO_Fluid)fluidEntry.getValue()).MaxAmount, ((GT_UO_Fluid)fluidEntry.getValue()).MinAmount);
                    if (fluidMap.containsKey(fluid.getName())) {
                        fluidMap.get(fluid.getName()).add(wrapper);
                        continue;
                    }
                    fluidMap.put(fluid.getName(), new ArrayList<UndergroundFluidWrapper>(Collections.singletonList(wrapper)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (List<UndergroundFluidWrapper> wrappers : fluidMap.values()) {
            wrappers.sort(Comparator.comparingInt(w -> Arrays.asList(DimensionHelper.DimNameDisplayed).indexOf(w.dimension)));
        }
    }

    public static List<UndergroundFluidWrapper> getEntry(String fluidName) {
        return fluidMap.get(fluidName);
    }

    public static Map<String, List<UndergroundFluidWrapper>> getAllEntries() {
        return fluidMap;
    }

    private static String getDimensionFromID(int id) {
        String string;
        switch (id) {
            case 0: {
                string = "Ow";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static String getDimensionForEdgeCase(String rawDimension) {
        String string;
        switch (rawDimension) {
            case "aCentauriBb": {
                string = "CB";
                break;
            }
            case "BarnardaC": {
                string = "BC";
                break;
            }
            case "BarnardaE": {
                string = "BE";
                break;
            }
            case "BarnardaF": {
                string = "BF";
                break;
            }
            case "TCetiE": {
                string = "TE";
                break;
            }
            default: {
                GTNEIOrePlugin.LOG.warn("Unknown dimension name while parsing: " + rawDimension);
                string = null;
            }
        }
        return string;
    }

    public static class UndergroundFluidWrapper {
        public final String dimension;
        public final int chance;
        public final int maxAmount;
        public final int minAmount;

        public UndergroundFluidWrapper(String dimension, int chance, int maxAmount, int minAmount) {
            this.dimension = dimension;
            this.chance = chance;
            this.maxAmount = maxAmount;
            this.minAmount = minAmount;
        }
    }
}

