/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import remoteio.common.RemoteIO;
import remoteio.common.network.VanillaPacketHelper;

public class PacketClientForceSlot
implements IMessage,
IMessageHandler<PacketClientForceSlot, IMessage> {
    public int slot;
    public ItemStack itemStack;

    public PacketClientForceSlot() {
    }

    public PacketClientForceSlot(int slot, ItemStack itemStack) {
        this.slot = slot;
        this.itemStack = itemStack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        if (this.itemStack != null) {
            buf.writeBoolean(true);
            try {
                VanillaPacketHelper.writeItemStackToBuffer(buf, this.itemStack);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        if (buf.readBoolean()) {
            try {
                this.itemStack = VanillaPacketHelper.readItemStackFromBuffer(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public IMessage onMessage(PacketClientForceSlot message, MessageContext ctx) {
        RemoteIO.proxy.setClientPlayerSlot(message.slot, message.itemStack);
        return null;
    }
}

