/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.loader;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.loader.gui.CreativeTabTecTech;
import com.github.technus.tectech.loader.recipe.BaseRecipeLoader;
import com.github.technus.tectech.loader.thing.CoverLoader;
import com.github.technus.tectech.loader.thing.MachineLoader;
import com.github.technus.tectech.loader.thing.ThingsLoader;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Recipe;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class MainLoader {
    public static DamageSource microwaving;

    private MainLoader() {
    }

    public static void preLoad() {
        TecTech.creativeTabTecTech = new CreativeTabTecTech("TecTech");
        try {
            Textures.run();
        }
        catch (Throwable t) {
            TecTech.LOGGER.error("Loading textures...", (Object)t);
        }
    }

    public static void load() {
        ProgressManager.ProgressBar progressBarLoad = ProgressManager.push((String)"TecTech Loader", (int)6);
        progressBarLoad.step("Regular Things");
        new ThingsLoader().run();
        TecTech.LOGGER.info((Object)"Block/Item Init Done");
        progressBarLoad.step("Machine Things");
        new MachineLoader().run();
        TecTech.LOGGER.info((Object)"Machine Init Done");
        progressBarLoad.step("Cover Things");
        new CoverLoader().run();
        TecTech.LOGGER.info((Object)"Cover Init Done");
        progressBarLoad.step("Add damage types");
        microwaving = new DamageSource("microwaving").func_76348_h();
        TecTech.LOGGER.info((Object)"Damage types addition Done");
        progressBarLoad.step("Register Packet Dispatcher");
        new NetworkDispatcher();
        TecTech.LOGGER.info((Object)"Packet Dispatcher registered");
        progressBarLoad.step("Register GUI Handler");
        TecTech.proxy.registerRenderInfo();
        TecTech.LOGGER.info((Object)"GUI Handler registered");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarLoad);
    }

    public static void postLoad() {
        ProgressManager.ProgressBar progressBarPostLoad = ProgressManager.push((String)"TecTech Post Loader", (int)4);
        progressBarPostLoad.step("Dreamcraft Compatibility");
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            try {
                Class<?> clazz = Class.forName("com.dreammaster.gthandler.casings.GT_Container_CasingsNH");
                TT_Container_Casings.sBlockCasingsNH = (Block)clazz.getField("sBlockCasingsNH").get(null);
                if (TT_Container_Casings.sBlockCasingsNH == null) {
                    throw new NullPointerException("sBlockCasingsNH Is not set at this time");
                }
            }
            catch (Exception e) {
                throw new Error("Unable to get NH casings", e);
            }
        }
        progressBarPostLoad.step("Recipes");
        new BaseRecipeLoader().run();
        TecTech.LOGGER.info((Object)"Recipe Init Done");
        if (!TecTech.configTecTech.DISABLE_BLOCK_HARDNESS_NERF) {
            progressBarPostLoad.step("Nerf blocks blast resistance");
            MainLoader.adjustTwilightBlockResistance();
            TecTech.LOGGER.info((Object)"Blocks nerf done");
        } else {
            progressBarPostLoad.step("Do not nerf blocks blast resistance");
            TecTech.LOGGER.info((Object)"Blocks were not nerfed");
        }
    }

    public static void addAfterGregTechPostLoadRunner() {
        GregTech_API.sAfterGTPostload.add(() -> {
            if (TecTech.configTecTech.NERF_FUSION) {
                MainLoader.FixBrokenFusionRecipes();
            }
        });
    }

    private static void FixBrokenFusionRecipes() {
        HashMap<Fluid, Fluid> binds = new HashMap<Fluid, Fluid>();
        for (Materials material : Materials.values()) {
            FluidStack p = material.getPlasma(1L);
            if (p == null) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Found Plasma of " + material.mName));
            }
            if (material.mElement == null || material.mElement.mProtons < Materials.Iron.mElement.mProtons && -material.mElement.mProtons < Materials.Iron.mElement.mProtons && material.mElement.mNeutrons < Materials.Iron.mElement.mNeutrons && -material.mElement.mNeutrons < Materials.Iron.mElement.mNeutrons) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Attempting to bind " + material.mName));
            }
            if (material.getMolten(1L) != null) {
                binds.put(p.getFluid(), material.getMolten(1L).getFluid());
                continue;
            }
            if (material.getGas(1L) != null) {
                binds.put(p.getFluid(), material.getGas(1L).getFluid());
                continue;
            }
            if (material.getFluid(1L) != null) {
                binds.put(p.getFluid(), material.getFluid(1L).getFluid());
                continue;
            }
            binds.put(p.getFluid(), Materials.Iron.getMolten(1L).getFluid());
        }
        for (GT_Recipe r : RecipeMaps.fusionRecipes.getAllRecipes()) {
            Fluid fluid = (Fluid)binds.get(r.mFluidOutputs[0].getFluid());
            if (fluid != null) {
                if (TecTechConfig.DEBUG_MODE) {
                    TecTech.LOGGER.info((Object)("Nerfing Recipe " + r.mFluidOutputs[0].getUnlocalizedName()));
                }
                r.mFluidOutputs[0] = new FluidStack(fluid, r.mFluidOutputs[0].amount);
            }
            if ((fluid = (Fluid)binds.get(r.mFluidInputs[0].getFluid())) != null) {
                if (TecTechConfig.DEBUG_MODE) {
                    TecTech.LOGGER.info((Object)("Fixing plasma use in Recipe " + r.mFluidInputs[0].getUnlocalizedName()));
                }
                r.mFluidInputs[0] = new FluidStack(fluid, r.mFluidInputs[0].amount);
            }
            if ((fluid = (Fluid)binds.get(r.mFluidInputs[1].getFluid())) == null) continue;
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Fixing plasma use in Recipe " + r.mFluidInputs[1].getUnlocalizedName()));
            }
            r.mFluidInputs[1] = new FluidStack(fluid, r.mFluidInputs[1].amount);
        }
    }

    private static void safeSetResistance(Block block, float resistance) {
        if (block != null) {
            block.func_149752_b(resistance);
        }
    }

    private static void adjustTwilightBlockResistance() {
        if (Mods.TwilightForest.isModLoaded()) {
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFShield"), 30.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFThorns"), 10.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFTowerTranslucent"), 30.0f);
            MainLoader.safeSetResistance(GameRegistry.findBlock((String)"TwilightForest", (String)"tile.TFDeadrock"), 5.0f);
        }
    }
}

