/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.item.ItemShuttle;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldData;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.vec.Vector3int;
import de.katzenpapst.amunra.world.ShuttleDockHandler;
import de.katzenpapst.amunra.world.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class ShuttleTeleportHelper {
    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            WorldServer targetWorld;
            WorldServer worldServer = targetWorld = world.field_73011_w.field_76574_g == dimensionID ? world : mcServer.func_71218_a(dimensionID);
            if (targetWorld == null) {
                AmunRa.LOGGER.error("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                return null;
            }
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(targetWorld.field_73011_w.getClass());
            if (type != null) {
                return ShuttleTeleportHelper.teleportEntity((World)targetWorld, entity, dimensionID, type);
            }
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID, ITeleportType type) {
        if (entity.field_70154_o != null) {
            if (entity.field_70154_o instanceof EntitySpaceshipBase) {
                entity.func_70078_a(entity.field_70154_o);
            } else if (entity.field_70154_o instanceof EntityCelestialFake) {
                entity.field_70154_o.func_70106_y();
                entity.func_70078_a(null);
            }
        }
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        EntityPlayerMP player = null;
        Vector3 spawnPos = null;
        int oldDimID = entity.field_70170_p.field_73011_w.field_76574_g;
        if (entity instanceof EntityPlayerMP) {
            if (dimChange) {
                player = (EntityPlayerMP)entity;
                World worldOld = player.field_70170_p;
                try {
                    AmunRa.LOGGER.debug("Attempting to remove player from old dimension {}", new Object[]{oldDimID});
                    ((WorldServer)worldOld).func_73040_p().func_72695_c(player);
                    AmunRa.LOGGER.debug("Successfully removed player from old dimension {}", new Object[]{oldDimID});
                }
                catch (Exception e) {
                    AmunRa.LOGGER.warn("Failed to remove player from old dimension", (Throwable)e);
                }
                player.func_71053_j();
                GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
                stats.usingPlanetSelectionGui = false;
                player.field_71093_bK = dimID;
                AmunRa.LOGGER.debug("Sending respawn packet to player for dim {}", new Object[]{dimID});
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(dimID, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                if (worldNew.field_73011_w instanceof WorldProviderOrbit && WorldUtil.registeredSpaceStations.containsKey(dimID)) {
                    NBTTagCompound var2 = new NBTTagCompound();
                    SpaceStationWorldData.getStationData((World)worldNew, (int)dimID, (EntityPlayer)player).func_76187_b(var2);
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_DATA, new Object[]{dimID, var2}), player);
                }
                worldOld.field_73010_i.remove(player);
                worldOld.func_72854_c();
                if (player.field_70175_ag && worldOld.func_72863_F().func_73149_a(player.field_70176_ah, player.field_70164_aj)) {
                    Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                    chunkOld.func_76622_b((Entity)player);
                    chunkOld.field_76643_l = true;
                }
                worldOld.field_72996_f.remove(player);
                worldOld.func_72847_b((Entity)player);
                if (worldNew.field_73011_w instanceof WorldProviderOrbit) {
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
                }
                worldNew.func_72838_d(entity);
                entity.func_70029_a(worldNew);
                spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, player);
                ChunkCoordIntPair pair = worldNew.func_72964_e(spawnPos.intX(), spawnPos.intZ()).func_76632_l();
                AmunRa.LOGGER.debug("Loading first chunk in new dimension.");
                ((WorldServer)worldNew).field_73059_b.func_73158_c(pair.field_77276_a, pair.field_77275_b);
                worldNew.func_72866_a(entity, false);
                entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                player.field_71133_b.func_71203_ab().func_72375_a(player, (WorldServer)worldNew);
                player.field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                AmunRa.LOGGER.info("Server attempting to transfer player {} to dimension {}", new Object[]{player.func_146103_bH().getName(), worldNew.field_73011_w.field_76574_g});
                player.field_71134_c.func_73080_a((WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72354_b(player, (WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                for (Object o : player.func_70651_bq()) {
                    PotionEffect var10 = (PotionEffect)o;
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), var10));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            } else {
                player = (EntityPlayerMP)entity;
                player.func_71053_j();
                GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
                stats.usingPlanetSelectionGui = false;
                if (worldNew.field_73011_w instanceof WorldProviderOrbit) {
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
                }
                worldNew.func_72866_a(entity, false);
                spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
                player.field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                worldNew.func_72866_a(entity, false);
                AmunRa.LOGGER.info("Server attempting to transfer player {} within same dimension {}", new Object[]{player.func_146103_bH().getName(), worldNew.field_73011_w.field_76574_g});
            }
        }
        GCPlayerStats playerStats = GCPlayerStats.get(player);
        boolean usingShuttle = playerStats.rocketItem instanceof ItemShuttle;
        if (spawnPos == null) {
            spawnPos = new Vector3(0.0, 800.0, 0.0);
        }
        if (spawnPos.y < 300.0) {
            spawnPos.y = 300.0;
        }
        if (spawnPos.y > 800.0) {
            spawnPos.y = 800.0;
        }
        player.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        if (!usingShuttle) {
            if (type.useParachute() && playerStats.extendedInventory.func_70301_a(4) != null && playerStats.extendedInventory.func_70301_a(4).func_77973_b() instanceof ItemParaChute) {
                GCPlayerHandler.setUsingParachute((EntityPlayerMP)player, (GCPlayerStats)playerStats, (boolean)true);
            } else {
                GCPlayerHandler.setUsingParachute((EntityPlayerMP)player, (GCPlayerStats)playerStats, (boolean)false);
            }
            if (playerStats.rocketStacks != null && playerStats.rocketStacks.length > 0) {
                for (int stack = 0; stack < playerStats.rocketStacks.length; ++stack) {
                    if (playerStats.rocketStacks[stack] != null) continue;
                    if (stack == playerStats.rocketStacks.length - 1) {
                        if (playerStats.rocketItem == null) continue;
                        playerStats.rocketStacks[stack] = new ItemStack(playerStats.rocketItem, 1, playerStats.rocketType);
                        continue;
                    }
                    if (stack != playerStats.rocketStacks.length - 2) continue;
                    playerStats.rocketStacks[stack] = playerStats.launchpadStack;
                    playerStats.launchpadStack = null;
                }
                if (playerStats.chestSpawnCooldown == 0) {
                    playerStats.chestSpawnVector = type.getParaChestSpawnLocation((WorldServer)entity.field_70170_p, player, new Random());
                    playerStats.chestSpawnCooldown = 200;
                }
            }
        } else {
            GCPlayerHandler.setUsingParachute((EntityPlayerMP)player, (GCPlayerStats)playerStats, (boolean)false);
            ItemShuttle shuttle = (ItemShuttle)playerStats.rocketItem;
            if (GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown <= 0) {
                if (player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                ShuttleTeleportHelper.landInShuttle(worldNew, player, shuttle, spawnPos);
                GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown = 10;
            }
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)((EntityPlayerMP)entity), oldDimID, dimID);
        return entity;
    }

    private static void landInShuttle(World world, EntityPlayerMP player, ItemShuttle item, Vector3 spawnPos) {
        ItemStack[] cargoStack;
        EntityShuttle shuttle;
        block4: {
            GCPlayerStats playerStats;
            block5: {
                playerStats = GCPlayerStats.get((EntityPlayerMP)player);
                if (world.field_73011_w instanceof IExitHeight && ((IExitHeight)world.field_73011_w).getYCoordinateToTeleport() - 10.0 <= spawnPos.y) {
                    spawnPos.y = ((IExitHeight)world.field_73011_w).getYCoordinateToTeleport() - 10.0;
                }
                Vector3int dock = null;
                Vector3 itemDropPosition = spawnPos.clone();
                if ((world.field_73011_w instanceof MothershipWorldProvider || world.field_73011_w instanceof IOrbitDimension) && (dock = ShuttleDockHandler.findAvailableDock(world.field_73011_w.field_76574_g)) != null) {
                    double yTemp = spawnPos.y;
                    spawnPos = dock.toVector3();
                    spawnPos.y = yTemp;
                    itemDropPosition = spawnPos.clone();
                }
                shuttle = item.spawnRocketEntity(new ItemStack(playerStats.rocketItem, 1, playerStats.rocketType), world, spawnPos.x, spawnPos.y, spawnPos.z);
                if (dock != null) {
                    shuttle.setTargetDock(dock);
                }
                shuttle.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, playerStats.fuelLevel));
                cargoStack = (ItemStack[])playerStats.rocketStacks.clone();
                if (playerStats.launchpadStack == null || playerStats.launchpadStack.field_77994_a <= 0 || playerStats.launchpadStack.func_77973_b() == null) break block4;
                if (shuttle.rocketType.getInventorySpace() > 2) break block5;
                if (player.field_71071_by.func_70441_a(playerStats.launchpadStack)) break block4;
                WorldHelper.dropItemInWorld(world, playerStats.launchpadStack, itemDropPosition.x, itemDropPosition.y, itemDropPosition.z);
                break block4;
            }
            for (int i = 0; i < cargoStack.length; ++i) {
                if (cargoStack[i] != null) continue;
                cargoStack[i] = playerStats.launchpadStack;
                playerStats.launchpadStack = null;
                break;
            }
        }
        shuttle.setCargoContents(cargoStack);
        playerStats.rocketStacks = new ItemStack[2];
        shuttle.func_70080_a(spawnPos.x, spawnPos.y, spawnPos.z, 0.0f, 0.0f);
        player.func_70080_a(spawnPos.x, spawnPos.y, spawnPos.z, player.field_70177_z, player.field_70125_A);
        player.func_70078_a((Entity)shuttle);
        shuttle.setLanding();
    }

    private static HashMap<String, Integer> getArrayOfChildren(EntityPlayerMP playerBase, CelestialBody body) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (body.getReachable()) {
            int planetId = body.getDimensionID();
            result.put(body.getName(), planetId);
            for (Integer element : WorldUtil.registeredSpaceStations.keySet()) {
                SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)element, null);
                if (data.getHomePlanet() != planetId) continue;
                CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)element);
                if (celestialBody == null) {
                    celestialBody = GalacticraftCore.satelliteSpaceStation;
                }
                result.put(celestialBody.getName() + "$" + data.getOwner() + "$" + data.getSpaceStationName() + "$" + element + "$" + data.getHomePlanet(), element);
            }
        }
        MothershipWorldData msData = TickHandlerServer.mothershipData;
        List<Mothership> msList = msData.getMothershipsForParent(body);
        for (Mothership m : msList) {
            result.put(m.getName(), m.getDimensionID());
        }
        return result;
    }

    public static CelestialBody getParentPlanet(CelestialBody body) {
        if (body instanceof Planet) {
            return body;
        }
        if (body instanceof Moon) {
            return ((Moon)body).getParentPlanet();
        }
        if (body instanceof Satellite) {
            return ((Satellite)body).getParentPlanet();
        }
        if (body instanceof Mothership) {
            CelestialBody parent = ((Mothership)body).getParent();
            return ShuttleTeleportHelper.getParentPlanet(parent);
        }
        return null;
    }

    public static CelestialBody getReachableCelestialBodiesForName(String name) {
        Mothership ms = TickHandlerServer.mothershipData.getByName(name);
        if (ms != null) {
            return ms;
        }
        return WorldUtil.getReachableCelestialBodiesForName((String)name);
    }

    public static CelestialBody getAnyCelestialBodyForName(String name) {
        Mothership ms = TickHandlerServer.mothershipData.getByName(name);
        if (ms != null) {
            return ms;
        }
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getName().equals(name)) continue;
            return cBody;
        }
        return null;
    }

    public static CelestialBody getCelestialBodyForDimensionID(int id) {
        CelestialBody defaultBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)id);
        if (defaultBody != null) {
            return defaultBody;
        }
        return TickHandlerServer.mothershipData.getByDimensionId(id);
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(EntityPlayerMP playerBase) {
        CelestialBody playerBody = ShuttleTeleportHelper.getCelestialBodyForDimensionID(playerBase.field_71093_bK);
        if (playerBody == null) {
            int parentID;
            CelestialBody parentBody;
            SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)playerBase.field_71093_bK, null);
            if (data != null && (parentBody = ShuttleTeleportHelper.getCelestialBodyForDimensionID(parentID = data.getHomePlanet())) != null) {
                return ShuttleTeleportHelper.getArrayOfChildren(playerBase, parentBody);
            }
            return new HashMap<String, Integer>();
        }
        if (playerBody instanceof Mothership) {
            playerBody = ((Mothership)playerBody).getParent();
        }
        return ShuttleTeleportHelper.getArrayOfChildren(playerBase, playerBody);
    }
}

