/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_TieredTank
extends GT_MetaTileEntity_BasicTank {
    public GT_MetaTileEntity_TieredTank(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "Stores " + GT_Utility.formatNumbers((long)((int)(Math.pow(2.0, aTier) * 32000.0))) + "L of fluid", new ITexture[0]);
    }

    public GT_MetaTileEntity_TieredTank(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>(Arrays.asList(this.mDescriptionArray));
        description.add("A portable tank.");
        if (this.mFluid != null) {
            description.add("Fluid: " + this.mFluid.getLocalizedName() + " " + this.mFluid.amount + "L");
        }
        description.add(CORE.GT_Tooltip.get());
        return description.toArray(new String[0]);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (side == ForgeDirection.UP) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER_ACTIVE);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER);
        }
        return iTextureArray;
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        FluidStack tContents;
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("mFluid") && (tContents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d.func_74775_l("mFluid"))) != null && tContents.amount > 0) {
            tooltip.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_TANK_INFO", (String)"Contains Fluid: ", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.YELLOW + tContents.getLocalizedName() + EnumChatFormatting.GRAY);
            tooltip.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_TANK_AMOUNT", (String)"Fluid Amount: ", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)tContents.amount) + " L" + EnumChatFormatting.GRAY);
        }
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public final byte getUpdateData() {
        return 0;
    }

    public boolean doesFillContainers() {
        return true;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public String[] getInfoData() {
        if (this.mFluid == null) {
            return new String[]{GT_Values.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", "No Fluid", "0L", this.getCapacity() + "L"};
        }
        return new String[]{GT_Values.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", this.mFluid.getLocalizedName(), this.mFluid.amount + "L", this.getCapacity() + "L"};
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TieredTank(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public int getCapacity() {
        return (int)(Math.pow(2.0, this.mTier) * 32000.0);
    }

    public int getTankPressure() {
        return 100;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            Logger.WARNING("Setting item fluid nbt");
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
            if (aNBT.func_74764_b("mFluid")) {
                Logger.WARNING("Set mFluid to NBT.");
            }
        }
    }

    public boolean useModularUI() {
        return true;
    }
}

