/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import gregtech.api.util.IGT_HatchAdder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusOutput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GT_MetaTileEntity_Hatch_CustomFluidBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GregtechMeta_SteamMultiBase<T extends GregtechMeta_SteamMultiBase<T>>
extends GregtechMeta_MultiBlockBase<T> {
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusInput> mSteamInputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusOutput> mSteamOutputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_CustomFluidBase> mSteamInputFluids = new ArrayList();
    protected static final String TT_steaminputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamInputBus");
    protected static final String TT_steamoutputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamOutputBus");
    protected static final String TT_steamhatch = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamHatch");

    public GregtechMeta_SteamMultiBase(String aName) {
        super(aName);
    }

    public GregtechMeta_SteamMultiBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    protected abstract GT_RenderedTexture getFrontOverlay();

    protected abstract GT_RenderedTexture getFrontOverlayActive();

    private int getCasingTextureIndex() {
        return 10;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Values.V[1]);
        logic.setAvailableAmperage((long)this.getMaxParallelRecipes());
        logic.setAmperageOC(false);
    }

    public ArrayList<FluidStack> getAllSteamStacks() {
        ArrayList<FluidStack> aFluids = new ArrayList<FluidStack>();
        FluidStack aSteam = FluidUtils.getSteam(1);
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(aSteam)) continue;
            aFluids.add(aFluid);
        }
        return aFluids;
    }

    public int getTotalSteamStored() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getAllSteamStacks()) {
            aSteam += aFluid.amount;
        }
        return aSteam;
    }

    public boolean tryConsumeSteam(int aAmount) {
        if (this.getTotalSteamStored() <= 0) {
            return false;
        }
        return this.depleteInput(FluidUtils.getSteam(aAmount));
    }

    public int getMaxEfficiency(ItemStack arg0) {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mSteamInputs.clear();
            this.mSteamOutputs.clear();
            this.mSteamInputFluids.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        long aSteamVal;
        this.fixAllMaintenanceIssue();
        if (this.lEUt < 0L && !this.tryConsumeSteam((int)(aSteamVal = -this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency)))) {
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return false;
        }
        return true;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            this.log("Invalid IGregTechTileEntity");
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            this.log("Invalid IMetaTileEntity");
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_CustomFluidBase) {
            this.log("Adding Steam Input Hatch");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputFluids, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
            this.log("Trying to set recipe map. Type: " + (this.getRecipeMap() != null ? this.getRecipeMap().unlocalizedName : "Null"));
            this.resetRecipeMapForHatch(aTileEntity, this.getRecipeMap());
            this.log("Adding Steam Input Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusOutput) {
            this.log("Adding Steam Output Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamOutputs, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_CustomFluidBase tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputFluids)) {
            FluidStack tLiquid = tHatch.getFluid();
            if (tLiquid == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((ItemStack)aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputFluids)) {
            if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)tHatch.getBaseMetaTileEntity().func_70301_a(0)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputs)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)tHatch.getBaseMetaTileEntity().func_70301_a(i)) || tHatch.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                tHatch.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_CustomFluidBase tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputFluids)) {
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusInput tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputs)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((ItemStack)aStack)) {
            return false;
        }
        aStack = GT_Utility.copy((ItemStack)aStack);
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamOutputs)) {
                if (outputSuccess) continue;
                for (int i = tHatch.func_70302_i_() - 1; i >= 0 && !outputSuccess; --i) {
                    if (!tHatch.getBaseMetaTileEntity().addStackToSlot(i, single)) continue;
                    outputSuccess = true;
                }
            }
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mOutputHatches)) {
                if (outputSuccess || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamOutputs)) {
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch tBus : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamOutputs)) {
            IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
            for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                ret.add(tBus.func_70301_a(i));
            }
        }
        return ret;
    }

    @Override
    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputFluids)) {
            tHatch.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mSteamInputs)) {
            tHatch.updateSlots();
        }
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mSteamInputFluids.clear();
        this.mSteamInputs.clear();
        this.mSteamOutputs.clear();
    }

    @Override
    public boolean resetRecipeMapForAllInputHatches(RecipeMap<?> aMap) {
        boolean ret = super.resetRecipeMapForAllInputHatches(aMap);
        for (GT_MetaTileEntity_Hatch_Steam_BusInput hatch : this.mSteamInputs) {
            if (!this.resetRecipeMapForHatch(hatch, aMap)) continue;
            ret = true;
        }
        return ret;
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        long actualEnergyUsage;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        }
        currentTip.add((tag.func_74767_n("hasProblems") ? SpecialChars.RED + "** HAS PROBLEMS **" : SpecialChars.GREEN + "Running Fine") + SpecialChars.RESET + "  Efficiency: " + tag.func_74760_g("efficiency") + "%");
        boolean isActive = tag.func_74767_n("isActive");
        if (isActive && (actualEnergyUsage = tag.func_74763_f("energyUsage")) > 0L) {
            currentTip.add(StatCollector.func_74837_a((String)"GTPP.waila.steam.use", (Object[])new Object[]{GT_Utility.formatNumbers((long)actualEnergyUsage)}));
        }
        currentTip.add(GT_Waila.getMachineProgressString((boolean)isActive, (int)tag.func_74762_e("maxProgress"), (int)tag.func_74762_e("progress")));
        if (GT_Mod.gregtechproxy.wailaAverageNS && tag.func_74764_b("averageNS")) {
            int tAverageTime = tag.func_74762_e("averageNS");
            currentTip.add("Average CPU load of ~" + GT_Utility.formatNumbers((long)tAverageTime) + " ns");
        }
        super.getMTEWailaBody(itemStack, currentTip, accessor, config);
    }

    protected static <T extends GregtechMeta_SteamMultiBase<T>> GT_HatchElementBuilder<T> buildSteamInput(Class<T> typeToken) {
        return GT_StructureUtility.buildHatchAdder(typeToken).adder(GregtechMeta_SteamMultiBase::addToMachineList).hatchIds(new int[]{31040}).shouldReject(t -> !t.mSteamInputFluids.isEmpty());
    }

    protected static enum SteamHatchElement implements IHatchElement<GregtechMeta_SteamMultiBase<?>>
    {
        InputBus_Steam{

            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(GT_MetaTileEntity_Hatch_Steam_BusInput.class);
            }

            public long count(GregtechMeta_SteamMultiBase<?> t) {
                return t.mSteamInputs.size();
            }
        }
        ,
        OutputBus_Steam{

            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(GT_MetaTileEntity_Hatch_Steam_BusOutput.class);
            }

            public long count(GregtechMeta_SteamMultiBase<?> t) {
                return t.mSteamOutputs.size();
            }
        };


        public IGT_HatchAdder<? super GregtechMeta_SteamMultiBase<?>> adder() {
            return GregtechMeta_SteamMultiBase::addToMachineList;
        }
    }
}

