/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import gregtech.api.util.GT_ModHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.CargoRocketRecipeHandler;
import micdoodle8.mods.galacticraft.planets.mars.nei.GCMarsNEIHighlightHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEIGalacticraftMarsConfig
implements IConfigureNEI {
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> cargoBenchRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> liquefierRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> synthesizerRecipes = new HashMap();
    public static GCMarsNEIHighlightHandler planetsHighlightHandler = new GCMarsNEIHighlightHandler();

    public void loadConfig() {
        this.registerRecipes();
        API.registerRecipeHandler((ICraftingHandler)new CargoRocketRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CargoRocketRecipeHandler());
        API.registerHighlightIdentifier((Block)MarsBlocks.marsBlock, (IHighlightHandler)planetsHighlightHandler);
    }

    public String getName() {
        return "Galacticraft Mars NEI Plugin";
    }

    public String getVersion() {
        return "3.1.5-GTNH";
    }

    public void registerRocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerCargoBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        cargoBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getCargoBenchRecipes() {
        return cargoBenchRecipes.entrySet();
    }

    private void registerLiquefierRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        liquefierRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getLiquefierRecipes() {
        return liquefierRecipes.entrySet();
    }

    private void registerSynthesizerRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        synthesizerRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getSynthesizerRecipes() {
        return synthesizerRecipes.entrySet();
    }

    public void registerRecipes() {
        ArrayList<PositionedStack> input = new ArrayList<PositionedStack>();
        ArrayList<Object> input2 = new ArrayList<PositionedStack>();
        int x = 4;
        int y = 16;
        input.add(new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 14), 130, -6));
        if (GalacticraftCore.isGalaxySpaceLoaded) {
            input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.RocketControlComputer", (long)1L, (int)101), 130, 12));
            input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.ModuleSmallFuelCanister", (long)1L), 112, 3));
            input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.ModuleSmallFuelCanister", (long)1L), 148, 3));
            input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.ModuleSmallFuelCanister", (long)1L), 112, 21));
        }
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partNoseCone), 49, 3));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                input.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 44 + j * 18 - 4, 37 + i * 18 - 16));
            }
        }
        input.add(new PositionedStack((Object)new ItemStack(GCItems.rocketEngine), 49, 93));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 22, 75));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 76, 75));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 22, 93));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.partFins), 76, 93));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 3), 130, 30));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 11), 130, 57));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 0), 130, 30));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 12), 130, 57));
        input2 = new ArrayList(input);
        input2.add(new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 1), 130, 30));
        this.registerCargoBenchRecipe(input2, new PositionedStack((Object)new ItemStack(MarsItems.spaceship, 1, 13), 130, 57));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 23, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(MarsItems.carbonFragments, 25, 0), 23, 49), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
    }
}

