/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import gregtech.api.util.GT_ModHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.nei.AstroMinerRecipeHandler;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.NEIGalacticraftMarsConfig;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEIGalacticraftAsteroidsConfig
implements IConfigureNEI {
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> astroMinerRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        API.registerRecipeHandler((ICraftingHandler)new AstroMinerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AstroMinerRecipeHandler());
        API.registerHighlightIdentifier((Block)AsteroidBlocks.blockBasic, (IHighlightHandler)NEIGalacticraftMarsConfig.planetsHighlightHandler);
    }

    public String getName() {
        return "Galacticraft Asteroids NEI Plugin";
    }

    public String getVersion() {
        return "3.1.5-GTNH";
    }

    public void registerRocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public void registerAstroMinerRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        astroMinerRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getAstroMinerRecipes() {
        return astroMinerRecipes.entrySet();
    }

    public void registerRecipes() {
        ArrayList<PositionedStack> input = new ArrayList<PositionedStack>();
        int x = 4;
        int y = 16;
        input = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                input.add(new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 44 + j * 18 - 4, 19 + i * 72 - 16));
            }
        }
        input.add(new PositionedStack((Object)new ItemStack(GCItems.flagPole), 112, 3));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.flagPole), 112, 75));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem), 22, 21));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem), 4, 39));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem), 22, 57));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.orionDrive), 40, 21));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.orionDrive), 22, 39));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.orionDrive), 40, 39));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.orionDrive), 58, 39));
        if (GalacticraftCore.isGalaxySpaceLoaded) {
            input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.RocketControlComputer", (long)1L, (int)102), 58, 21));
        }
        input.add(new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 14), 76, 21));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 14), 94, 21));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 112, 21));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 112, 39));
        input.add(new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 112, 57));
        input.add(new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 1), 76, 39));
        input.add(new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 1), 94, 39));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 8), 40, 57));
        input.add(new PositionedStack((Object)new ItemStack(AsteroidBlocks.beamReceiver), 58, 57));
        input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)32603), 76, 57));
        input.add(new PositionedStack((Object)GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)32603), 94, 57));
        this.registerAstroMinerRecipe(input, new PositionedStack((Object)new ItemStack(AsteroidsItems.astroMiner), 139, 39));
    }
}

