/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.FermenterRecipe;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Fermenter")
public class Fermenter {
    public static final String name = "Forestry Fermenter";
    public static final String nameFuel = "Forestry Fermenter (Fuel)";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new FermenterRecipe(InputHelper.toStack(resource), fermentationValue, fluidOutputModifier, InputHelper.getFluid(fluidOutput), InputHelper.toFluid(fluidInput))));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier, ILiquidStack fluidOutput) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new FermenterRecipe(InputHelper.toStack(resource), fermentationValue, fluidOutputModifier, InputHelper.getFluid(fluidOutput), InputHelper.toFluid(fluidInput))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<IFermenterRecipe> recipes = new LinkedList<IFermenterRecipe>();
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            if (recipe != null && recipe.getResource() != null && StackHelper.matches(input, InputHelper.toIItemStack(recipe.getResource()))) {
                recipes.add(recipe);
            }
            if (recipe == null || recipe.getResource() == null || !StackHelper.matches(input, InputHelper.toILiquidStack(recipe.getFluidResource()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, int fermentPerCycle, int burnDuration) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(new FermenterFuel(InputHelper.toStack(item), fermentPerCycle, burnDuration)));
    }

    @ZenMethod
    public static void removeFuel(IIngredient fermenterItem) {
        HashMap<ItemStack, FermenterFuel> fuelItems = new HashMap<ItemStack, FermenterFuel>();
        for (Map.Entry fuelItem : FuelManager.fermenterFuel.entrySet()) {
            if (fuelItem == null || !StackHelper.matches(fermenterItem, InputHelper.toIItemStack(((FermenterFuel)fuelItem.getValue()).item))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (FermenterFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, fermenterItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, FermenterFuel> {
        public RemoveFuel(Map<ItemStack, FermenterFuel> recipes) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, FermenterFuel> {
        public AddFuel(FermenterFuel fuelEntry) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel);
            this.recipes.put(fuelEntry.item, fuelEntry);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class Remove
    extends ForestryListRemoval<IFermenterRecipe, IFermenterManager> {
        public Remove(List<IFermenterRecipe> recipes) {
            super(Fermenter.name, RecipeManagers.fermenterManager, recipes);
        }

        @Override
        protected String getRecipeInfo(IFermenterRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends ForestryListAddition<IFermenterRecipe, IFermenterManager> {
        public Add(IFermenterRecipe recipe) {
            super(Fermenter.name, RecipeManagers.fermenterManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFermenterRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

