/*
 * Decompiled with CFR 0.152.
 */
package com.elisis.gtnhlanth.loader;

import com.elisis.gtnhlanth.common.register.WerkstoffMaterialPool;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ZPMRubberChanges
implements Runnable {
    @Override
    public void run() {
        List bufferedRecipeList = null;
        try {
            bufferedRecipeList = (List)FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        HashSet<ItemStack> ZPMPlusComponents = new HashSet<ItemStack>();
        OrePrefixes[] RubberGenerated = new OrePrefixes[]{OrePrefixes.plate};
        Arrays.stream(ItemList.values()).filter(item -> (item.toString().contains("ZPM") || item.toString().contains("UV") || item.toString().contains("UHV") || item.toString().contains("UEV")) && item.hasBeenSet()).forEach(item -> ZPMPlusComponents.add(item.get(1L, new Object[0])));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            ZPMRubberChanges.addDreamcraftItemListItems(ZPMPlusComponents);
        }
        for (ItemStack component : ZPMPlusComponents) {
            GT_Log.out.print(component.func_82833_r() + " ");
        }
        ZPMRubberChanges.replaceAllRecipes(ZPMPlusComponents, RubberGenerated, bufferedRecipeList);
    }

    private static void replaceAllRecipes(Collection<ItemStack> ZPMPlusComponents, OrePrefixes[] RubberGenerated, List<IRecipe> bufferedRecipeList) {
        for (GT_Recipe.GT_Recipe_AssemblyLine sAssemblylineRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
            for (ItemStack stack : ZPMPlusComponents) {
                ZPMRubberChanges.rewriteAsslineRecipes(stack, RubberGenerated, sAssemblylineRecipe);
            }
        }
        for (RecipeMap map : RecipeMap.ALL_RECIPE_MAPS.values()) {
            for (GT_Recipe recipe : map.getAllRecipes()) {
                for (ItemStack stack : ZPMPlusComponents) {
                    ZPMRubberChanges.rewriteMachineRecipes(stack, RubberGenerated, recipe);
                }
            }
        }
        for (ItemStack stack : ZPMPlusComponents) {
            Predicate<Object> recipeFilter = obj -> obj instanceof GT_Shaped_Recipe && GT_Utility.areStacksEqual((ItemStack)((GT_Shaped_Recipe)obj).func_77571_b(), (ItemStack)stack, (boolean)true);
            ZPMRubberChanges.rewriteCraftingRecipes(bufferedRecipeList, RubberGenerated, recipeFilter);
        }
    }

    private static void addDreamcraftItemListItems(Collection ZPMPlusComponents) {
        try {
            Class<?> customItemListClass = Class.forName("com.dreammaster.gthandler.CustomItemList");
            Method hasnotBeenSet = MethodUtils.getAccessibleMethod(customItemListClass, (String)"hasBeenSet", (Class[])new Class[0]);
            Method get = MethodUtils.getAccessibleMethod(customItemListClass, (String)"get", (Class[])new Class[]{Long.TYPE, Object[].class});
            for (Enum customItemList : (Enum[])FieldUtils.getField(customItemListClass, (String)"$VALUES", (boolean)true).get(null)) {
                if (!customItemList.toString().contains("ZPM") && !customItemList.toString().contains("UV") && !customItemList.toString().contains("UHV") && !customItemList.toString().contains("UEV") || !((Boolean)hasnotBeenSet.invoke((Object)customItemList, new Object[0])).booleanValue()) continue;
                ZPMPlusComponents.add((ItemStack)get.invoke((Object)customItemList, 1, new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void rewriteCraftingRecipes(List<IRecipe> bufferedRecipeList, OrePrefixes[] RubberGenerated, Predicate recipeFilter) {
        for (OrePrefixes prefixes : RubberGenerated) {
            Consumer<Object> recipeAction = obj -> {
                ZPMRubberChanges.doStacksCointainAndReplace(((GT_Shaped_Recipe)obj).getInput(), GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(((GT_Shaped_Recipe)obj).getInput(), GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            };
            CraftingManager.func_77594_a().func_77592_b().stream().filter(recipeFilter).forEach(recipeAction);
            bufferedRecipeList.stream().filter(recipeFilter).forEach(recipeAction);
        }
    }

    private static void rewriteMachineRecipes(ItemStack stack, OrePrefixes[] RubberGenerated, GT_Recipe recipe) {
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : RubberGenerated) {
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicon, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : RubberGenerated) {
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
    }

    private static void rewriteAsslineRecipes(ItemStack stack, OrePrefixes[] RubberGenerated, GT_Recipe.GT_Recipe_AssemblyLine recipe) {
        for (OrePrefixes prefixes : RubberGenerated) {
            if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
                GT_Log.out.print(Arrays.toString(recipe.mInputs));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            if (!ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) continue;
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Silicone, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.StyreneButadieneRubber, (long)1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) {
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
    }

    private static ItemStack[] replaceArrayWith(ItemStack[] stackArray, Materials source, Werkstoff target) {
        for (int i = 0; i < stackArray.length; ++i) {
            ItemStack stack = stackArray[i];
            if (!BW_Util.checkStackAndPrefix((ItemStack)stack)) continue;
            stackArray[i] = ZPMRubberChanges.replaceStackWith(stack, source, target);
        }
        return stackArray;
    }

    private static ItemStack replaceStackWith(ItemStack stack, Materials source, Werkstoff target) {
        ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
        if (ass.mMaterial.mMaterial.equals(source) && target.hasItemType(ass.mPrefix)) {
            stack = target.get(ass.mPrefix, stack.field_77994_a);
        }
        return stack;
    }

    private static boolean doStacksCointainAndReplace(FluidStack[] stacks, FluidStack stack, boolean replace, Fluid ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)stack, (FluidStack)stacks[i])) continue;
            if (!replace) {
                return true;
            }
            int amount = stacks[i].amount;
            stacks[i] = new FluidStack(replacement[0], amount);
            replaced = true;
        }
        return replaced;
    }

    private static boolean doStacksCointainAndReplace(Object[] stacks, ItemStack stack, boolean replace, ItemStack ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            int amount;
            if (!GT_Utility.isStackValid((Object)stacks[i])) {
                if (!(stacks[i] instanceof ArrayList) || ((ArrayList)stacks[i]).size() <= 0 || !GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)((ArrayList)stacks[i]).get(0)), (boolean)true)) continue;
                if (!replace) {
                    return true;
                }
                amount = ((ItemStack)((ArrayList)stacks[i]).get((int)0)).field_77994_a;
                stacks[i] = new ArrayList();
                ((ArrayList)stacks[i]).add(BW_Util.setStackSize((ItemStack)replacement[0], (int)amount));
                replaced = true;
                GT_Log.out.print("Replaced recipe!: " + stack.func_82833_r() + " ");
                continue;
            }
            if (!GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)stacks[i]), (boolean)true)) continue;
            if (!replace) {
                return true;
            }
            amount = ((ItemStack)stacks[i]).field_77994_a;
            stacks[i] = BW_Util.setStackSize((ItemStack)replacement[0], (int)amount);
            replaced = true;
        }
        return replaced;
    }
}

