/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.block.Block;

public class GT_BlockMap<V> {
    public static final byte WILDCARD = -1;
    private final ConcurrentHashMap<Block, TByteObjectMap<V>> backing = new ConcurrentHashMap();
    private int size = 0;

    private TByteObjectMap<V> getSubmap(Block block) {
        return this.backing.computeIfAbsent(block, b -> new TByteObjectHashMap());
    }

    public V put(Block block, byte meta, V value) {
        Object v = this.getSubmap(block).put(meta, value);
        if (v == null) {
            ++this.size;
        }
        return (V)v;
    }

    public V putIfAbsent(Block block, byte meta, V value) {
        Object v = this.getSubmap(block).putIfAbsent(meta, value);
        if (v == null) {
            ++this.size;
        }
        return (V)v;
    }

    public V computeIfAbsent(Block block, byte meta, BiFunction<Block, Byte, V> function) {
        TByteObjectMap<V> submap = this.getSubmap(block);
        Object v = submap.get(meta);
        if (v == null) {
            v = function.apply(block, meta);
            submap.put(meta, v);
            ++this.size;
        }
        return (V)v;
    }

    public boolean containsKey(Block block, byte meta) {
        TByteObjectMap<V> submap = this.backing.get(block);
        if (submap == null) {
            return false;
        }
        return submap.containsKey(meta) || submap.containsKey((byte)-1);
    }

    public V get(Block block, byte meta) {
        TByteObjectMap<V> submap = this.backing.get(block);
        if (submap == null) {
            return null;
        }
        Object v = submap.get(meta);
        if (v != null) {
            return (V)v;
        }
        return (V)submap.get((byte)-1);
    }

    public V remove(Block block, byte meta) {
        TByteObjectMap<V> submap = this.backing.get(block);
        if (submap == null) {
            return null;
        }
        Object v = submap.remove(meta);
        if (v != null) {
            --this.size;
            if (submap.isEmpty()) {
                this.backing.remove(block);
            }
        }
        return (V)v;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GT_BlockMap that = (GT_BlockMap)o;
        return this.backing.equals(that.backing);
    }

    public int hashCode() {
        return this.backing.hashCode();
    }
}

