/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GT_Utility;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;

public class ResultInsufficientHeat
implements CheckRecipeResult {
    private int required;

    ResultInsufficientHeat(int required) {
        this.required = required;
    }

    @Override
    @Nonnull
    public String getID() {
        return "insufficient_heat";
    }

    @Override
    public boolean wasSuccessful() {
        return false;
    }

    @Override
    @Nonnull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.insufficient_heat", (Object[])new Object[]{GT_Utility.formatNumbers(this.required), HeatingCoilLevel.getDisplayNameFromHeat(this.required, true)}));
    }

    @Override
    @Nonnull
    public CheckRecipeResult newInstance() {
        return new ResultInsufficientHeat(0);
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.required);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buffer) {
        this.required = buffer.func_150792_a();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultInsufficientHeat that = (ResultInsufficientHeat)o;
        return this.required == that.required;
    }
}

