/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.interfaces;

import cpw.mods.fml.common.Optional;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityItemInternal;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import squeek.applecore.api.food.FoodValues;

public interface IMultiTileEntity
extends ICoverable,
ITurnable,
IDebugableTileEntity {
    public short getMultiTileEntityID();

    public short getMultiTileEntityRegistryID();

    public void initFromNBT(NBTTagCompound var1, short var2, short var3);

    public NBTTagCompound writeItemNBT(NBTTagCompound var1);

    public void setCustomName(String var1);

    public String getCustomName();

    public String getTileEntityName();

    public void onRegistrationFirst(MultiTileEntityRegistry var1, short var2);

    public void onTileEntityPlaced();

    @Override
    public boolean isDead();

    public void loadTextures(String var1);

    public void copyTextures();

    public void issueClientUpdate();

    public void sendClientData(EntityPlayerMP var1);

    public boolean receiveClientData(int var1, int var2);

    public void setShouldRefresh(boolean var1);

    public void addCollisionBoxesToList(AxisAlignedBB var1, List<AxisAlignedBB> var2, Entity var3);

    public AxisAlignedBB getCollisionBoundingBoxFromPool();

    public AxisAlignedBB getSelectedBoundingBoxFromPool();

    public void setBlockBoundsBasedOnState(Block var1);

    public void onBlockAdded();

    public boolean playerOwnsThis(EntityPlayer var1, boolean var2);

    public boolean privateAccess();

    @Override
    public long getTimer();

    public String setOwnerName(String var1);

    public String getOwnerName();

    public UUID getOwnerUuid();

    public void setOwnerUuid(UUID var1);

    public void issueTextureUpdate();

    public boolean unpaint();

    public boolean isPainted();

    public boolean paint(int var1);

    public int getPaint();

    public boolean setMainFacing(ForgeDirection var1);

    public boolean isFacingValid(ForgeDirection var1);

    public void onFacingChange();

    @Override
    default public void setFrontFacing(ForgeDirection side) {
        this.setMainFacing(side);
    }

    public boolean shouldTriggerBlockUpdate();

    public void onMachineBlockUpdate();

    public boolean allowInteraction(Entity var1);

    default public void onLeftClick(EntityPlayer aPlayer) {
    }

    public boolean onBlockActivated(EntityPlayer var1, ForgeDirection var2, float var3, float var4, float var5);

    public boolean onRightClick(EntityPlayer var1, ForgeDirection var2, float var3, float var4, float var5);

    public ArrayList<ItemStack> getDrops(int var1, boolean var2);

    public boolean isSideSolid(ForgeDirection var1);

    public float getExplosionResistance(Entity var1, double var2, double var4, double var6);

    public float getExplosionResistance();

    public void onExploded(Explosion var1);

    public boolean recolourBlock(ForgeDirection var1, byte var2);

    public boolean getSubItems(MultiTileEntityBlockInternal var1, Item var2, CreativeTabs var3, List<ItemStack> var4, short var5);

    public ItemStack getPickBlock(MovingObjectPosition var1);

    public boolean shouldSideBeRendered(ForgeDirection var1);

    public boolean isSurfaceOpaque(ForgeDirection var1);

    public boolean onPlaced(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, ForgeDirection var7, float var8, float var9, float var10);

    public static interface IMTE_HasModes
    extends IMultiTileEntity {
        public int getMode();

        public void setMode(int var1);

        public int getAllowedModes();

        public void setAllowedModes(int var1);
    }

    public static interface IMTE_AddToolTips
    extends IMultiTileEntity {
        public void addToolTips(List<String> var1, ItemStack var2, boolean var3);
    }

    public static interface IMTE_GetMaxStackSize
    extends IMultiTileEntity {
        public byte getMaxStackSize(ItemStack var1, byte var2);
    }

    public static interface IMTE_CanPlace
    extends IMultiTileEntity {
        public boolean canPlace(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, ForgeDirection var7, float var8, float var9, float var10);
    }

    public static interface IMTE_IgnoreEntityCollisionWhenPlacing
    extends IMultiTileEntity {
        public boolean ignoreEntityCollisionWhenPlacing(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, ForgeDirection var7, float var8, float var9, float var10);
    }

    public static interface IMTE_OnlyPlaceableWhenSneaking
    extends IMultiTileEntity {
        public boolean onlyPlaceableWhenSneaking();
    }

    public static interface IMTE_GetFoodValues
    extends IMultiTileEntity {
        @Optional.Method(modid="AppleCore")
        public FoodValues getFoodValues(MultiTileEntityItemInternal var1, ItemStack var2);
    }

    public static interface IMTE_GetBlockHardness
    extends IMultiTileEntity {
        public float getBlockHardness();
    }

    public static interface IMTE_HasMultiBlockMachineRelevantData
    extends IMultiTileEntity {
        public boolean hasMultiBlockMachineRelevantData();
    }

    public static interface IMTE_BreakBlock
    extends IMultiTileEntity {
        public boolean breakBlock();
    }

    public static interface IMTE_GetComparatorInputOverride
    extends IMultiTileEntity {
        public int getComparatorInputOverride(ForgeDirection var1);
    }

    public static interface IMTE_GetWeakChanges
    extends IMultiTileEntity {
        public boolean getWeakChanges();
    }

    public static interface IMTE_ShouldCheckWeakPower
    extends IMultiTileEntity {
        public boolean shouldCheckWeakPower(ForgeDirection var1);
    }

    public static interface IMTE_IsProvidingStrongPower
    extends IMultiTileEntity {
        public int isProvidingStrongPower(ForgeDirection var1);
    }

    public static interface IMTE_IsProvidingWeakPower
    extends IMultiTileEntity {
        public int isProvidingWeakPower(ForgeDirection var1);
    }

    public static interface IMTE_OnNeighborBlockChange
    extends IMultiTileEntity {
        public void onNeighborBlockChange(World var1, Block var2);
    }
}

