/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import gregtech.api.enums.InventoryType;
import gregtech.api.logic.AbstractProcessingLogic;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class MuTEProcessingLogic<P extends MuTEProcessingLogic<P>>
extends AbstractProcessingLogic<P> {
    protected boolean hasWork;
    protected int progress;
    protected ProcessingLogicHost<P> machineHost;
    @Nonnull
    protected CheckRecipeResult recipeResult = CheckRecipeResultRegistry.NONE;
    @Nullable
    protected UUID itemOutputID;
    @Nullable
    protected UUID fluidOutputID;

    public P setMachineHost(@Nonnull ProcessingLogicHost<P> machineHost) {
        this.machineHost = machineHost;
        return (P)((MuTEProcessingLogic)this.getThis());
    }

    @Override
    @Nonnull
    public CheckRecipeResult process() {
        CheckRecipeResult recipeValidatorResult;
        RecipeMap<?> recipeMap = this.preProcess();
        ItemInventoryLogic itemInput = null;
        FluidInventoryLogic fluidInput = null;
        if (this.machineHost.isInputSeparated()) {
            for (Map.Entry<UUID, ItemInventoryLogic> itemEntry : this.machineHost.getAllItemInventoryLogics(InventoryType.Input)) {
                this.itemOutputID = Objects.requireNonNull(itemEntry.getKey());
                itemInput = Objects.requireNonNull(itemEntry.getValue());
                fluidInput = Objects.requireNonNull(this.machineHost.getFluidLogic(InventoryType.Input, itemInput.getConnectedFluidInventoryID()));
                this.fluidOutputID = itemInput.getConnectedFluidInventoryID();
            }
        } else {
            itemInput = Objects.requireNonNull(this.machineHost.getItemLogic(InventoryType.Input, null));
            fluidInput = Objects.requireNonNull(this.machineHost.getFluidLogic(InventoryType.Input, null));
        }
        if ((recipeValidatorResult = null) != null) {
            return recipeValidatorResult;
        }
        return this.processRecipe(null, Objects.requireNonNull(itemInput), Objects.requireNonNull(fluidInput));
    }

    @Nonnull
    protected CheckRecipeResult processRecipe(@Nonnull List<GT_Recipe> recipes, @Nonnull ItemInventoryLogic itemInput, @Nonnull FluidInventoryLogic fluidInput) {
        CheckRecipeResult result = CheckRecipeResultRegistry.INTERNAL_ERROR;
        for (GT_Recipe recipe : recipes) {
            Objects.requireNonNull(recipe);
            GT_ParallelHelper helper = this.createParallelHelper(recipe, itemInput, fluidInput);
            GT_OverclockCalculator calculator = this.createOverclockCalculator(recipe);
            helper.setCalculator(calculator);
            helper.build();
            result = helper.getResult();
            if (!result.wasSuccessful()) continue;
            return this.applyRecipe(recipe, helper, calculator, result);
        }
        return result;
    }

    @Nonnull
    protected Object findRecipe(@Nullable RecipeMap<?> map, @Nonnull ItemInventoryLogic itemInput, @Nonnull FluidInventoryLogic fluidInput) {
        if (map == null) {
            return false;
        }
        return true;
    }

    @Nonnull
    protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe, @Nonnull ItemInventoryLogic itemInput, @Nonnull FluidInventoryLogic fluidInput) {
        return new GT_ParallelHelper().setRecipe(recipe).setItemInputInventory(itemInput).setFluidInputInventory(fluidInput).setAvailableEUt(this.availableVoltage * this.availableAmperage).setMaxParallel(this.maxParallel).setEUtModifier(this.euModifier).enableBatchMode(this.batchSize).setConsumption(true).setOutputCalculation(true).setMuTEMode(true);
    }

    @Nonnull
    public CheckRecipeResult getResult() {
        return this.recipeResult;
    }

    public int getProgress() {
        return this.progress;
    }

    public void startCheck() {
        this.recipeResult = this.process();
    }

    public void progress() {
        if (!this.hasWork) {
            return;
        }
        if (this.progress == this.duration) {
            this.progress = 0;
            this.duration = 0;
            this.calculatedEut = 0L;
            this.output();
            return;
        }
        ++this.progress;
    }

    protected void output() {
        ItemInventoryLogic itemOutput = this.machineHost.getItemLogic(InventoryType.Output, this.itemOutputID);
        FluidInventoryLogic fluidOutput = this.machineHost.getFluidLogic(InventoryType.Output, this.fluidOutputID);
        if (itemOutput == null || fluidOutput == null) {
            return;
        }
        for (ItemStack itemStack : this.outputItems) {
            if (itemStack == null) continue;
            itemOutput.insertItem(itemStack);
        }
        for (ItemStack itemStack : this.outputFluids) {
            if (itemStack == null) continue;
            fluidOutput.fill(itemStack.getFluid(), itemStack.amount, false);
        }
        this.outputItems = new ItemStack[0];
        this.outputFluids = new FluidStack[0];
    }

    public boolean canWork() {
        return !this.hasWork && this.machineHost.isAllowedToWork();
    }

    public void increaseProgress(int progressAmount) {
        this.progress += progressAmount;
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound logicNBT = new NBTTagCompound();
        logicNBT.func_74772_a("eutConsumption", this.calculatedEut);
        logicNBT.func_74768_a("duration", this.duration);
        logicNBT.func_74768_a("progress", this.progress);
        logicNBT.func_74757_a("hasWork", this.hasWork);
        if (this.outputItems != null) {
            NBTTagList itemOutputsNBT = new NBTTagList();
            for (ItemStack itemStack : this.outputItems) {
                itemOutputsNBT.func_74742_a((NBTBase)GT_Utility.saveItem(itemStack));
            }
            logicNBT.func_74782_a("itemOutputs", (NBTBase)itemOutputsNBT);
        }
        if (this.outputFluids != null) {
            NBTTagList fluidOutputsNBT = new NBTTagList();
            for (ItemStack itemStack : this.outputFluids) {
                fluidOutputsNBT.func_74742_a((NBTBase)itemStack.writeToNBT(new NBTTagCompound()));
            }
            logicNBT.func_74782_a("fluidOutputs", (NBTBase)fluidOutputsNBT);
        }
        if (this.itemOutputID != null) {
            logicNBT.func_74778_a("itemOutputID", this.itemOutputID.toString());
        }
        if (this.fluidOutputID != null) {
            logicNBT.func_74778_a("fluidOutputID", this.fluidOutputID.toString());
        }
        return logicNBT;
    }

    public void loadFromNBT(@Nonnull NBTTagCompound logicNBT) {
        int i;
        this.calculatedEut = logicNBT.func_74763_f("eutConsumption");
        this.duration = logicNBT.func_74762_e("duration");
        this.progress = logicNBT.func_74762_e("progress");
        this.hasWork = logicNBT.func_74767_n("hasWork");
        if (logicNBT.func_74764_b("itemOutputs")) {
            NBTTagList itemOutputsNBT = logicNBT.func_150295_c("itemOutputs", 10);
            this.outputItems = new ItemStack[itemOutputsNBT.func_74745_c()];
            for (i = 0; i < itemOutputsNBT.func_74745_c(); ++i) {
                this.outputItems[i] = GT_Utility.loadItem(itemOutputsNBT.func_150305_b(i));
            }
        }
        if (logicNBT.func_74764_b("fluidOutputs")) {
            NBTTagList fluidOutputsNBT = logicNBT.func_150295_c("fluidOutputs", 10);
            this.outputFluids = new FluidStack[fluidOutputsNBT.func_74745_c()];
            for (i = 0; i < fluidOutputsNBT.func_74745_c(); ++i) {
                this.outputFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidOutputsNBT.func_150305_b(i));
            }
        }
        if (logicNBT.func_74764_b("itemOutputID")) {
            this.itemOutputID = UUID.fromString(logicNBT.func_74779_i("itemOutputID"));
        }
        if (logicNBT.func_74764_b("fluidOutputID")) {
            this.fluidOutputID = UUID.fromString(logicNBT.func_74779_i("fluidOutputID"));
        }
    }

    @Nonnull
    public Widget getGUIPart(ModularWindow.Builder builder) {
        return new Scrollable();
    }
}

