/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.URLClassLoaderWithUtilities;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.FastClassAccessor;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.asm.SafeAsmClassWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LogWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchClassLoader
extends URLClassLoaderWithUtilities
implements ExtensibleClassLoader {
    public static final int BUFFER_SIZE = 4096;
    private List<URL> sources;
    private ClassLoader parent = this.getClass().getClassLoader();
    private final RfbSystemClassLoader rfb$parent = this.parent instanceof RfbSystemClassLoader ? (RfbSystemClassLoader)this.parent : null;
    private static final ClassLoader rfb$platformLoader = LaunchClassLoader.getPlatformClassLoader();
    private List<IClassTransformer> transformers = new ArrayList<IClassTransformer>(2);
    private Map<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private Set<String> invalidClasses = Collections.newSetFromMap(new ConcurrentHashMap(1000));
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();
    private Map<Package, Manifest> packageManifests = new ConcurrentHashMap<Package, Manifest>();
    private Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>(1000);
    private Set<String> negativeResourceCache = Collections.newSetFromMap(new ConcurrentHashMap());
    private IClassNameTransformer renameTransformer;
    private static final Manifest EMPTY = new Manifest();
    private final ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    private static final String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false"));
    private static final boolean DEBUG_FINER = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingFiner", "false"));
    private static final boolean DEBUG_SAVE = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "false"));
    private static File tempFolder = null;

    public LaunchClassLoader(URL[] sources) {
        super("RFB-Launch", sources, LaunchClassLoader.getPlatformClassLoader());
        LogWrapper.configureLogging();
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.classLoaderExceptions.addAll(Arrays.asList("java.", "sun.", "org.lwjgl.", "org.apache.logging.", "org.objectweb.asm.", "net.minecraft.launchwrapper.", "com.gtnewhorizons.retrofuturabootstrap."));
        this.transformerExceptions.addAll(Arrays.asList("javax.", "argo.", "com.google.common.", "org.bouncycastle.", "net.minecraft.launchwrapper.injector.", "com.gtnewhorizons.retrofuturabootstrap."));
    }

    public void registerTransformer(String transformerClassName) {
        try {
            Class<?> xformerClass = Class.forName(transformerClassName, true, this);
            if (!IClassTransformer.class.isAssignableFrom(xformerClass)) {
                LogWrapper.severe("Tried to register a transformer {} which does not implement IClassTransformer", transformerClassName);
                return;
            }
            IClassTransformer xformer = (IClassTransformer)xformerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.renameTransformer == null && xformer instanceof IClassNameTransformer) {
                this.renameTransformer = (IClassNameTransformer)((Object)xformer);
            }
            this.transformers.add(xformer);
            LogWrapper.rfb$logger.debug("Registered class transformer {}", new Object[]{transformerClassName});
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            LogWrapper.rfb$logger.warn("Could not register a transformer {}", new Object[]{transformerClassName, cause});
        }
    }

    @Override
    public Class<?> findCachedClass(String name) {
        return this.cachedClasses.get(name);
    }

    @Override
    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        CodeSource codeSource;
        Package pkg;
        String string;
        Class<?> transformedClass;
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name + " in invalid class cache");
        }
        for (String string2 : this.classLoaderExceptions) {
            if (!name.startsWith(string2)) continue;
            return this.parent.loadClass(name);
        }
        Class<?> cached = this.cachedClasses.get(name);
        if (cached != null) {
            return cached;
        }
        boolean runTransformers = true;
        for (String exception : this.transformerExceptions) {
            if (!name.startsWith(exception)) continue;
            runTransformers = false;
            break;
        }
        if ((transformedClass = this.cachedClasses.get(string = runTransformers ? this.transformName(name) : name)) != null) {
            return transformedClass;
        }
        String untransformedName = runTransformers ? this.untransformName(name) : name;
        int lastDot = untransformedName.lastIndexOf(46);
        String packageName = lastDot == -1 ? "" : untransformedName.substring(0, lastDot);
        String classPath = untransformedName.replace('.', '/') + ".class";
        URLConnection connection = this.findCodeSourceConnectionFor(classPath);
        Manifest manifest = null;
        byte[] classBytes = null;
        if (!packageName.isEmpty()) {
            if (!untransformedName.startsWith("net.minecraft.") && connection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connection;
                URL packageSourceUrl = jarConnection.getJarFileURL();
                CodeSigner[] codeSigners = null;
                try {
                    manifest = jarConnection.getManifest();
                    pkg = this.getAndVerifyPackage(packageName, manifest, packageSourceUrl);
                    classBytes = runTransformers ? this.getClassBytes(untransformedName) : this.rfb$getUncachedClassBytes(untransformedName);
                    codeSigners = jarConnection.getJarEntry().getCodeSigners();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                URL classSourceUrl = runTransformers ? jarConnection.getURL() : jarConnection.getJarFileURL();
                codeSource = new CodeSource(classSourceUrl, codeSigners);
            } else {
                pkg = this.getAndVerifyPackage(packageName, null, null);
                codeSource = connection == null ? null : new CodeSource(connection.getURL(), (CodeSigner[])null);
            }
        } else {
            pkg = null;
            URL url = connection == null ? null : connection.getURL();
            CodeSource codeSource2 = codeSource = url == null ? null : new CodeSource(url, (CodeSigner[])null);
        }
        if (classBytes == null) {
            try {
                classBytes = runTransformers ? this.getClassBytes(untransformedName) : this.rfb$getUncachedClassBytes(untransformedName);
            }
            catch (IOException url) {
                // empty catch block
            }
        }
        if (Main.cfgDumpLoadedClassesPerTransformer && classBytes != null) {
            Main.dumpClass(this.getClassLoaderName(), string + "__000_pretransform", classBytes);
        }
        if (runTransformers) {
            try {
                classBytes = this.runTransformers(untransformedName, string, classBytes);
            }
            catch (Throwable t) {
                ClassNotFoundException err = new ClassNotFoundException("Exception caught while transforming class " + name, t);
                LogWrapper.rfb$logger.debug("Transformer error", (Throwable)err);
                throw err;
            }
        }
        if (this.rfb$parent != null) {
            boolean doCompatTransforms = true;
            for (String exclusion : this.rfb$parent.childDelegations) {
                if (!string.startsWith(exclusion)) continue;
                doCompatTransforms = false;
                break;
            }
            if (doCompatTransforms) {
                try {
                    RfbClassTransformer.Context context = runTransformers ? RfbClassTransformer.Context.LCL_WITH_TRANSFORMS : RfbClassTransformer.Context.LCL_NO_TRANSFORMS;
                    classBytes = this.runRfbTransformers(Main.getRfbTransformers(), context, manifest, string, classBytes);
                }
                catch (Throwable t) {
                    ClassNotFoundException err = new ClassNotFoundException("Exception caught while transforming class " + name, t);
                    LogWrapper.rfb$logger.debug("Transformer error", (Throwable)err);
                    throw err;
                }
            }
        }
        if (classBytes == null) {
            this.invalidClasses.add(name);
            throw new ClassNotFoundException(String.format("Class bytes are null for %s (%s, %s)", name, name, name));
        }
        if (Main.cfgDumpLoadedClasses) {
            Main.dumpClass(this.getClassLoaderName(), string, classBytes);
        }
        Class<?> result = this.defineClass(string, classBytes, 0, classBytes.length, codeSource);
        this.cachedClasses.put(string, result);
        return result;
    }

    @Override
    public Package getAndVerifyPackage(String packageName, Manifest manifest, URL codeSourceURL) {
        return super.getAndVerifyPackage(packageName, manifest, codeSourceURL);
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        Main.dumpClass(this.getClassLoaderName(), transformedName, data);
    }

    private String untransformName(String name) {
        if (this.renameTransformer == null || name == null) {
            return name;
        }
        String newName = this.renameTransformer.unmapClassName(name);
        return newName == null ? name : newName;
    }

    private String transformName(String name) {
        if (this.renameTransformer == null || name == null) {
            return name;
        }
        String newName = this.renameTransformer.remapClassName(name);
        return newName == null ? name : newName;
    }

    @Override
    public boolean isSealed(String packageName, Manifest manifest) {
        return super.isSealed(packageName, manifest);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        try {
            URL url = this.findResource(name);
            if (url == null) {
                return null;
            }
            return url.openConnection();
        }
        catch (Exception e) {
            LogWrapper.rfb$logger.debug("Couldn't findCodeSourceConnectionFor {}: {}", new Object[]{name, e.getMessage()});
            return null;
        }
    }

    private byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        int xformerIndex = 1;
        for (IClassTransformer xformer : this.transformers) {
            try {
                byte[] newKlass;
                try {
                    newKlass = xformer.transform(name, transformedName, basicClass);
                }
                catch (Exception e) {
                    if (e.getStackTrace() != null && e.getStackTrace().length > 2 && e.getStackTrace()[0].getClassName().contains("asm.MethodWriter")) {
                        SafeAsmClassWriter.forcedFlags.set(3);
                        SafeAsmClassWriter.forcedOriginalClass.set(basicClass);
                        newKlass = xformer.transform(name, transformedName, basicClass);
                        SafeAsmClassWriter.forcedOriginalClass.set(null);
                        SafeAsmClassWriter.forcedFlags.set(0);
                        LogWrapper.rfb$logger.warn("Transformer {} did not generate correct frames for {}, had to re-compute using asm.", new Object[]{xformer.getClass().getName(), transformedName});
                    }
                    throw e;
                }
                if (Main.cfgDumpLoadedClassesPerTransformer && newKlass != null && !Arrays.equals(basicClass, newKlass)) {
                    Main.dumpClass(this.getClassLoaderName(), String.format("%s__%03d_%s", transformedName, xformerIndex, xformer.getClass().getName().replace('/', '_').replace('.', '_')), newKlass);
                }
                basicClass = newKlass;
            }
            catch (UnsupportedOperationException e) {
                if (e.getMessage().contains("requires ASM")) {
                    LogWrapper.rfb$logger.warn("ASM transformer {} encountered a newer classfile ({} -> {}) than supported: {}", new Object[]{xformer.getClass().getName(), name, transformedName, e.getMessage()});
                    continue;
                }
                throw e;
            }
            ++xformerIndex;
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    @Override
    public void addSilentURL(@Nullable URL url) {
        super.addURL(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            return LaunchClassLoader.readAllBytes(stream, this.getOrCreateBuffer());
        }
        catch (Exception e) {
            LogWrapper.rfb$logger.warn("Could not read InputStream {}", new Object[]{stream.toString(), e});
            return new byte[0];
        }
    }

    private byte[] getOrCreateBuffer() {
        byte[] buf = this.loadBuffer.get();
        if (buf == null) {
            buf = new byte[4096];
            this.loadBuffer.set(buf);
        }
        return buf;
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public List<IClassTransformer> rfb$getMutableTransformers() {
        return this.transformers;
    }

    public void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    public void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    @Override
    @Nullable
    public FastClassAccessor findClassMetadata(@NotNull String name) {
        FastClassAccessor acc = this.findClassMetadataImpl(name);
        if (acc == null && this.renameTransformer != null) {
            name = this.untransformName(name);
            acc = this.findClassMetadataImpl(name);
        }
        return acc;
    }

    @Nullable
    public FastClassAccessor findClassMetadataImpl(@NotNull String name) {
        for (String exception : this.classLoaderExceptions) {
            if (!name.startsWith(exception)) continue;
            try {
                Class<?> loaded = this.parent.loadClass(name);
                return FastClassAccessor.ofLoaded(loaded);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        Class<?> cachedClass = this.findCachedClass(name);
        if (cachedClass != null) {
            return FastClassAccessor.ofLoaded(cachedClass);
        }
        try {
            byte[] classBytes = this.getClassBytes(name);
            if (classBytes != null) {
                return new ClassHeaderMetadata(classBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public byte[] getClassBytes(String name) throws IOException {
        byte[] data;
        if (this.negativeResourceCache.contains(name)) {
            return null;
        }
        byte[] cached = this.resourceCache.get(name);
        if (cached != null) {
            return (byte[])cached.clone();
        }
        if (!name.contains(".") && name.length() >= 3 && name.length() <= 4) {
            for (String reserved : RESERVED_NAMES) {
                if (!reserved.equalsIgnoreCase(name)) continue;
                byte[] underscored = this.getClassBytes("_" + name);
                if (underscored != null) {
                    this.resourceCache.put(name, underscored);
                } else {
                    this.negativeResourceCache.add(name);
                }
                return underscored;
            }
        }
        if ((data = this.rfb$getUncachedClassBytes(name)) == null) {
            this.negativeResourceCache.add(name);
            return null;
        }
        this.resourceCache.put(name, data);
        return (byte[])data.clone();
    }

    private byte[] rfb$getUncachedClassBytes(String name) throws IOException {
        URLConnection conn;
        String classPath = name.replace('.', '/') + ".class";
        URL resourceUrl = this.findResource(classPath);
        URLConnection uRLConnection = conn = resourceUrl == null ? null : resourceUrl.openConnection();
        if (conn == null) {
            if (rfb$platformLoader != null) {
                URL platformUrl = rfb$platformLoader.getResource(classPath);
                if (platformUrl != null) {
                    conn = platformUrl.openConnection();
                }
            } else {
                URL parentUrl = this.getResource(classPath);
                if (parentUrl != null) {
                    conn = parentUrl.openConnection();
                }
            }
        }
        if (conn == null) {
            return null;
        }
        InputStream is = conn.getInputStream();
        byte[] contents = this.readFully(is);
        LaunchClassLoader.closeSilently(is);
        return contents;
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearNegativeEntries(Set<String> entriesToClear) {
        this.negativeResourceCache.removeAll(entriesToClear);
    }

    @Override
    @NotNull
    public URLClassLoader asURLClassLoader() {
        return this;
    }
}

