/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleTileSize {
    public byte sizeX;
    public byte sizeY;
    public byte sizeZ;

    public LittleTileSize(String name, NBTTagCompound nbt) {
        this(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
    }

    public LittleTileSize(byte sizeX, byte sizeY, byte sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public LittleTileSize(int sizeX, int sizeY, int sizeZ) {
        this((byte)sizeX, (byte)sizeY, (byte)sizeZ);
    }

    public void set(byte sizeX, byte sizeY, byte sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileSize) {
            return this.sizeX == ((LittleTileSize)object).sizeX && this.sizeY == ((LittleTileSize)object).sizeY && this.sizeZ == ((LittleTileSize)object).sizeZ;
        }
        return super.equals(object);
    }

    public float getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public float getPercentVolume() {
        return this.getVolume() / 4096.0f;
    }

    public LittleTileVec calculateInvertedCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((byte)Math.ceil(x), (byte)Math.ceil(y), (byte)Math.ceil(z));
    }

    public LittleTileVec calculateCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((byte)Math.floor(x), (byte)Math.floor(y), (byte)Math.floor(z));
    }

    public double getPosX() {
        return (double)this.sizeX / 16.0;
    }

    public double getPosY() {
        return (double)this.sizeY / 16.0;
    }

    public double getPosZ() {
        return (double)this.sizeZ / 16.0;
    }

    public LittleTileSize copy() {
        return new LittleTileSize(this.sizeX, this.sizeY, this.sizeZ);
    }

    public void rotateSize(ForgeDirection direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                byte tempY = this.sizeY;
                this.sizeY = this.sizeX;
                this.sizeX = tempY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                byte tempZ = this.sizeZ;
                this.sizeZ = this.sizeX;
                this.sizeX = tempZ;
                break;
            }
        }
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74774_a(name + "x", this.sizeX);
        nbt.func_74774_a(name + "y", this.sizeY);
        nbt.func_74774_a(name + "z", this.sizeZ);
    }

    public String toString() {
        return "[" + this.sizeX + "," + this.sizeY + "," + this.sizeZ + "]";
    }

    public LittleTileSize max(LittleTileSize size) {
        this.sizeX = (byte)Math.max(this.sizeX, size.sizeX);
        this.sizeY = (byte)Math.max(this.sizeY, size.sizeY);
        this.sizeZ = (byte)Math.max(this.sizeZ, size.sizeZ);
        return this;
    }
}

