/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import me.eigenraven.lwjgl3ify.WasFinalObjectHolder;
import me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class UnfinalizeObjectHoldersTransformer
implements RfbClassTransformer {
    final byte[] QUICKSCAN_BYTES = "cpw/mods/fml/common/registry/GameRegistry".getBytes(StandardCharsets.UTF_8);

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "unfinalize-object-holders";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (className.equals("net.minecraft.init.Blocks") || className.equals("net.minecraft.init.Items")) {
            return true;
        }
        if (classNode.isOriginal()) {
            return ClassHeaderMetadata.hasSubstring((byte[])classNode.getOriginalBytes(), (byte[])this.QUICKSCAN_BYTES);
        }
        return true;
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String name, @NotNull ClassNodeHandle classNodeHandle) {
        ClassNode node = classNodeHandle.getNode();
        if (node == null) {
            return;
        }
        boolean transformClass = false;
        boolean workDone = false;
        if (name.equals("net.minecraft.init.Blocks") || name.equals("net.minecraft.init.Items")) {
            transformClass = true;
        }
        transformClass |= UnfinalizeObjectHoldersTransformer.isHolder(node.visibleAnnotations);
        int fieldsModified = 0;
        for (FieldNode field : node.fields) {
            boolean transform = transformClass;
            if (!transform) {
                transform = UnfinalizeObjectHoldersTransformer.isHolder(field.visibleAnnotations);
            }
            if (!transform) continue;
            workDone = true;
            if ((field.access & 0x10) != 0) {
                if (field.visibleAnnotations == null) {
                    field.visibleAnnotations = new ArrayList<AnnotationNode>(1);
                    field.visibleAnnotations.add(new AnnotationNode(Type.getDescriptor(WasFinalObjectHolder.class)));
                }
                field.access &= 0xFFFFFFEF;
            }
            ++fieldsModified;
        }
        if (workDone) {
            Lwjgl3ifyCoremod.LOGGER.debug("Unfinalized {} Holder fields in {}", new Object[]{fieldsModified, name});
        }
    }

    private static boolean isHolder(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return false;
        }
        for (AnnotationNode annotationNode : annotations) {
            if (annotationNode.desc.contains("cpw/mods/fml/common/registry/GameRegistry$ObjectHolder")) {
                return true;
            }
            if (annotationNode.desc.contains("cpw/mods/fml/common/registry/GameRegistry$ItemStackHolder")) {
                return true;
            }
            if (annotationNode.desc.contains("cpw/mods/fml/common/registry/GameRegistry/ObjectHolder")) {
                return true;
            }
            if (!annotationNode.desc.contains("cpw/mods/fml/common/registry/GameRegistry/ItemStackHolder")) continue;
            return true;
        }
        return false;
    }
}

