/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import me.eigenraven.lwjgl3ify.api.Lwjgl3Aware;
import me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;

public class LwjglRedirectTransformer
extends Remapper
implements RfbClassTransformer {
    public static final Attributes.Name MANIFEST_SAFE_ATTRIBUTE = new Attributes.Name("Lwjgl3ify-Aware");
    int remaps = 0;
    int calls = 0;
    final String[] fromPrefixes = new String[]{"org/lwjgl/", "javax/xml/bind/", "java/util/jar/Pack200", "jdk/nashorn/", "com/mumfrey/liteloader/launch/ClassPathUtilities", "javax/activity/InvalidActivityException"};
    final String[] toPrefixes = new String[]{"org/lwjglx/", "jakarta/xml/bind/", "me/eigenraven/lwjgl3ify/redirects/Pack200", "org/openjdk/nashorn/", "me/eigenraven/lwjgl3ify/redirects/LiteLoaderClassPathUtilities", "me/eigenraven/lwjgl3ify/redirects/InvalidActivityException"};
    final byte[][] quickScans;
    final String[] excludedPackages = (String[])Stream.concat(Arrays.stream(this.fromPrefixes), Arrays.stream(this.toPrefixes)).map((? super T s) -> s.replace('/', '.')).toArray(String[]::new);

    public LwjglRedirectTransformer() {
        this.quickScans = (byte[][])Arrays.stream(this.fromPrefixes).map((? super T s) -> s.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
    }

    public @NotNull String @Nullable [] sortAfter() {
        return new String[]{"*", "mixin:mixin"};
    }

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "redirect";
    }

    public @NotNull String @Nullable [] additionalExclusions() {
        return this.excludedPackages;
    }

    public void onRegistration(@NotNull ExtensibleClassLoader classLoader) {
        if (classLoader instanceof LaunchClassLoader) {
            LaunchClassLoader lcl = (LaunchClassLoader)classLoader;
            lcl.addClassLoaderExclusion("me.eigenraven.lwjgl3ify.pack200.");
        }
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle nodeHandle) {
        if (!nodeHandle.isPresent()) {
            return false;
        }
        if (manifest != null && "true".equals(manifest.getMainAttributes().getValue(MANIFEST_SAFE_ATTRIBUTE))) {
            return false;
        }
        if (!nodeHandle.isOriginal()) {
            return true;
        }
        byte[] original = nodeHandle.getOriginalBytes();
        if (original == null) {
            return false;
        }
        for (byte[] pattern : this.quickScans) {
            if (!ClassHeaderMetadata.hasSubstring((byte[])original, (byte[])pattern)) continue;
            return true;
        }
        return false;
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle nodeHandle) {
        ClassNode inputNode = nodeHandle.getNode();
        if (inputNode == null) {
            return;
        }
        ClassNode outputNode = new ClassNode();
        EscapingClassRemapper visitor = new EscapingClassRemapper((ClassVisitor)outputNode);
        try {
            inputNode.accept(visitor);
        }
        catch (Lwjgl3AwareException e) {
            return;
        }
        catch (Exception e) {
            Lwjgl3ifyCoremod.LOGGER.warn("Couldn't remap class {}", new Object[]{className, e});
            return;
        }
        nodeHandle.setNode(outputNode);
    }

    @Override
    public String map(String typeName) {
        if (typeName == null) {
            return null;
        }
        ++this.calls;
        for (int pfx = 0; pfx < this.fromPrefixes.length; ++pfx) {
            if (!typeName.startsWith(this.fromPrefixes[pfx])) continue;
            ++this.remaps;
            return this.toPrefixes[pfx] + typeName.substring(this.fromPrefixes[pfx].length());
        }
        return typeName;
    }

    public class EscapingClassRemapper
    extends ClassRemapper {
        public EscapingClassRemapper(ClassVisitor visitor) {
            super(visitor, LwjglRedirectTransformer.this);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(Type.getDescriptor(Lwjgl3Aware.class))) {
                throw new Lwjgl3AwareException();
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    public static class Lwjgl3AwareException
    extends RuntimeException {
    }
}

