/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import me.eigenraven.lwjgl3ify.IExtensibleEnum;
import me.eigenraven.lwjgl3ify.api.MakeEnumExtensible;
import me.eigenraven.lwjgl3ify.rfb.EarlyConfig;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ExtensibleEnumTransformer
implements RfbClassTransformer {
    private final Logger LOGGER = LogManager.getLogger((String)"lwjgl3ify");
    private final Type STRING = Type.getType(String.class);
    private final Type ENUM = Type.getType(Enum.class);
    public final Type MARKER_IFACE = Type.getType(IExtensibleEnum.class);
    public final Type MARKER_ANNOTATION = Type.getType(MakeEnumExtensible.class);
    private final Type ARRAY_UTILS = Type.getType("Lorg/apache/commons/lang3/ArrayUtils;");
    private final String ADD_DESC = Type.getMethodDescriptor(Type.getType(Object[].class), Type.getType(Object[].class), Type.getType(Object.class));
    private final Type UNSAFE_HACKS = Type.getType("Lme/eigenraven/lwjgl3ify/UnsafeHacks;");
    private final String CLEAN_DESC = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Class.class));
    private final String NAME_DESC = Type.getMethodDescriptor(this.STRING, new Type[0]);
    private final String EQUALS_DESC = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, this.STRING);
    public static final String CREATE_METHOD_NAME = "dynamicCreate";

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "extensible-enum";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader extensibleClassLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNodeHandle) {
        return classNodeHandle.getFastAccessor() != null && classNodeHandle.getFastAccessor().isEnum();
    }

    public void transformClass(@NotNull ExtensibleClassLoader extensibleClassLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNodeHandle) {
        Type classType = Type.getObjectType(className.replace('.', '/'));
        ClassNode classNode = classNodeHandle.getNode();
        if (classNode == null) {
            return;
        }
        if (EarlyConfig.EXTENSIBLE_ENUMS.contains(className)) {
            if (classNode.interfaces == null) {
                classNode.interfaces = new ArrayList<String>(1);
            }
            classNode.interfaces.add(this.MARKER_IFACE.getInternalName());
        }
        Type array = Type.getType("[" + classType.getDescriptor());
        int flags = 4122;
        FieldNode values = classNode.fields.stream().filter(f -> f.desc.contentEquals(array.getDescriptor()) && (f.access & 0x101A) == 4122).findFirst().orElse(classNode.fields.stream().filter(f -> f.desc.contentEquals(array.getDescriptor()) && f.name.equals("$VALUES")).findFirst().orElse(null));
        boolean process = false;
        if (classNode.interfaces.contains(this.MARKER_IFACE.getInternalName())) {
            process = true;
        } else if (classNode.visibleAnnotations != null && !classNode.visibleAnnotations.isEmpty()) {
            for (AnnotationNode annotation : classNode.visibleAnnotations) {
                if (!annotation.desc.equals(this.MARKER_ANNOTATION.getDescriptor())) continue;
                process = true;
            }
        }
        if (!process) {
            return;
        }
        classNodeHandle.computeMaxs();
        classNodeHandle.computeFrames();
        List constructors = classNode.methods.stream().filter(m -> m.name.equals("<init>")).collect(Collectors.toList());
        List<MethodNode> candidates = constructors.stream().map(ctor -> {
            String[] exceptions = ctor.exceptions == null ? null : ctor.exceptions.toArray(new String[0]);
            Type ctorDesc = Type.getMethodType(ctor.desc);
            Type creatorDesc = Type.getMethodType(classType, (Type[])ArrayUtils.remove((Object[])ctorDesc.getArgumentTypes(), (int)1));
            MethodNode creator = new MethodNode(ctor.access, CREATE_METHOD_NAME, creatorDesc.getDescriptor(), null, exceptions);
            creator.access = 9;
            return creator;
        }).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            throw new IllegalStateException("IExtensibleEnum has no candidate factory methods: " + classType.getClassName());
        }
        classNode.methods.addAll(candidates);
        candidates.forEach(mtd -> {
            Type[] args = Type.getArgumentTypes(mtd.desc);
            if (args.length == 0 || !args[0].equals(this.STRING)) {
                if (this.LOGGER.isErrorEnabled()) {
                    String sb = "Enum has create method without String as first parameter:\n  Enum: " + classType.getDescriptor() + "\n  Target: " + mtd.name + mtd.desc + "\n";
                    this.LOGGER.error(sb);
                }
                throw new IllegalStateException("Enum has create method without String as first parameter: " + mtd.name + mtd.desc);
            }
            Type ret = Type.getReturnType(mtd.desc);
            if (!ret.equals(classType)) {
                if (this.LOGGER.isErrorEnabled()) {
                    String sb = "Enum has create method with incorrect return type:\n  Enum: " + classType.getDescriptor() + "\n  Target: " + mtd.name + mtd.desc + "\n  Found: " + ret.getClassName() + ", Expected: " + classType.getClassName();
                    this.LOGGER.error(sb);
                }
                throw new IllegalStateException("Enum has create method with incorrect return type: " + mtd.name + mtd.desc);
            }
            Type[] ctrArgs = new Type[args.length + 1];
            ctrArgs[0] = this.STRING;
            ctrArgs[1] = Type.INT_TYPE;
            for (int x = 1; x < args.length; ++x) {
                ctrArgs[1 + x] = args[x];
            }
            String desc = Type.getMethodDescriptor(Type.VOID_TYPE, ctrArgs);
            MethodNode ctr = classNode.methods.stream().filter(m -> m.name.equals("<init>") && m.desc.equals(desc)).findFirst().orElse(null);
            if (ctr == null) {
                if (this.LOGGER.isErrorEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Enum has create method with no matching constructor:\n");
                    sb.append("  Enum: ").append(classType.getDescriptor()).append("\n");
                    sb.append("  Candidate: ").append(mtd.desc).append("\n");
                    sb.append("  Target: ").append(desc).append("\n");
                    classNode.methods.stream().filter(m -> m.name.equals("<init>")).forEach(m -> sb.append("        : ").append(m.desc).append("\n"));
                    this.LOGGER.error(sb.toString());
                }
                throw new IllegalStateException("Enum has create method with no matching constructor: " + desc);
            }
            if (values == null) {
                if (this.LOGGER.isErrorEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Enum has create method but we could not find $VALUES. Found:\n");
                    classNode.fields.stream().filter(f -> (f.access & 8) != 0).forEach(m -> sb.append("  ").append(m.name).append(" ").append(m.desc).append("\n"));
                    this.LOGGER.error(sb.toString());
                }
                throw new IllegalStateException("Enum has create method but we could not find $VALUES");
            }
            values.access &= values.access & 0xFFFFFFEF;
            mtd.access |= 0x20;
            mtd.instructions.clear();
            mtd.localVariables.clear();
            if (mtd.tryCatchBlocks != null) {
                mtd.tryCatchBlocks.clear();
            }
            if (mtd.visibleLocalVariableAnnotations != null) {
                mtd.visibleLocalVariableAnnotations.clear();
            }
            if (mtd.invisibleLocalVariableAnnotations != null) {
                mtd.invisibleLocalVariableAnnotations.clear();
            }
            InstructionAdapter ins = new InstructionAdapter((MethodVisitor)mtd);
            int vars = 0;
            for (Type arg : args) {
                vars += arg.getSize();
            }
            Label for_start = new Label();
            Label for_condition = new Label();
            Label for_inc = new Label();
            ins.iconst(0);
            ins.store(++vars, Type.INT_TYPE);
            ins.goTo(for_condition);
            ins.mark(for_start);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, Type.INT_TYPE);
            ins.aload(array);
            ins.invokevirtual(this.ENUM.getInternalName(), "name", this.NAME_DESC, false);
            ins.load(0, this.STRING);
            ins.invokevirtual(this.STRING.getInternalName(), "equalsIgnoreCase", this.EQUALS_DESC, false);
            ins.ifeq(for_inc);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, Type.INT_TYPE);
            ins.aload(array);
            ins.areturn(classType);
            ins.mark(for_inc);
            ins.iinc(vars, 1);
            ins.mark(for_condition);
            ins.load(vars, Type.INT_TYPE);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.arraylength();
            ins.ificmplt(for_start);
            ++vars;
            ins.anew(classType);
            ins.dup();
            ins.load(0, this.STRING);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.arraylength();
            int idx = 1;
            for (int x = 1; x < args.length; ++x) {
                ins.load(idx, args[x]);
                idx += args[x].getSize();
            }
            ins.invokespecial(classType.getInternalName(), "<init>", desc, false);
            ins.store(vars, classType);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, classType);
            ins.invokestatic(this.ARRAY_UTILS.getInternalName(), "add", this.ADD_DESC, false);
            ins.checkcast(array);
            ins.putstatic(classType.getInternalName(), values.name, values.desc);
            ins.visitLdcInsn(classType);
            ins.invokestatic(this.UNSAFE_HACKS.getInternalName(), "cleanEnumCache", this.CLEAN_DESC, false);
            ins.load(vars, classType);
            ins.invokeinterface(this.MARKER_IFACE.getInternalName(), "init", "()V");
            ins.load(vars, classType);
            ins.areturn(classType);
        });
    }
}

