/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.components.border.MarginBorderWrapper;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.graphics.StringPainter;
import com.github.weisj.darklaf.swingdsl.VisualPaddingListener;
import com.github.weisj.darklaf.ui.OpacityBufferedUI;
import com.github.weisj.darklaf.ui.cell.DarkCellBorder;
import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.DarkHighlighter;
import com.github.weisj.darklaf.ui.text.DarkTextBorder;
import com.github.weisj.darklaf.ui.text.DarkTextListener;
import com.github.weisj.darklaf.ui.text.DefaultTextRenderer;
import com.github.weisj.darklaf.ui.text.LabelDefaultTextRenderer;
import com.github.weisj.darklaf.ui.text.action.DarkKeyTypedAction;
import com.github.weisj.darklaf.ui.text.action.ToggleInsertAction;
import com.github.weisj.darklaf.ui.text.popup.DarkTextPopupMenu;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public abstract class DarkTextUI
extends BasicTextUI
implements OpacityBufferedUI {
    protected static final String KEY_PREFIX = "JTextComponent.";
    public static final String KEY_ROUNDED_SELECTION = "JTextComponent.roundedSelection";
    public static final String KEY_EXTEND_LINE_SELECTION = "JTextComponent.extendSelection";
    public static final String KEY_HAS_ERROR = "JTextComponent.hasError";
    public static final String KEY_HAS_WARNING = "JTextComponent.hasWarning";
    public static final String KEY_IS_TREE_EDITOR = "JComponent.isTreeEditor";
    public static final String KEY_IS_TABLE_EDITOR = "JComponent.isTableEditor";
    public static final String KEY_IS_LIST_EDITOR = "JComponent.listCellEditor";
    public static final String KEY_DEFAULT_TEXT = "JTextComponent.defaultText";
    protected static final String TOGGLE_INSERT = "toggle_insert";
    protected DarkTextListener textListener;
    protected VisualPaddingListener visualPaddingListener;
    protected JTextComponent editor;
    protected DefaultTextRenderer defaultTextRenderer;
    protected DarkCaret darkCaret;
    protected Insets margins;
    protected Color disabledColor;
    protected Color inactiveColor;
    protected boolean uninstalling;

    @Override
    protected Caret createCaret() {
        return this.getDarkCaret();
    }

    protected DarkCaret getDarkCaret() {
        if (this.darkCaret == null) {
            this.darkCaret = this.createDarkCaret();
        }
        return this.darkCaret;
    }

    protected DarkCaret createDarkCaret() {
        DarkCaret c = new DarkCaret(this.getDefaultCaretStyle(), this.getDefaultInsertCaretStyle());
        c.setLineExtendingEnabled(PropertyUtil.getBooleanProperty(this.editor, KEY_EXTEND_LINE_SELECTION));
        c.setRoundedSelectionEdges(PropertyUtil.getBooleanProperty(this.editor, KEY_ROUNDED_SELECTION));
        return c;
    }

    protected abstract DarkCaret.CaretStyle getDefaultCaretStyle();

    protected DarkCaret.CaretStyle getDefaultInsertCaretStyle() {
        return DarkCaret.CaretStyle.BLOCK_STYLE;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.editor != null) {
            PropertyUtil.installProperty(this.editor, "JToolTip.style", ToolTipStyle.PLAIN);
            PropertyUtil.installBooleanProperty(this.editor, KEY_ROUNDED_SELECTION, "TextComponent.roundedSelection");
            PropertyUtil.installBooleanProperty(this.editor, KEY_EXTEND_LINE_SELECTION, this.getPropertyPrefix() + ".extendSelection");
        }
        this.disabledColor = UIManager.getColor(this.getPropertyPrefix() + ".disabledBackground");
        this.inactiveColor = UIManager.getColor(this.getPropertyPrefix() + ".inactiveBackground");
        this.margins = UIManager.getInsets(this.getPropertyPrefix() + ".margins");
        this.updateMargins();
        this.installBorder();
        this.installPopupMenu();
        this.updateBackground(this.editor);
    }

    protected void updateMargins() {
        Insets margin = this.editor.getMargin();
        if (margin == null || margin instanceof UIResource) {
            this.editor.setMargin(this.isInCell(this.editor) ? new InsetsUIResource(0, 0, 0, 0) : this.margins);
        }
    }

    public static boolean isBorderlessTextField(JTextComponent textComponent) {
        if (textComponent == null) {
            return false;
        }
        String className = textComponent.getClass().getName();
        return "javax.swing.plaf.basic.BasicComboBoxEditor$BorderlessTextField".equals(className);
    }

    public static boolean isSpinnerEditor(JTextComponent textComponent) {
        if (textComponent == null) {
            return false;
        }
        return DarkUIUtil.getParentOfType(JSpinner.class, textComponent, 2) != null;
    }

    protected void installPopupMenu() {
        JPopupMenu popupMenu = this.editor.getComponentPopupMenu();
        if (popupMenu == null || popupMenu instanceof UIResource) {
            this.editor.setComponentPopupMenu(this.createPopupMenu(this.editor));
        }
    }

    protected JPopupMenu createPopupMenu(JTextComponent textComponent) {
        return new DarkTextPopupMenu(textComponent);
    }

    protected void uninstallPopupMenu() {
        JPopupMenu popupMenu = this.editor.getComponentPopupMenu();
        if (popupMenu instanceof UIResource) {
            this.editor.setComponentPopupMenu(null);
        }
    }

    protected void installBorder() {
        if (DarkTextUI.isBorderlessTextField(this.editor)) {
            if (this.editor.getBorder() != null) {
                this.editor.setBorder(null);
            }
            return;
        }
        if (DarkTextUI.isSpinnerEditor(this.editor) && !UIManager.getBoolean("Spinner.editorBorderPainted")) {
            return;
        }
        if (this.uninstalling) {
            return;
        }
        MarginBorderWrapper.installBorder(this.editor);
    }

    protected void uninstallBorder() {
        MarginBorderWrapper.uninstallBorder(this.editor);
    }

    protected DefaultTextRenderer createDefaultTextRenderer() {
        return new LabelDefaultTextRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        this.uninstalling = true;
        this.uninstallBorder();
        this.uninstallPopupMenu();
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.textListener = this.createTextListener();
        this.editor.addFocusListener(this.textListener);
        this.editor.addPropertyChangeListener(this.textListener);
        this.visualPaddingListener = new VisualPaddingListener();
        this.editor.addPropertyChangeListener(this.visualPaddingListener);
    }

    protected DarkTextListener createTextListener() {
        return new DarkTextListener(this.editor, this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.editor.removeFocusListener(this.textListener);
        this.editor.removePropertyChangeListener(this.textListener);
        this.textListener = null;
        this.editor.removePropertyChangeListener(this.visualPaddingListener);
        this.visualPaddingListener = null;
    }

    protected void updateBackground(JTextComponent c) {
        PropertyUtil.installBackground(c, this.getBackground(c));
    }

    protected Color getBackground(JTextComponent c) {
        if (!c.isEnabled()) {
            return this.disabledColor;
        }
        if (!c.isEditable()) {
            return this.inactiveColor;
        }
        return c.getBackground();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String defaultText;
        Dimension dim = super.getPreferredSize(c);
        if (this.isEmpty() && !(defaultText = this.getDefaultText()).isEmpty()) {
            Component renderer = this.getDefaultTextRenderer().getRendererComponent(this.editor, defaultText);
            renderer.setFont(this.editor.getFont());
            Dimension prefSize = renderer.getPreferredSize();
            Insets i = c.getInsets();
            prefSize.width += i.left + i.right;
            prefSize.height += i.top + i.bottom;
            dim.width = Math.max(dim.width, prefSize.width);
            dim.height = Math.max(dim.height, prefSize.height);
        }
        if (c.getSize().width < dim.width) {
            dim.width += DarkTextUI.getCaretWidth(this.editor);
        }
        return dim;
    }

    public static int getCaretWidth(JTextComponent textComponent) {
        Caret caret = textComponent.getCaret();
        if (caret instanceof DefaultCaret) {
            return (int)((DefaultCaret)caret).getWidth();
        }
        return 1;
    }

    @Override
    protected void paintBackground(Graphics g) {
        Container parent = this.getRelevantParent(this.editor);
        if (parent != null && !(parent instanceof Window)) {
            g.setColor(parent.getBackground());
            if (parent instanceof JTextComponent) {
                if (!parent.isEnabled()) {
                    g.setColor(this.disabledColor);
                } else if (!((JTextComponent)parent).isEditable()) {
                    g.setColor(this.inactiveColor);
                }
            }
            g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
        }
        if (!this.editor.isEnabled()) {
            return;
        }
        if (this.editor.isOpaque() && this.isInCell(this.editor)) {
            g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
        }
        Border border = this.getBorder(this.editor);
        g.setColor(this.editor.getBackground());
        if (border instanceof DarkTextBorder) {
            this.paintBorderBackground((Graphics2D)g, this.editor, (DarkTextBorder)border);
        } else {
            Insets ins = null;
            if (border instanceof DarkCellBorder) {
                ins = new Insets(0, 0, 0, 0);
            } else if (border != null) {
                ins = border.getBorderInsets(this.editor);
            }
            if (ins == null) {
                ins = new Insets(0, 0, 0, 0);
            }
            g.fillRect(ins.left, ins.top, this.editor.getWidth() - ins.left - ins.right, this.editor.getHeight() - ins.top - ins.bottom);
        }
    }

    protected boolean isInCell(JComponent c) {
        if (this.getBorder(c) instanceof DarkTextBorder) {
            return false;
        }
        return DarkUIUtil.getParentOfType(JSpinner.class, c, 2) != null || DarkUIUtil.isInCell(c) || PropertyUtil.getBooleanProperty(c, KEY_IS_TREE_EDITOR) || PropertyUtil.getBooleanProperty(c, KEY_IS_TABLE_EDITOR) || PropertyUtil.getBooleanProperty(c, KEY_IS_LIST_EDITOR);
    }

    protected Container getRelevantParent(Component comp) {
        Container parent = comp.getParent();
        if (parent instanceof JSpinner.DefaultEditor) {
            JSpinner spinner = DarkUIUtil.getParentOfType(JSpinner.class, comp, 2);
            if (spinner != null) {
                parent = spinner.getParent();
            }
        } else if (parent instanceof JComboBox) {
            parent = parent.getParent();
        }
        return DarkUIUtil.getParentMatching(parent, c -> c.isOpaque() || c instanceof JTextComponent);
    }

    @Override
    protected void paintSafely(Graphics g) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        super.paintSafely(g);
        config.restoreClip();
        this.paintDefaultText(g);
        config.restore();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        StringPainter.paintOpacityBufferedUI(g, c, this);
    }

    @Override
    public void updateUI(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void paintDefaultText(Graphics g) {
        String defaultText;
        if (this.isEmpty() && !(defaultText = this.getDefaultText()).isEmpty()) {
            Rectangle rect = this.getVisibleEditorRect();
            g.translate(rect.x, rect.y);
            Component renderer = this.getDefaultTextRenderer().getRendererComponent(this.editor, defaultText);
            renderer.setFont(this.editor.getFont());
            renderer.setBounds(rect);
            this.editor.add(renderer);
            renderer.paint(g);
            this.editor.remove(renderer);
        }
    }

    protected String getDefaultText() {
        return PropertyUtil.getString(this.editor, KEY_DEFAULT_TEXT, "");
    }

    protected boolean isEmpty() {
        Document doc = this.editor.getDocument();
        return doc == null || doc.getLength() == 0;
    }

    protected DefaultTextRenderer getDefaultTextRenderer() {
        if (this.defaultTextRenderer == null) {
            this.defaultTextRenderer = this.createDefaultTextRenderer();
        }
        return this.defaultTextRenderer;
    }

    protected void paintBorderBackground(Graphics2D g, JTextComponent c, DarkTextBorder border) {
        int arc = border.getArcSize(c);
        int bs = border.getBorderSize();
        PaintUtil.fillRoundRect(g, bs, bs, c.getWidth() - 2 * bs, c.getHeight() - 2 * bs, arc);
    }

    protected Border getBorder(JComponent c) {
        return MarginBorderWrapper.getBorder(c);
    }

    protected Insets getBorderInsets(JComponent c) {
        Border b = this.getBorder(c);
        if (b == null) {
            return new Insets(0, 0, 0, 0);
        }
        return b.getBorderInsets(c);
    }

    public Rectangle getDrawingRect(JTextComponent c) {
        return DarkUIUtil.applyInsets(new Rectangle(c.getWidth(), c.getHeight()), this.getBorderInsets(c));
    }

    protected void installDarkKeyBoardActions() {
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.getComponent());
        actionMap.put(TOGGLE_INSERT, new ToggleInsertAction());
        InputMap inputMap = SwingUtilities.getUIInputMap(this.getComponent(), 0);
        inputMap.put(KeyStroke.getKeyStroke(155, 0), TOGGLE_INSERT);
    }

    @Override
    public void installUI(JComponent c) {
        if (c instanceof JTextComponent) {
            this.editor = (JTextComponent)c;
        }
        super.installUI(c);
        this.installDarkKeyBoardActions();
    }

    @Override
    protected Highlighter createHighlighter() {
        return new DarkHighlighter();
    }

    @Override
    protected Keymap createKeymap() {
        Keymap km = super.createKeymap();
        km.setDefaultAction(new DarkKeyTypedAction());
        return km;
    }
}

