/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public final class EmptyIcon
implements Icon,
UIResource {
    private static final Map<Integer, Icon> cache = new HashMap<Integer, Icon>();
    private final int width;
    private final int height;

    private EmptyIcon(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static Icon create(Icon base) {
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    public static Icon create(int width, int height) {
        return width == height ? EmptyIcon.create(width) : new EmptyIcon(width, height);
    }

    public static Icon create(int size) {
        Icon icon = cache.get(size);
        if (icon == null && size < 129) {
            icon = new EmptyIcon(size, size);
            cache.put(size, icon);
        }
        return icon == null ? new EmptyIcon(size, size) : icon;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public int hashCode() {
        int sum = this.width + this.height;
        return sum * (sum + 1) / 2 + this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        return this.height == icon.height && this.width == icon.width;
    }
}

