/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.utils;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.RecursiveAction;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.functions.LongComparator;
import speiger.src.collections.longs.utils.LongCollections;
import speiger.src.collections.longs.utils.LongIterators;
import speiger.src.collections.utils.SanityChecks;

public class LongArrays {
    public static final int BASE_THRESHOLD = 16;
    public static final int PARALLEL_THRESHOLD = 8192;
    public static final long[] EMPTY_ARRAY = new long[0];

    public static Long[] wrap(long[] a) {
        return LongArrays.wrap(a, 0, a.length);
    }

    public static Long[] wrap(long[] a, int length) {
        return LongArrays.wrap(a, 0, length);
    }

    public static Long[] wrap(long[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        Long[] result = new Long[length];
        for (int i = offset; i < length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static long[] unwrap(Long[] a) {
        return LongArrays.unwrap(a, 0, a.length);
    }

    public static long[] unwrap(Long[] a, int length) {
        return LongArrays.unwrap(a, 0, length);
    }

    public static long[] unwrap(Long[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        long[] result = new long[length];
        for (int i = offset; i < length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static long[] pour(LongIterator iter) {
        return LongArrays.pour(iter, Integer.MAX_VALUE);
    }

    public static long[] pour(LongIterator iter, int max) {
        LongCollections.CollectionWrapper list = LongCollections.wrapper();
        LongIterators.pour(iter, list, max);
        return list.toLongArray(new long[list.size()]);
    }

    public static int shiftDown(long[] data, int size, int index, LongComparator comp) {
        int half = size >>> 1;
        long value = data[index];
        if (comp != null) {
            while (index < half) {
                int child = (index << 1) + 1;
                long childValue = data[child];
                int right = child + 1;
                if (right < size && comp.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (comp.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        } else {
            while (index < half) {
                int child = (index << 1) + 1;
                long childValue = data[child];
                int right = child + 1;
                if (right < size && Long.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (Long.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        }
        data[index] = value;
        return index;
    }

    public static int shiftUp(long[] data, int index, LongComparator comp) {
        long value = data[index];
        if (comp != null) {
            int parent;
            long parentValue;
            while (index > 0 && comp.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        } else {
            int parent;
            long parentValue;
            while (index > 0 && Long.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        }
        data[index] = value;
        return index;
    }

    public static long[] heapify(long[] data, int size, LongComparator comp) {
        int i = (size >>> 1) - 1;
        while (i >= 0) {
            LongArrays.shiftDown(data, size, i--, comp);
        }
        return data;
    }

    public static long[] shuffle(long[] array) {
        return LongArrays.shuffle(array, SanityChecks.getRandom());
    }

    public static long[] shuffle(long[] array, int length) {
        return LongArrays.shuffle(array, 0, length, SanityChecks.getRandom());
    }

    public static long[] shuffle(long[] array, int offset, int length) {
        return LongArrays.shuffle(array, offset, length, SanityChecks.getRandom());
    }

    public static long[] shuffle(long[] array, Random random) {
        for (int i = array.length - 1; i >= 0; --i) {
            int p = random.nextInt(i + 1);
            long t = array[i];
            array[i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static long[] shuffle(long[] array, int length, Random random) {
        return LongArrays.shuffle(array, 0, length, random);
    }

    public static long[] shuffle(long[] array, int offset, int length, Random random) {
        for (int i = length - 1; i >= 0; --i) {
            int p = offset + random.nextInt(i + 1);
            long t = array[offset + i];
            array[offset + i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static long[] reverse(long[] array) {
        return LongArrays.reverse(array, 0, array.length);
    }

    public static long[] reverse(long[] array, int length) {
        return LongArrays.reverse(array, 0, length);
    }

    public static long[] reverse(long[] array, int offset, int length) {
        int i = offset;
        int mid = offset + length >> 1;
        int j = offset + length - 1;
        while (i < mid) {
            long temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
        return array;
    }

    public static long[] stableSort(long[] array, LongComparator comp) {
        LongArrays.stableSort(array, 0, array.length, comp);
        return array;
    }

    public static void stableSort(long[] array, int length, LongComparator comp) {
        LongArrays.stableSort(array, 0, length, comp);
    }

    public static void stableSort(long[] array, int from, int to, LongComparator comp) {
        LongArrays.mergeSort(array, null, from, to, comp);
    }

    public static long[] stableSort(long[] array) {
        LongArrays.stableSort(array, 0, array.length);
        return array;
    }

    public static void stableSort(long[] array, int length) {
        LongArrays.stableSort(array, 0, length);
    }

    public static void stableSort(long[] array, int from, int to) {
        LongArrays.mergeSort(array, null, from, to);
    }

    public static long[] unstableSort(long[] array, LongComparator comp) {
        LongArrays.unstableSort(array, 0, array.length, comp);
        return array;
    }

    public static void unstableSort(long[] array, int length, LongComparator comp) {
        LongArrays.unstableSort(array, 0, length, comp);
    }

    public static void unstableSort(long[] array, int from, int to, LongComparator comp) {
        LongArrays.quickSort(array, from, to, comp);
    }

    public static long[] unstableSort(long[] array) {
        LongArrays.unstableSort(array, 0, array.length);
        return array;
    }

    public static void unstableSort(long[] array, int length) {
        LongArrays.unstableSort(array, 0, length);
    }

    public static void unstableSort(long[] array, int from, int to) {
        LongArrays.quickSort(array, from, to);
    }

    public static long[] insertionSort(long[] array, LongComparator comp) {
        LongArrays.insertionSort(array, 0, array.length, comp);
        return array;
    }

    public static void insertionSort(long[] array, int length, LongComparator comp) {
        LongArrays.insertionSort(array, 0, length, comp);
    }

    public static void insertionSort(long[] array, int from, int to, LongComparator comp) {
        for (int i = from + 1; i < to; ++i) {
            long current = array[i];
            int j = i - 1;
            while (j >= from && comp.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static long[] insertionSort(long[] array) {
        LongArrays.insertionSort(array, 0, array.length);
        return array;
    }

    public static void insertionSort(long[] array, int length) {
        LongArrays.insertionSort(array, 0, length);
    }

    public static void insertionSort(long[] array, int from, int to) {
        for (int i = from + 1; i < to; ++i) {
            long current = array[i];
            int j = i - 1;
            while (j >= from && Long.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static long[] selectionSort(long[] array, LongComparator comp) {
        LongArrays.selectionSort(array, 0, array.length, comp);
        return array;
    }

    public static void selectionSort(long[] array, int length, LongComparator comp) {
        LongArrays.selectionSort(array, 0, length, comp);
    }

    public static void selectionSort(long[] array, int from, int to, LongComparator comp) {
        for (int i = from; i < to; ++i) {
            long min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            long temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static long[] selectionSort(long[] array) {
        LongArrays.selectionSort(array, 0, array.length);
        return array;
    }

    public static void selectionSort(long[] array, int length) {
        LongArrays.selectionSort(array, 0, length);
    }

    public static void selectionSort(long[] array, int from, int to) {
        for (int i = from; i < to; ++i) {
            long min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (Long.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            long temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static long[] mergeSort(long[] array, LongComparator comp) {
        LongArrays.mergeSort(array, null, 0, array.length, comp);
        return array;
    }

    public static void mergeSort(long[] array, int length, LongComparator comp) {
        LongArrays.mergeSort(array, null, 0, length, comp);
    }

    public static void mergeSort(long[] array, long[] supp, int from, int to, LongComparator comp) {
        if (to - from < 16) {
            LongArrays.insertionSort(array, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, array, from, mid, comp);
        LongArrays.mergeSort(supp, array, mid, to, comp);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && comp.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static long[] mergeSort(long[] array) {
        LongArrays.mergeSort(array, null, 0, array.length);
        return array;
    }

    public static void mergeSort(long[] array, int length) {
        LongArrays.mergeSort(array, null, 0, length);
    }

    public static void mergeSort(long[] array, long[] supp, int from, int to) {
        if (to - from < 16) {
            LongArrays.insertionSort(array, from, to);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, array, from, mid);
        LongArrays.mergeSort(supp, array, mid, to);
        if (Long.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && Long.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static void parallelMergeSort(long[] array, LongComparator comp) {
        LongArrays.parallelMergeSort(array, null, 0, array.length, comp);
    }

    public static void parallelMergeSort(long[] array, int length, LongComparator comp) {
        LongArrays.parallelMergeSort(array, null, 0, length, comp);
    }

    public static void parallelMergeSort(long[] array, long[] supp, int from, int to, LongComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortActionComp(array, supp, from, to, comp));
            return;
        }
        LongArrays.mergeSort(array, supp, from, to, comp);
    }

    public static void parallelMergeSort(long[] array) {
        LongArrays.parallelMergeSort(array, null, 0, array.length);
    }

    public static void parallelMergeSort(long[] array, int length) {
        LongArrays.parallelMergeSort(array, null, 0, length);
    }

    public static void parallelMergeSort(long[] array, long[] supp, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortAction(array, supp, from, to));
            return;
        }
        LongArrays.mergeSort(array, supp, from, to);
    }

    public static void memFreeMergeSort(long[] array, LongComparator comp) {
        LongArrays.memFreeMergeSort(array, 0, array.length, comp);
    }

    public static void memFreeMergeSort(long[] array, int length, LongComparator comp) {
        LongArrays.memFreeMergeSort(array, 0, length, comp);
    }

    public static void memFreeMergeSort(long[] array, int from, int to, LongComparator comp) {
        if (to - from < 16) {
            LongArrays.insertionSort(array, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.memFreeMergeSort(array, from, mid, comp);
        LongArrays.memFreeMergeSort(array, mid, to, comp);
        if (comp.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int compare = comp.compare(array[i], array[j]);
            if (compare < 0) {
                ++i;
                continue;
            }
            if (compare == 0) {
                LongArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && comp.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                LongArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                long value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            long[] data = new long[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static long[] memFreeMergeSort(long[] array) {
        LongArrays.memFreeMergeSort(array, 0, array.length);
        return array;
    }

    public static void memFreeMergeSort(long[] array, int length) {
        LongArrays.memFreeMergeSort(array, 0, length);
    }

    public static void memFreeMergeSort(long[] array, int from, int to) {
        if (to - from < 16) {
            LongArrays.insertionSort(array, from, to);
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.memFreeMergeSort(array, from, mid);
        LongArrays.memFreeMergeSort(array, mid, to);
        if (Long.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int comp = Long.compare(array[i], array[j]);
            if (comp < 0) {
                ++i;
                continue;
            }
            if (comp == 0) {
                LongArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && Long.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                LongArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                long value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            long[] data = new long[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static void parallelMemFreeMergeSort(long[] array, LongComparator comp) {
        LongArrays.parallelMemFreeMergeSort(array, 0, array.length, comp);
    }

    public static void parallelMemFreeMergeSort(long[] array, int length, LongComparator comp) {
        LongArrays.parallelMemFreeMergeSort(array, 0, length, comp);
    }

    public static void parallelMemFreeMergeSort(long[] array, int from, int to, LongComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortActionComp(array, from, to, comp));
            return;
        }
        LongArrays.memFreeMergeSort(array, from, to, comp);
    }

    public static void parallelMemFreeMergeSort(long[] array) {
        LongArrays.parallelMemFreeMergeSort(array, 0, array.length);
    }

    public static void parallelMemFreeMergeSort(long[] array, int length) {
        LongArrays.parallelMemFreeMergeSort(array, 0, length);
    }

    public static void parallelMemFreeMergeSort(long[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortAction(array, from, to));
            return;
        }
        LongArrays.memFreeMergeSort(array, from, to);
    }

    public static long[] quickSort(long[] array, LongComparator comp) {
        LongArrays.quickSort(array, 0, array.length, comp);
        return array;
    }

    public static void quickSort(long[] array, int length, LongComparator comp) {
        LongArrays.quickSort(array, 0, length, comp);
    }

    public static void quickSort(long[] array, int from, int to, LongComparator comp) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            LongArrays.selectionSort(array, from, to, comp);
            return;
        }
        long pivot = array[length > 128 ? LongArrays.subMedium(array, from, from + length / 2, to - 1, length / 8, comp) : LongArrays.medium(array, from, from + length / 2, to - 1, comp)];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int compare;
            if (b <= c && (compare = comp.compare(array[b], pivot)) <= 0) {
                if (compare == 0) {
                    LongArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (compare = comp.compare(array[c], pivot)) >= 0) {
                if (compare == 0) {
                    LongArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(array, b++, c--);
        }
        LongArrays.swap(array, from, b, Math.min(a - from, b - a));
        LongArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            LongArrays.quickSort(array, from, from + length, comp);
        }
        if ((length = d - c) > 1) {
            LongArrays.quickSort(array, to - length, to, comp);
        }
    }

    public static long[] quickSort(long[] array) {
        LongArrays.quickSort(array, 0, array.length);
        return array;
    }

    public static void quickSort(long[] array, int length) {
        LongArrays.quickSort(array, 0, length);
    }

    public static void quickSort(long[] array, int from, int to) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            LongArrays.selectionSort(array, from, to);
            return;
        }
        long pivot = array[length > 128 ? LongArrays.subMedium(array, from, from + length / 2, to - 1, length / 8) : LongArrays.medium(array, from, from + length / 2, to - 1)];
        int b = a = from;
        int d = c = to - 1;
        int comp = 0;
        while (true) {
            if (b <= c && (comp = Long.compare(array[b], pivot)) <= 0) {
                if (comp == 0) {
                    LongArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Long.compare(array[c], pivot)) >= 0) {
                if (comp == 0) {
                    LongArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(array, b++, c--);
        }
        LongArrays.swap(array, from, b, Math.min(a - from, b - a));
        LongArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            LongArrays.quickSort(array, from, from + length);
        }
        if ((length = d - c) > 1) {
            LongArrays.quickSort(array, to - length, to);
        }
    }

    public static void parallelQuickSort(long[] array, LongComparator comp) {
        LongArrays.parallelQuickSort(array, 0, array.length, comp);
    }

    public static void parallelQuickSort(long[] array, int length, LongComparator comp) {
        LongArrays.parallelQuickSort(array, 0, length, comp);
    }

    public static void parallelQuickSort(long[] array, int from, int to, LongComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortActionComp(array, from, to, comp));
            return;
        }
        LongArrays.quickSort(array, from, to, comp);
    }

    public static void parallelQuickSort(long[] array) {
        LongArrays.parallelQuickSort(array, 0, array.length);
    }

    public static void parallelQuickSort(long[] array, int length) {
        LongArrays.parallelQuickSort(array, 0, length);
    }

    public static void parallelQuickSort(long[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortAction(array, from, to));
            return;
        }
        LongArrays.quickSort(array, from, to);
    }

    static void swap(long[] a, int from, int to) {
        long t = a[from];
        a[from] = a[to];
        a[to] = t;
    }

    static void swap(long[] a, int from, int to, int length) {
        to -= length;
        for (int i = 0; i < length; ++i) {
            LongArrays.swap(a, from++, to++);
        }
    }

    static int subMedium(long[] data, int a, int b, int c, int length, LongComparator comp) {
        return LongArrays.medium(data, LongArrays.medium(data, a, a + length, a + length * 2, comp), LongArrays.medium(data, b - length, b, b + length, comp), LongArrays.medium(data, c - length * 2, c - length, c, comp), comp);
    }

    static int medium(long[] data, int a, int b, int c, LongComparator comp) {
        return comp.compare(data[a], data[b]) < 0 ? (comp.compare(data[b], data[c]) < 0 ? b : (comp.compare(data[a], data[c]) < 0 ? c : a)) : (comp.compare(data[b], data[c]) > 0 ? b : (comp.compare(data[a], data[c]) > 0 ? c : a));
    }

    static int subMedium(long[] data, int a, int b, int c, int length) {
        return LongArrays.medium(data, LongArrays.medium(data, a, a + length, a + length * 2), LongArrays.medium(data, b - length, b, b + length), LongArrays.medium(data, c - length * 2, c - length, c));
    }

    static int medium(long[] data, int a, int b, int c) {
        return Long.compare(data[a], data[b]) < 0 ? (Long.compare(data[b], data[c]) < 0 ? b : (Long.compare(data[a], data[c]) < 0 ? c : a)) : (Long.compare(data[b], data[c]) > 0 ? b : (Long.compare(data[a], data[c]) > 0 ? c : a));
    }

    static class MemFreeMergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        int from;
        int to;
        LongComparator comp;

        MemFreeMergeSortActionComp(long[] array, int from, int to, LongComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                LongArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortActionComp.invokeAll(new MemFreeMergeSortActionComp(this.array, this.from, mid, this.comp), new MemFreeMergeSortActionComp(this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int compare = this.comp.compare(this.array[i], this.array[j]);
                if (compare < 0) {
                    ++i;
                    continue;
                }
                if (compare == 0) {
                    LongArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && this.comp.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    LongArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    long value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                long[] data = new long[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MemFreeMergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        int from;
        int to;

        MemFreeMergeSortAction(long[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                LongArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortAction.invokeAll(new MemFreeMergeSortAction(this.array, this.from, mid), new MemFreeMergeSortAction(this.array, mid, this.to));
            if (Long.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int comp = Long.compare(this.array[i], this.array[j]);
                if (comp < 0) {
                    ++i;
                    continue;
                }
                if (comp == 0) {
                    LongArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && Long.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    LongArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    long value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                long[] data = new long[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        long[] supp;
        int from;
        int to;
        LongComparator comp;

        MergeSortActionComp(long[] array, long[] supp, int from, int to, LongComparator comp) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                LongArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortActionComp.invokeAll(new MergeSortActionComp(this.supp, this.array, this.from, mid, this.comp), new MergeSortActionComp(this.supp, this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && this.comp.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class MergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        long[] supp;
        int from;
        int to;

        MergeSortAction(long[] array, long[] supp, int from, int to) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                LongArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortAction.invokeAll(new MergeSortAction(this.supp, this.array, this.from, mid), new MergeSortAction(this.supp, this.array, mid, this.to));
            if (Long.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && Long.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class QuickSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        int from;
        int to;
        LongComparator comp;

        QuickSortActionComp(long[] array, int from, int to, LongComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                LongArrays.selectionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            long pivot = this.array[length > 128 ? LongArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8, this.comp) : LongArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1, this.comp)];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int compare;
                if (b <= c && (compare = this.comp.compare(this.array[b], pivot)) <= 0) {
                    if (compare == 0) {
                        LongArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (compare = this.comp.compare(this.array[c], pivot)) >= 0) {
                    if (compare == 0) {
                        LongArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                LongArrays.swap(this.array, b++, c--);
            }
            LongArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            LongArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortActionComp.invokeAll(new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp), new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp));
            } else if (b - a > 1) {
                new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp).invoke();
            } else if (d - c > 1) {
                new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp).invoke();
            }
        }
    }

    static class QuickSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        long[] array;
        int from;
        int to;

        QuickSortAction(long[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                LongArrays.selectionSort(this.array, this.from, this.to);
                return;
            }
            long pivot = this.array[length > 128 ? LongArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8) : LongArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1)];
            int b = a = this.from;
            int d = c = this.to - 1;
            int comp = 0;
            while (true) {
                if (b <= c && (comp = Long.compare(this.array[b], pivot)) <= 0) {
                    if (comp == 0) {
                        LongArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comp = Long.compare(this.array[c], pivot)) >= 0) {
                    if (comp == 0) {
                        LongArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                LongArrays.swap(this.array, b++, c--);
            }
            LongArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            LongArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortAction.invokeAll(new QuickSortAction(this.array, this.from, this.from + (b - a)), new QuickSortAction(this.array, this.to - (d - c), this.to));
            } else if (b - a > 1) {
                new QuickSortAction(this.array, this.from, this.from + (b - a)).invoke();
            } else if (d - c > 1) {
                new QuickSortAction(this.array, this.to - (d - c), this.to).invoke();
            }
        }
    }
}

