/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ChunkProviderServer.class})
public abstract class MixinChunkProviderServer {
    @Shadow
    public WorldServer field_73251_h;

    @Redirect(method={"unloadChunksIfNotNearSpawn"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/DimensionManager;shouldLoadSpawn(I)Z", remap=false))
    private boolean neverLoadSpawn(int dim) {
        return !ArchaicConfig.disableSpawnChunks && DimensionManager.shouldLoadSpawn((int)dim);
    }

    @Redirect(method={"originalLoadChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunkProvider;provideChunk(II)Lnet/minecraft/world/chunk/Chunk;", remap=true), remap=false)
    private Chunk populateChunkWithBiomes(IChunkProvider instance, int chunkX, int chunkZ) {
        Chunk chunk = instance.func_73154_d(chunkX, chunkZ);
        if (chunk != null) {
            WorldChunkManager manager = chunk.field_76637_e.func_72959_q();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    chunk.func_76591_a(x, z, manager);
                }
            }
        }
        return chunk;
    }
}

