/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.technus.tectech.recipe.TT_recipeAdder;
import cpw.mods.fml.common.registry.GameRegistry;
import goodgenerator.items.MyMaterial;
import goodgenerator.loader.Loaders;
import goodgenerator.util.ItemRefer;
import goodgenerator.util.Log;
import goodgenerator.util.StackUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.recipe.common.CI;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class ComponentAssemblyLineMiscRecipes {
    public static final String[] circuitTierMaterials = new String[]{"Primitive", "Basic", "Good", "Advanced", "Data", "Elite", "Master", "Ultimate", "Superconductor", "Infinite", "Bio", "Optical", "Piko", "Quantum"};
    static final HashMap<String, Integer> NameToTier = new HashMap();

    static void run() {
        ItemStack solidifier;
        for (int i = 0; i < circuitTierMaterials.length; ++i) {
            NameToTier.put(circuitTierMaterials[i], i);
        }
        NameToTier.put("Nano", 11);
        ComponentAssemblyLineMiscRecipes.generateCasingRecipes();
        ComponentAssemblyLineMiscRecipes.generateWrapRecipes();
        try {
            Class<?> c = Class.forName("com.dreammaster.gthandler.CustomItemList");
            Object maybeSolidifier = c.getMethod("valueOf", String.class).invoke(null, "FluidSolidifierZPM");
            solidifier = (ItemStack)c.getMethod("get", Long.TYPE, Object[].class).invoke(maybeSolidifier, 16L, null);
            if (!GT_Utility.isStackValid((ItemStack)solidifier)) {
                throw new NullPointerException();
            }
            Log.LOGGER.log(Level.INFO, "ZPM Fluid Solidifier found.");
        }
        catch (Exception e) {
            Log.LOGGER.log(Level.ERROR, "ZPM Fluid Solidifier not found, falling back to IV.", (Throwable)e);
            solidifier = ItemList.Machine_IV_FluidSolidifier.get(16L, new Object[0]);
        }
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemRefer.Compassline_Casing_EV.get(1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)72000).itemInputs(new Object[]{ItemList.Machine_Multi_Assemblyline.get(16L, new Object[0]), ItemList.Casing_Assembler.get(16L, new Object[0]), ItemList.Casing_Gearbox_TungstenSteel.get(32L, new Object[0]), ComponentType.Robot_Arm.getComponent(8).get(16L, new Object[0]), ComponentType.Conveyor_Module.getComponent(8).get(32L, new Object[0]), ComponentType.Electric_Motor.getComponent(7).get(32L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.pipeMedium, (Object)Materials.Polybenzimidazole, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Iridium, (long)32L), solidifier, ComponentAssemblyLineMiscRecipes.getALCircuit(8, 16), ComponentAssemblyLineMiscRecipes.getALCircuit(7, 20), ComponentAssemblyLineMiscRecipes.getALCircuit(6, 24)}).fluidInputs(new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"molten.indalloy140"), 1728), Materials.Naquadria.getMolten(2304L), Materials.Lubricant.getFluid(5000L)}).itemOutputs(new ItemStack[]{ItemRefer.Component_Assembly_Line.get(1)}).eut(TierEU.RECIPE_UHV / 2L).duration(600).addTo(GT_RecipeConstants.AssemblyLine);
    }

    private static void generateCasingRecipes() {
        int t = 1;
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Steel, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Steel, (long)4L), ComponentType.Robot_Arm.getComponent(t).get(4L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(8L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(10L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Steel, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.Tin, (long)6L), ComponentAssemblyLineMiscRecipes.getCircuit(t, 16L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten((long)(144 * (t + 1)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_LV.get(1)}).duration(320).eut(GT_Values.VP[t]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Aluminium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Aluminium, (long)4L), ComponentType.Robot_Arm.getComponent(++t).get(4L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(8L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(10L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Aluminium, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.AnyCopper, (long)6L), ComponentAssemblyLineMiscRecipes.getCircuit(t, 8L), ComponentAssemblyLineMiscRecipes.getCircuit(t - 1, 16L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten((long)(144 * (t + 1)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_MV.get(1)}).duration(320).eut(GT_Values.VP[t]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.StainlessSteel, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.StainlessSteel, (long)4L), ComponentType.Robot_Arm.getComponent(++t).get(4L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(8L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(10L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.StainlessSteel, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.Gold, (long)6L), ComponentAssemblyLineMiscRecipes.getCircuit(t, 8L), ComponentAssemblyLineMiscRecipes.getCircuit(t - 1, 16L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten((long)(144 * (t + 1)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_HV.get(1)}).duration(320).eut(GT_Values.VP[t]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Titanium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Titanium, (long)4L), ComponentType.Robot_Arm.getComponent(++t).get(4L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(8L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(10L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Titanium, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.Aluminium, (long)6L), ComponentAssemblyLineMiscRecipes.getCircuit(t, 8L), ComponentAssemblyLineMiscRecipes.getCircuit(t - 1, 16L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten((long)(144 * (t + 1)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_EV.get(1)}).duration(320).eut(GT_Values.VP[t]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.TungstenSteel, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.TungstenSteel, (long)4L), ComponentType.Robot_Arm.getComponent(++t).get(4L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(8L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(10L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.TungstenSteel, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.Tungsten, (long)6L), ComponentAssemblyLineMiscRecipes.getCircuit(t, 8L), ComponentAssemblyLineMiscRecipes.getCircuit(t - 1, 16L)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten((long)(144 * (t + 1)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_IV.get(1)}).duration(320).eut(GT_Values.VP[t]).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        Fluid sold = FluidRegistry.getFluid((String)"molten.indalloy140");
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemRefer.Compassline_Casing_IV.get(1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)((2250 << t) * 1)).itemInputs(new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Europium, (long)1L), WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.plateDense, 6), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.gearGt, 4), WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.gearGtSmall, 16), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.VanadiumGallium, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}).fluidInputs(new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_LuV.get(1)}).eut(TierEU.RECIPE_IV).duration(600).addTo(GT_RecipeConstants.AssemblyLine);
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemRefer.Compassline_Casing_LuV.get(1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)((2250 << t) * 1)).itemInputs(new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Iridium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Iridium, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Iridium, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Iridium, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.Naquadah, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}).fluidInputs(new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_ZPM.get(1)}).eut(TierEU.RECIPE_LuV).duration(600).addTo(GT_RecipeConstants.AssemblyLine);
        GT_Values.RA.stdBuilder().metadata(GT_RecipeConstants.RESEARCH_ITEM, (Object)ItemRefer.Compassline_Casing_ZPM.get(1)).metadata(GT_RecipeConstants.RESEARCH_TIME, (Object)((2250 << t) * 1)).itemInputs(new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Osmium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Osmium, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Osmium, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Osmium, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.NaquadahAlloy, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}).fluidInputs(new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}).itemOutputs(new ItemStack[]{ItemRefer.Compassline_Casing_UV.get(1)}).eut(TierEU.RECIPE_ZPM).duration(600).addTo(GT_RecipeConstants.AssemblyLine);
        TT_recipeAdder.addResearchableAssemblylineRecipe((ItemStack)ItemRefer.Compassline_Casing_UV.get(1), (int)(375 << t - 2), (int)(1 << t - 3), (int)((int)TierEU.RECIPE_UV), (int)1, (Object[])new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.CosmicNeutronium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.CosmicNeutronium, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.CosmicNeutronium, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.CosmicNeutronium, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.Bedrockium, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}, (FluidStack[])new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}, (ItemStack)ItemRefer.Compassline_Casing_UHV.get(1), (int)1000, (int)((int)TierEU.RECIPE_UV));
        sold = FluidRegistry.getFluid((String)"molten.mutatedlivingsolder");
        TT_recipeAdder.addResearchableAssemblylineRecipe((ItemStack)ItemRefer.Compassline_Casing_UHV.get(1), (int)(375 << t - 2), (int)(1 << t - 3), (int)((int)TierEU.RECIPE_UHV), (int)1, (Object[])new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)Materials.Infinity, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)Materials.Infinity, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)Materials.Infinity, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Infinity, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.Draconium, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}, (FluidStack[])new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}, (ItemStack)ItemRefer.Compassline_Casing_UEV.get(1), (int)1000, (int)((int)TierEU.RECIPE_UHV));
        TT_recipeAdder.addResearchableAssemblylineRecipe((ItemStack)ItemRefer.Compassline_Casing_UEV.get(1), (int)(375 << t - 2), (int)(1 << t - 3), (int)((int)TierEU.RECIPE_UEV), (int)1, (Object[])new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)MaterialsUEVplus.TranscendentMetal, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)MaterialsUEVplus.TranscendentMetal, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)MaterialsUEVplus.TranscendentMetal, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)MaterialsUEVplus.TranscendentMetal, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.NetherStar, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}, (FluidStack[])new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)t, (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}, (ItemStack)ItemRefer.Compassline_Casing_UIV.get(1), (int)1000, (int)((int)TierEU.RECIPE_UEV));
        TT_recipeAdder.addResearchableAssemblylineRecipe((ItemStack)ItemRefer.Compassline_Casing_UIV.get(1), (int)(375 << t - 2), (int)(1 << t - 3), (int)((int)TierEU.RECIPE_UIV), (int)1, (Object[])new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)MaterialsUEVplus.SpaceTime, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)MaterialsUEVplus.SpaceTime, (long)6L), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)MaterialsUEVplus.SpaceTime, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)MaterialsUEVplus.SpaceTime, (long)16L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.Quantium, (long)8L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}, (FluidStack[])new FluidStack[]{new FluidStack(sold, 144 * t * 4), CI.getTieredFluid((int)(t - 1), (int)(144 * t * 2)), StackUtils.getTieredFluid(t, 144 * t), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}, (ItemStack)ItemRefer.Compassline_Casing_UMV.get(1), (int)1000, (int)((int)TierEU.RECIPE_UIV));
        TT_recipeAdder.addResearchableAssemblylineRecipe((ItemStack)ItemRefer.Compassline_Casing_UMV.get(1), (int)(375 << t - 2), (int)(1 << t - 3), (int)((int)TierEU.RECIPE_UMV), (int)1, (Object[])new Object[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.frameGt, (Object)MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plateDense, (Object)MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, (long)3L), MyMaterial.shirabon.get(OrePrefixes.plateDense, 3), ComponentType.Robot_Arm.getComponent(++t).get(8L, new Object[0]), ComponentType.Electric_Piston.getComponent(t).get(10L, new Object[0]), ComponentType.Electric_Motor.getComponent(t).get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGt, (Object)MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, (long)2L), MyMaterial.shirabon.get(OrePrefixes.gearGt, 2), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, (long)8L), MyMaterial.shirabon.get(OrePrefixes.gearGtSmall, 8), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)Materials.Infinity, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)MaterialsUEVplus.SpaceTime, (long)4L), ComponentAssemblyLineMiscRecipes.getALCircuit(t, 8), ComponentAssemblyLineMiscRecipes.getALCircuit(t - 1, 16)}, (FluidStack[])new FluidStack[]{new FluidStack(sold, 144 * t * 4), MaterialsUEVplus.BlackDwarfMatter.getMolten((long)(144 * t * 2)), MaterialsUEVplus.Eternity.getMolten((long)(144 * t)), Materials.Lubricant.getFluid((long)(1000 * (t - 2)))}, (ItemStack)ItemRefer.Compassline_Casing_UXV.get(1), (int)1000, (int)((int)TierEU.RECIPE_UMV));
    }

    private static void generateWrapRecipes() {
        for (int i = 0; i <= 11; ++i) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ComponentAssemblyLineMiscRecipes.getCircuit(i, 16L), GT_Utility.getIntegratedCircuit((int)16)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(72L)}).itemOutputs(new ItemStack[]{new ItemStack(Loaders.circuitWrap, 1, i)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        }
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GameRegistry.findItemStack((String)"dreamcraft", (String)"item.PikoCircuit", (int)16), GT_Utility.getIntegratedCircuit((int)16)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(72L)}).itemOutputs(new ItemStack[]{new ItemStack(Loaders.circuitWrap, 1, 12)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GameRegistry.findItemStack((String)"dreamcraft", (String)"item.QuantumCircuit", (int)16), GT_Utility.getIntegratedCircuit((int)16)}).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getMolten(72L)}).itemOutputs(new ItemStack[]{new ItemStack(Loaders.circuitWrap, 1, 13)}).duration(600).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }

    private static ItemStack getCircuit(int tier, long amount) {
        return GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)ComponentAssemblyLineMiscRecipes.getCircuitMaterial(tier), (long)amount);
    }

    private static Object[] getALCircuit(int tier, int amount) {
        return new Object[]{OrePrefixes.circuit.get((Object)ComponentAssemblyLineMiscRecipes.getCircuitMaterial(tier)), amount};
    }

    @Nullable
    public static Materials getCircuitMaterial(int tier) {
        return Materials.getRealMaterial((String)circuitTierMaterials[tier]);
    }

    private static enum ComponentType {
        Electric_Motor,
        Electric_Piston,
        Robot_Arm,
        Electric_Pump,
        Field_Generator,
        Conveyor_Module,
        Emitter,
        Sensor;


        public ItemList getComponent(int tier) {
            if (tier < 0 || tier > GT_Values.VN.length) {
                throw new IllegalArgumentException("Tier is out of range!");
            }
            return ItemList.valueOf((String)(this.name() + "_" + GT_Values.VN[tier]));
        }
    }
}

