/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import goodgenerator.blocks.tileEntity.base.LargeFusionComputer;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class LargeFusionComputer2
extends LargeFusionComputer {
    private static final ITexture textureOverlay = TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FUSION2}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FUSION2_GLOW}).extFacing().glow().build()});

    public LargeFusionComputer2(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public LargeFusionComputer2(String name) {
        super(name);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Reactor").addInfo("Millions of nuclear.").addInfo("Controller block for the Compact Fusion Reactor MK-II.").addInfo(EnumChatFormatting.AQUA + GT_Utility.formatNumbers((long)this.getSingleHatchPower()) + EnumChatFormatting.GRAY + " EU/t and " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers((long)(this.capableStartupCanonical() / 32L / 1000000L)) + "M" + EnumChatFormatting.GRAY + " EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").addInfo("If the recipe requires a voltage tier over " + GT_Utility.getColoredTierNameFromTier((byte)((byte)this.tier())) + EnumChatFormatting.GRAY + " , you can't do it either").addInfo("Make sure the whole structure is built in the 3x3").addInfo("chunk area of the ring center (not controller).").addInfo("Startup < 160,000,000 EU: 128x Parallel").addInfo("Startup >= 160,000,000 EU: 64x Parallel").addInfo("Support" + EnumChatFormatting.BLUE + " Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Energy/Laser Hatches!").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addCasingInfo("Fusion Machine Casing", 1664).addCasingInfo("Compact Fusion Coil", 560).addCasingInfo("Duranium Frame Box", 128).addCasingInfo("Iridium Reinforced Borosilicate Glass Block", 63).addEnergyHatch("1-32, Hint block with dot 2", new int[]{2}).addInputHatch("1-16, Hint block with dot 1", new int[]{1}).addOutputHatch("1-16, Hint block with dot 1", new int[]{1}).addStructureInfo("Supports Crafting Input Buffer").addStructureInfo("ALL Hatches must be " + GT_Utility.getColoredTierNameFromTier((byte)((byte)this.hatchTier())) + EnumChatFormatting.GRAY + " or better").toolTipFinisher("Good Generator");
        return tt;
    }

    @Override
    public int tier() {
        return 7;
    }

    @Override
    public long capableStartupCanonical() {
        return 320000000L;
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public int getCasingMeta() {
        return 6;
    }

    @Override
    public Block getCoilBlock() {
        return Loaders.compactFusionCoil;
    }

    @Override
    public int getCoilMeta() {
        return 1;
    }

    @Override
    public Block getGlassBlock() {
        return ItemRegistry.bw_realglas;
    }

    @Override
    public int getGlassMeta() {
        return 4;
    }

    @Override
    public int hatchTier() {
        return 7;
    }

    @Override
    public Materials getFrameBox() {
        return Materials.Duranium;
    }

    @Override
    public int getMaxPara() {
        return 64;
    }

    @Override
    public int extraPara(int startEnergy) {
        return startEnergy < 160000000 ? 2 : 1;
    }

    @Override
    public ITexture getTextureOverlay() {
        return textureOverlay;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("LargeFusion2.hint", 9);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new LargeFusionComputer2(this.mName);
    }
}

