/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;

public class BlobPopulatorCave
extends BlobPopulator {
    private IRandomAmount fullAmountGen = IRandomAmount.exact;
    private IRandomAmount totalAmountGen = IRandomAmount.exact;
    private byte minFullCaveAmount;
    private byte maxFullCaveAmount;
    private byte minTotalCaveAmountLimit;
    private byte maxTotalCaveAmountLimit;
    private byte maxRecursion;
    private double minRad;
    private double maxRad;
    private double minRecursionChance;
    private double maxRecursionChance;
    private double minRecursionRadMp;
    private double maxRecursionRadMp;
    private boolean recursionChanceCached = false;
    private int tmpCavesLeft;
    private double tmpRecursionChance;

    public BlobPopulatorCave(int weight) {
        super(weight);
    }

    public BlobPopulatorCave rad(double minRad, double maxRad) {
        this.minRad = minRad;
        this.maxRad = maxRad;
        return this;
    }

    public BlobPopulatorCave fullCaveAmount(IRandomAmount fullAmountGen, int minFullCaveAmount, int maxFullCaveAmount) {
        this.fullAmountGen = fullAmountGen;
        this.minFullCaveAmount = (byte)minFullCaveAmount;
        this.maxFullCaveAmount = (byte)maxFullCaveAmount;
        return this;
    }

    public BlobPopulatorCave totalCaveAmount(IRandomAmount totalAmountGen, int minTotalCaveAmountLimit, int maxTotalCaveAmountLimit) {
        this.totalAmountGen = totalAmountGen;
        this.minTotalCaveAmountLimit = (byte)minTotalCaveAmountLimit;
        this.maxTotalCaveAmountLimit = (byte)maxTotalCaveAmountLimit;
        return this;
    }

    public BlobPopulatorCave recursionChance(double minRecursionChance, double maxRecursionChance, int maxRecursion) {
        this.minRecursionChance = minRecursionChance;
        this.maxRecursionChance = maxRecursionChance;
        this.maxRecursion = (byte)maxRecursion;
        return this;
    }

    public BlobPopulatorCave recursionRadMp(double minRadMp, double maxRadMp) {
        this.minRecursionRadMp = minRadMp;
        this.maxRecursionRadMp = maxRadMp;
        return this;
    }

    public BlobPopulatorCave cacheRecursionChance() {
        this.recursionChanceCached = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        this.tmpCavesLeft = this.totalAmountGen.generate(rand, this.minTotalCaveAmountLimit, this.maxTotalCaveAmountLimit);
        this.tmpRecursionChance = this.minRecursionChance + rand.nextDouble() * (this.maxRecursionChance - this.minRecursionChance);
        int amount = this.fullAmountGen.generate(rand, this.minFullCaveAmount, this.maxFullCaveAmount);
        int generated = 0;
        for (int attempt = 0; attempt < amount * 5 && generated < amount; ++attempt) {
            if (!this.genFullCave(gen, rand, this.minRad + rand.nextDouble() * (this.maxRad - this.minRad))) continue;
            ++generated;
        }
    }

    private boolean genFullCave(DecoratorFeatureGenerator gen, Random rand, double rad) {
        int side = rand.nextInt(6);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (side <= 3) {
            x = rand.nextInt(32) - 16;
        } else {
            float f = x = side == 4 ? 15.0f : -16.0f;
        }
        if (side <= 1 || side >= 4) {
            y = rand.nextInt(32) - 16;
        } else {
            float f = y = side == 2 ? 15.0f : -16.0f;
        }
        if (side >= 2) {
            z = rand.nextInt(32) - 16;
        } else {
            float f = z = side == 0 ? 15.0f : -16.0f;
        }
        if (this.genCave(gen, rand, x, y, z, rad, Vec3.func_72443_a((double)(-x), (double)(-y), (double)(-z)).func_72432_b(), 0)) {
            --this.tmpCavesLeft;
            return true;
        }
        return false;
    }

    private boolean genCave(DecoratorFeatureGenerator gen, Random rand, double x, double y, double z, double rad, Vec3 dirVec, int recursionLevel) {
        if (this.tmpCavesLeft < 0 || recursionLevel > this.maxRecursion) {
            return false;
        }
        boolean generatedSomething = false;
        Vec3 dirChangeVec = null;
        double dirChangeMp = 0.0;
        ArrayList<double[]> recursionLocs = new ArrayList<double[]>();
        for (int a = 0; a < 50; ++a) {
            if (BlobGenerator.genBlob(gen, x, y, z, rad, Blocks.field_150350_a)) {
                generatedSomething = true;
            }
            if (a == 0 || rand.nextInt(10) == 0) {
                dirChangeVec = DragonUtil.getRandomVector(rand);
                dirChangeMp = rand.nextDouble();
            }
            dirVec.field_72450_a += dirChangeVec.field_72450_a * dirChangeMp;
            dirVec.field_72448_b += dirChangeVec.field_72448_b * dirChangeMp;
            dirVec.field_72449_c += dirChangeVec.field_72449_c * dirChangeMp;
            x += dirVec.field_72450_a;
            y += dirVec.field_72448_b;
            z += dirVec.field_72449_c;
            if (!this.recursionChanceCached && a > 0) {
                this.tmpRecursionChance = (this.minRecursionChance + rand.nextDouble() * (this.maxRecursionChance - this.minRecursionChance)) / (double)(recursionLevel + 1);
            }
            if (!(rand.nextDouble() < this.tmpRecursionChance)) continue;
            recursionLocs.add(new double[]{x, y, z});
        }
        if (generatedSomething) {
            for (double[] loc : recursionLocs) {
                Vec3 newVec = dirVec.func_72431_c(DragonUtil.getRandomVector(rand)).func_72432_b();
                if (!this.genCave(gen, rand, loc[0], loc[1], loc[2], rad * (this.minRecursionRadMp + rand.nextDouble() * (this.maxRecursionRadMp - this.minRecursionRadMp)), newVec, recursionLevel + 1)) continue;
                --this.tmpCavesLeft;
            }
        }
        return generatedSomething;
    }
}

