/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.rotations;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import openmods.geometry.Orientation;
import openmods.renderer.rotations.ClonerSetup;
import openmods.renderer.rotations.IRendererSetup;
import openmods.renderer.rotations.VanillaSetup;

public abstract class RendererSetupProxy {
    public static final IRendererSetup NULL = new IRendererSetup(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public RenderBlocks enter(Orientation orientation, int metadata, RenderBlocks renderer) {
            return renderer;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void exit(RenderBlocks renderer) {
        }
    };
    @SidedProxy(clientSide="openmods.renderer.rotations.RendererSetupProxy$Client", serverSide="openmods.renderer.rotations.RendererSetupProxy$Server", modId="OpenMods")
    public static RendererSetupProxy proxy;

    public abstract IRendererSetup getVanillaRenderer();

    public abstract IRendererSetup getFixedRenderer();

    public abstract IRendererSetup getTweakedRenderer();

    public static class Client
    extends RendererSetupProxy {
        @Override
        public IRendererSetup getVanillaRenderer() {
            return VanillaSetup.instance;
        }

        @Override
        public IRendererSetup getTweakedRenderer() {
            return ClonerSetup.tweakedSetup;
        }

        @Override
        public IRendererSetup getFixedRenderer() {
            return ClonerSetup.fixedSetup;
        }
    }

    public static class Server
    extends RendererSetupProxy {
        @Override
        public IRendererSetup getVanillaRenderer() {
            return NULL;
        }

        @Override
        public IRendererSetup getTweakedRenderer() {
            return NULL;
        }

        @Override
        public IRendererSetup getFixedRenderer() {
            return NULL;
        }
    }
}

