/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventButtonClicked;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;

public class ControlButton
extends Control {
    private ControlText textWidget;
    private String text;
    private EventMouse.Down.Handler mouseHandler = new EventMouse.Down.Handler(){

        @Override
        public void onEvent(EventMouse.Down event) {
            ControlButton.this.callEvent(new EventButtonClicked(ControlButton.this.getWidget()));
            ControlButton.this.onMouseClick(event);
        }
    };

    public ControlButton(IWidget parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.mouseHandler.setOrigin(EventHandler.Origin.Self, this);
        this.addEventHandler((EventHandler)this.mouseHandler);
    }

    public ControlButton(IWidget parent, float x, float y, float width, float height, String text) {
        this(parent, x, y, width, height);
        this.text = text;
        this.textWidget = new ControlText(this, this.getArea(), text, TextJustification.MIDDLE_CENTER);
    }

    protected void onMouseClick(EventMouse.Down event) {
    }

    @Override
    public void onUpdateClient() {
        if (this.textWidget != null) {
            this.textWidget.setValue(this.getText());
        }
    }

    @Override
    public void onRenderBackground() {
        CraftGUITexture texture = CraftGUITexture.ButtonDisabled;
        if (this.isMouseOver()) {
            texture = CraftGUITexture.ButtonHighlighted;
        } else if (this.isEnabled()) {
            texture = CraftGUITexture.Button;
        }
        CraftGUI.render.texture((Object)texture, this.getArea());
    }

    public String getText() {
        return this.text;
    }
}

