/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.backups.Backups;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.events.player.ForgePlayerConfigEvent;
import serverutils.events.player.ForgePlayerDataEvent;
import serverutils.events.player.ForgePlayerLoggedInEvent;
import serverutils.events.player.ForgePlayerLoggedOutEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageSyncData;

public class ServerUtilitiesPlayerEventHandler {
    public static final ServerUtilitiesPlayerEventHandler INST = new ServerUtilitiesPlayerEventHandler();

    @SubscribeEvent
    public void registerPlayerData(ForgePlayerDataEvent event) {
        event.register(new ServerUtilitiesPlayerData(event.getPlayer()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (ServerUtils.isFirstLogin((EntityPlayer)player, "serverutilities_starting_items") && ServerUtilitiesConfig.login.enable_starting_items) {
            InvUtils.giveItemFromIterable((EntityPlayer)player, ServerUtilitiesConfig.login.getStartingItems());
        }
        if (ServerUtilitiesConfig.login.enable_motd) {
            for (IChatComponent t : ServerUtilitiesConfig.login.getMOTD()) {
                player.func_145747_a(t);
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        Backups.hadPlayer = true;
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(ForgePlayerLoggedOutEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        ServerUtilitiesUniverseData.updateBadge(player.func_110124_au());
        player.getEntityData().func_82580_o("serveru_lchunk");
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        event.entityPlayer.getEntityData().func_82580_o("serveru_lchunk");
    }

    @SubscribeEvent
    public void getPlayerSettings(ForgePlayerConfigEvent event) {
        ServerUtilitiesPlayerData.get(event.getPlayer()).addConfig(event.getConfig());
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)entityPlayerMP));
            data.setLastDeath(new BlockDimPos((Entity)entity));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChunkChanged(EntityEvent.EnteringChunk event) {
        EntityPlayerMP player;
        block5: {
            block4: {
                Entity entity;
                if (event.entity.field_70170_p.field_72995_K || !((entity = event.entity) instanceof EntityPlayerMP)) break block4;
                player = (EntityPlayerMP)entity;
                if (Universe.loaded()) break block5;
            }
            return;
        }
        player.func_143004_u();
        ForgePlayer p = Universe.get().getPlayer(player.func_146103_bH());
        if (p == null || p.isFake()) {
            return;
        }
        ServerUtilitiesPlayerData.get(p).setLastSafePos(new BlockDimPos((ICommandSender)player));
        ServerUtilitiesNotifications.updateChunkMessage(player, new ChunkDimPos(event.newChunkX, event.newChunkZ, player.field_71093_bK));
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        if (ServerUtilitiesConfig.world.disable_player_suffocation_damage && event.entity instanceof EntityPlayer && event.source == DamageSource.field_76368_d) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityAttacked(AttackEntityEvent event) {
        if (!ClaimedChunks.canAttackEntity(event.entityPlayer, event.target)) {
            InvUtils.forceUpdate(event.entityPlayer);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteraction(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        boolean cancelled = false;
        if (ServerUtilitiesConfig.world.isItemRightClickDisabled(player.func_70694_bm())) {
            cancelled = true;
            if (!event.world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "Item is disabled!"));
            }
        }
        MovingObjectPosition lookPos = MathUtils.rayTrace(player, true);
        if (!cancelled && lookPos != null) {
            switch (event.action) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case RIGHT_CLICK_AIR: {
                    boolean bl = ClaimedChunks.blockItemUse(player, lookPos.field_72311_b, lookPos.field_72312_c, lookPos.field_72309_d);
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    boolean bl = ClaimedChunks.blockBlockInteractions(player, lookPos.field_72311_b, lookPos.field_72312_c, lookPos.field_72309_d, 0);
                    break;
                }
                case LEFT_CLICK_BLOCK: {
                    boolean bl = cancelled = ClaimedChunks.blockBlockEditing(player, lookPos.field_72311_b, lookPos.field_72312_c, lookPos.field_72309_d, 0);
                }
            }
        }
        if (cancelled) {
            event.setCanceled(true);
            InvUtils.forceUpdate(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.getPlayer(), event.x, event.y, event.z, 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.player, event.x, event.y, event.z, 0)) {
            InvUtils.forceUpdate(event.player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onNameFormat(PlayerEvent.NameFormat event) {
        ServerUtilitiesPlayerData data;
        ForgePlayer p;
        if (ServerUtilitiesConfig.commands.nick && Universe.loaded() && event.entityPlayer instanceof EntityPlayerMP && (p = Universe.get().getPlayer(event.entityPlayer.func_146103_bH())) != null && !(data = ServerUtilitiesPlayerData.get(p)).getNickname().isEmpty() && PermissionAPI.hasPermission(event.entityPlayer, "serverutilities.chat.nickname.set")) {
            String name = StringUtils.addFormatting(data.getNickname());
            if (!p.hasPermission("serverutilities.chat.nickname.colors")) {
                name = StringUtils.unformatted(name);
            } else if (name.indexOf(167) != -1) {
                name = name + EnumChatFormatting.RESET;
            }
            if (ServerUtilitiesConfig.chat.add_nickname_tilde) {
                name = "~" + name;
            }
            event.displayname = name;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer entityPlayer;
        if (event.player.field_70173_aa % 5 == 2 && (entityPlayer = event.player) instanceof EntityPlayerMP) {
            byte newOpState;
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            byte opState = player.getEntityData().func_74771_c("ServerLibOP");
            byte by = newOpState = ServerUtils.isOP(player) ? (byte)2 : 1;
            if (opState != newOpState) {
                player.getEntityData().func_74774_a("ServerLibOP", newOpState);
                Universe.get().clearCache();
                ForgePlayer forgePlayer = Universe.get().getPlayer(player.func_146103_bH());
                if (forgePlayer != null) {
                    new MessageSyncData(false, player, forgePlayer).sendTo(player);
                }
            }
        }
    }

    private static String getStateName(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block block = world.func_147439_a(x, y, z);
        return block.func_149732_F() + ":" + meta;
    }

    private static String getDim(EntityPlayer player) {
        return ServerUtils.getDimensionName(player.field_71093_bK).func_150260_c();
    }

    private static String getPos(int x, int y, int z) {
        return String.format("[%d, %d, %d]", x, y, z);
    }

    private static String getHeldItemName(EntityPlayer player) {
        ItemStack stack = player.func_70694_bm();
        return stack == null ? "Empty Hand" : stack.func_82833_r();
    }

    @SubscribeEvent
    public void onBlockBreakLog(BlockEvent.BreakEvent event) {
        EntityPlayer entityPlayer = event.getPlayer();
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        if (ServerUtilitiesConfig.world.logging.block_broken && ServerUtilitiesConfig.world.logging.log(playerMP)) {
            ServerUtilitiesUniverseData.worldLog(String.format("%s broke %s at %s in %s", playerMP.func_70005_c_(), ServerUtilitiesPlayerEventHandler.getStateName(event.world, event.x, event.y, event.z), ServerUtilitiesPlayerEventHandler.getPos(event.x, event.y, event.z), ServerUtilitiesPlayerEventHandler.getDim((EntityPlayer)playerMP)));
        }
    }

    @SubscribeEvent
    public void onBlockPlaceLog(BlockEvent.PlaceEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        if (ServerUtilitiesConfig.world.logging.block_placed && ServerUtilitiesConfig.world.logging.log(playerMP)) {
            ServerUtilitiesUniverseData.worldLog(String.format("%s placed %s at %s in %s", playerMP.func_70005_c_(), ServerUtilitiesPlayerEventHandler.getStateName(event.world, event.x, event.y, event.z), ServerUtilitiesPlayerEventHandler.getPos(event.x, event.y, event.z), ServerUtilitiesPlayerEventHandler.getDim((EntityPlayer)playerMP)));
        }
    }

    @SubscribeEvent
    public void onRightClickItemLog(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            return;
        }
        EntityPlayer entityPlayer = event.entityPlayer;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        if (ServerUtilitiesConfig.world.logging.item_clicked_in_air && ServerUtilitiesConfig.world.logging.log(playerMP)) {
            ServerUtilitiesUniverseData.worldLog(String.format("%s clicked %s in air at %s in %s", playerMP.func_70005_c_(), ServerUtilitiesPlayerEventHandler.getHeldItemName((EntityPlayer)playerMP), ServerUtilitiesPlayerEventHandler.getPos(event.x, event.y, event.z), ServerUtilitiesPlayerEventHandler.getDim((EntityPlayer)playerMP)));
        }
    }

    @SubscribeEvent
    public void onEntityAttackedLog(AttackEntityEvent event) {
        EntityPlayer entityPlayer = event.entityPlayer;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        Entity target = event.target;
        if (ServerUtilitiesConfig.world.logging.entity_attacked && ServerUtilitiesConfig.world.logging.log(playerMP)) {
            boolean print;
            boolean bl = print = !ServerUtilitiesConfig.world.logging.exclude_mob_entity || !(target instanceof EntityCreature);
            if (print) {
                ServerUtilitiesUniverseData.worldLog(String.format("%s attacked %s with %s at %s in %s", playerMP.func_70005_c_(), target.func_70005_c_(), ServerUtilitiesPlayerEventHandler.getHeldItemName((EntityPlayer)playerMP), ServerUtilitiesPlayerEventHandler.getPos((int)playerMP.field_70165_t, (int)playerMP.field_70163_u, (int)playerMP.field_70161_v), ServerUtilitiesPlayerEventHandler.getDim((EntityPlayer)playerMP)));
            }
        }
    }
}

