/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import net.minecraft.command.ICommandSender;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.backups.Backups;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CmdTreeBase;
import serverutils.lib.util.FileUtils;

public class CmdBackup
extends CmdTreeBase {
    public CmdBackup() {
        super("backup");
        this.addSubcommand(new CmdBackupStart("start"));
        this.addSubcommand(new CmdBackupStop("stop"));
        this.addSubcommand(new CmdBackupGetSize("getsize"));
    }

    public static class CmdBackupStart
    extends CmdBase {
        public CmdBackupStart(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            boolean b = Backups.run(sender, args.length == 0 ? "" : args[0]);
            if (b) {
                sender.func_145747_a(ServerUtilities.lang(null, "cmd.backup_manual_launch", sender.func_70005_c_()));
                if (!ServerUtilitiesConfig.backups.use_separate_thread) {
                    Backups.postBackup();
                }
            } else {
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_already_running", new Object[0]));
            }
        }
    }

    public static class CmdBackupStop
    extends CmdBase {
        public CmdBackupStop(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            if (Backups.thread != null) {
                Backups.thread.interrupt();
                Backups.thread = null;
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_stop", new Object[0]));
            } else {
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_not_running", new Object[0]));
            }
        }
    }

    public static class CmdBackupGetSize
    extends CmdBase {
        public CmdBackupGetSize(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            String sizeW = FileUtils.getSizeString(sender.func_130014_f_().func_72860_G().func_75765_b());
            String sizeT = FileUtils.getSizeString(Backups.backupsFolder);
            sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_not_running", sizeW, sizeT));
        }
    }
}

