/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tileentity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.arc.bloodarsenal.common.tileentity.PacketHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TilePortableAltar
extends TileEntity
implements IInventory,
IFluidTank,
IFluidHandler,
IBloodAltar {
    public static final int sizeInv = 1;
    private ItemStack[] inv = new ItemStack[1];
    private int resultID = 0;
    private int resultDamage = 0;
    private int upgradeLevel = 0;
    public FluidStack fluid = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public int capacity = 10000;
    private boolean isActive = false;
    public int liquidRequired;
    private boolean canBeFilled;
    public int consumptionRate = 0;
    private int drainRate = 0;
    public float consumptionMultiplier = 0.0f;
    private float efficiencyMultiplier = 0.0f;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private boolean isUpgraded = false;
    private boolean isResultBlock = false;
    private int bufferCapacity = 1000;
    public FluidStack fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public FluidStack fluidInput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public int progress = 0;
    private int cooldownAfterCrafting = 500;
    public int speedUpgrades = 0;
    public int efficiencyUpgrades = 0;
    public int sacrificeUpgrades = 0;
    public int selfSacrificeUpgrades = 0;
    public int displacementUpgrades = 0;
    public int altarCapacitiveUpgrades = 0;
    public int orbCapacitiveUpgrades = 0;
    public int betterCapacitiveUpgrades = 0;
    public int accelerationUpgrades = 0;
    private int lockdownDuration = 0;
    private int demonBloodDuration = 0;

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.amount, amount);
        this.fluid.amount += filledAmount;
        return filledAmount;
    }

    public int getRSPowerOutput() {
        return 5;
    }

    public void addToDemonBloodDuration(int dur) {
        ++this.demonBloodDuration;
    }

    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    public void readNBTOnPlace(NBTTagCompound tag) {
        this.fluid.amount = tag.func_74762_e("currentEssence");
        this.upgradeLevel = tag.func_74762_e("upgradeLevel");
        this.isActive = tag.func_74767_n("isActive");
        this.liquidRequired = tag.func_74762_e("liquidRequired");
        this.canBeFilled = tag.func_74767_n("canBeFilled");
        this.isUpgraded = tag.func_74767_n("isUpgraded");
        this.consumptionRate = tag.func_74762_e("consumptionRate");
        this.drainRate = tag.func_74762_e("drainRate");
        this.consumptionMultiplier = tag.func_74760_g("consumptionMultiplier");
        this.efficiencyMultiplier = tag.func_74760_g("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = tag.func_74760_g("selfSacrificeEfficiencyMultiplier");
        this.sacrificeEfficiencyMultiplier = tag.func_74760_g("sacrificeEfficiencyMultiplier");
        this.capacityMultiplier = tag.func_74760_g("capacityMultiplier");
        this.orbCapacityMultiplier = tag.func_74760_g("orbCapacityMultiplier");
        this.dislocationMultiplier = tag.func_74760_g("dislocationMultiplier");
        this.capacity = tag.func_74762_e("capacity");
        this.bufferCapacity = tag.func_74762_e("bufferCapacity");
        this.progress = tag.func_74762_e("progress");
        this.isResultBlock = tag.func_74767_n("isResultBlock");
        this.lockdownDuration = tag.func_74762_e("lockdownDuration");
        this.accelerationUpgrades = tag.func_74762_e("accelerationUpgrades");
        this.demonBloodDuration = tag.func_74762_e("demonBloodDuration");
        this.cooldownAfterCrafting = tag.func_74762_e("cooldownAfterCrafting");
    }

    public void writeNBTOnHarvest(NBTTagCompound tag) {
        tag.func_74768_a("currentEssence", this.fluid.amount);
        tag.func_74768_a("upgradeLevel", this.upgradeLevel);
        tag.func_74757_a("isActive", this.isActive);
        tag.func_74768_a("liquidRequired", this.liquidRequired);
        tag.func_74757_a("canBeFilled", this.canBeFilled);
        tag.func_74757_a("isUpgraded", this.isUpgraded);
        tag.func_74768_a("consumptionRate", this.consumptionRate);
        tag.func_74768_a("drainRate", this.drainRate);
        tag.func_74776_a("consumptionMultiplier", this.consumptionMultiplier);
        tag.func_74776_a("efficiencyMultiplier", this.efficiencyMultiplier);
        tag.func_74776_a("sacrificeEfficiencyMultiplier", this.sacrificeEfficiencyMultiplier);
        tag.func_74776_a("selfSacrificeEfficiencyMultiplier", this.selfSacrificeEfficiencyMultiplier);
        tag.func_74757_a("isResultBlock", this.isResultBlock);
        tag.func_74776_a("capacityMultiplier", this.capacityMultiplier);
        tag.func_74776_a("orbCapacityMultiplier", this.orbCapacityMultiplier);
        tag.func_74776_a("dislocationMultiplier", this.dislocationMultiplier);
        tag.func_74768_a("capacity", this.capacity);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("bufferCapacity", this.bufferCapacity);
        tag.func_74768_a("lockdownDuration", this.lockdownDuration);
        tag.func_74768_a("accelerationUpgrades", this.accelerationUpgrades);
        tag.func_74768_a("demonBloodDuration", this.demonBloodDuration);
        tag.func_74768_a("cooldownAfterCrafting", this.cooldownAfterCrafting);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.resultID = par1NBTTagCompound.func_74762_e("resultID");
        this.resultDamage = par1NBTTagCompound.func_74762_e("resultDamage");
        if (!par1NBTTagCompound.func_74764_b("Empty")) {
            FluidStack fluidIn;
            FluidStack fluidOut;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)par1NBTTagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            if ((fluidOut = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("outputAmount"))) != null) {
                this.setOutputFluid(fluidOut);
            }
            if ((fluidIn = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("inputAmount"))) != null) {
                this.setInputFluid(fluidIn);
            }
        }
        this.fluid.amount = par1NBTTagCompound.func_74762_e("currentEssence");
        this.upgradeLevel = par1NBTTagCompound.func_74762_e("upgradeLevel");
        this.isActive = par1NBTTagCompound.func_74767_n("isActive");
        this.liquidRequired = par1NBTTagCompound.func_74762_e("liquidRequired");
        this.canBeFilled = par1NBTTagCompound.func_74767_n("canBeFilled");
        this.isUpgraded = par1NBTTagCompound.func_74767_n("isUpgraded");
        this.consumptionRate = par1NBTTagCompound.func_74762_e("consumptionRate");
        this.drainRate = par1NBTTagCompound.func_74762_e("drainRate");
        this.consumptionMultiplier = par1NBTTagCompound.func_74760_g("consumptionMultiplier");
        this.efficiencyMultiplier = par1NBTTagCompound.func_74760_g("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = par1NBTTagCompound.func_74760_g("selfSacrificeEfficiencyMultiplier");
        this.sacrificeEfficiencyMultiplier = par1NBTTagCompound.func_74760_g("sacrificeEfficiencyMultiplier");
        this.capacityMultiplier = par1NBTTagCompound.func_74760_g("capacityMultiplier");
        this.orbCapacityMultiplier = par1NBTTagCompound.func_74760_g("orbCapacityMultiplier");
        this.dislocationMultiplier = par1NBTTagCompound.func_74760_g("dislocationMultiplier");
        this.capacity = par1NBTTagCompound.func_74762_e("capacity");
        this.bufferCapacity = par1NBTTagCompound.func_74762_e("bufferCapacity");
        this.progress = par1NBTTagCompound.func_74762_e("progress");
        this.isResultBlock = par1NBTTagCompound.func_74767_n("isResultBlock");
        this.lockdownDuration = par1NBTTagCompound.func_74762_e("lockdownDuration");
        this.accelerationUpgrades = par1NBTTagCompound.func_74762_e("accelerationUpgrades");
        this.demonBloodDuration = par1NBTTagCompound.func_74762_e("demonBloodDuration");
        this.cooldownAfterCrafting = par1NBTTagCompound.func_74762_e("cooldownAfterCrafting");
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74768_a("resultID", this.resultID);
        par1NBTTagCompound.func_74768_a("resultDamage", this.resultDamage);
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        if (this.fluid != null) {
            this.fluid.writeToNBT(par1NBTTagCompound);
        } else {
            par1NBTTagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidOutput != null) {
            par1NBTTagCompound.func_74768_a("outputAmount", this.fluidOutput.amount);
        }
        if (this.fluidInput != null) {
            par1NBTTagCompound.func_74768_a("inputAmount", this.fluidInput.amount);
        }
        par1NBTTagCompound.func_74768_a("currentEssence", this.fluid.amount);
        par1NBTTagCompound.func_74768_a("upgradeLevel", this.upgradeLevel);
        par1NBTTagCompound.func_74757_a("isActive", this.isActive);
        par1NBTTagCompound.func_74768_a("liquidRequired", this.liquidRequired);
        par1NBTTagCompound.func_74757_a("canBeFilled", this.canBeFilled);
        par1NBTTagCompound.func_74757_a("isUpgraded", this.isUpgraded);
        par1NBTTagCompound.func_74768_a("consumptionRate", this.consumptionRate);
        par1NBTTagCompound.func_74768_a("drainRate", this.drainRate);
        par1NBTTagCompound.func_74776_a("consumptionMultiplier", this.consumptionMultiplier);
        par1NBTTagCompound.func_74776_a("efficiencyMultiplier", this.efficiencyMultiplier);
        par1NBTTagCompound.func_74776_a("sacrificeEfficiencyMultiplier", this.sacrificeEfficiencyMultiplier);
        par1NBTTagCompound.func_74776_a("selfSacrificeEfficiencyMultiplier", this.selfSacrificeEfficiencyMultiplier);
        par1NBTTagCompound.func_74757_a("isResultBlock", this.isResultBlock);
        par1NBTTagCompound.func_74776_a("capacityMultiplier", this.capacityMultiplier);
        par1NBTTagCompound.func_74776_a("orbCapacityMultiplier", this.orbCapacityMultiplier);
        par1NBTTagCompound.func_74776_a("dislocationMultiplier", this.dislocationMultiplier);
        par1NBTTagCompound.func_74768_a("capacity", this.capacity);
        par1NBTTagCompound.func_74768_a("progress", this.progress);
        par1NBTTagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
        par1NBTTagCompound.func_74768_a("lockdownDuration", this.lockdownDuration);
        par1NBTTagCompound.func_74768_a("accelerationUpgrades", this.accelerationUpgrades);
        par1NBTTagCompound.func_74768_a("demonBloodDuration", this.demonBloodDuration);
        par1NBTTagCompound.func_74768_a("cooldownAfterCrafting", this.cooldownAfterCrafting);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inv[slot] = itemStack;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "TilePortableAltar";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    public void setCurrentBlood(int amount) {
        this.fluid.amount = amount;
    }

    public int getTier() {
        return this.upgradeLevel;
    }

    public void setTier(int tier) {
        this.upgradeLevel = tier;
    }

    public int getProgress() {
        return this.progress;
    }

    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    public void setSacrificeMultiplier(float sacrificeMultiplier) {
        this.sacrificeEfficiencyMultiplier = sacrificeMultiplier;
    }

    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    public void setSelfSacrificeMultiplier(float selfSacrificeMultiplier) {
        this.selfSacrificeEfficiencyMultiplier = selfSacrificeMultiplier;
    }

    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    public void setOrbMultiplier(float orbMultiplier) {
        this.orbCapacityMultiplier = orbMultiplier;
    }

    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    public void setDislocationMultiplier(float dislocationMultiplier) {
        this.dislocationMultiplier = dislocationMultiplier;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public void setConsumptionMultiplier(float consumptionMultiplier) {
        this.consumptionMultiplier = consumptionMultiplier;
    }

    public void setEfficiencyMultiplier(float efficiencyMultiplier) {
        this.efficiencyMultiplier = efficiencyMultiplier;
    }

    public void setCapacityMultiplier(float capacityMultiplier) {
        this.capacityMultiplier = capacityMultiplier;
    }

    public void setUpgrades(int speedUpgrades, int efficiencyUpgrades, int sacrificeUpgrades, int selfSacrificeUpgrades, int displacementUpgrades, int altarCapacitiveUpgrades, int orbCapacitiveUpgrades, int betterCapacitiveUpgrades, int accelerationUpgrades) {
        this.speedUpgrades = speedUpgrades;
        this.efficiencyUpgrades = efficiencyUpgrades;
        this.sacrificeUpgrades = sacrificeUpgrades;
        this.selfSacrificeUpgrades = selfSacrificeUpgrades;
        this.displacementUpgrades = displacementUpgrades;
        this.altarCapacitiveUpgrades = altarCapacitiveUpgrades;
        this.orbCapacitiveUpgrades = orbCapacitiveUpgrades;
        this.betterCapacitiveUpgrades = betterCapacitiveUpgrades;
        this.accelerationUpgrades = accelerationUpgrades;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        TilePortableAltar tile = this;
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid().getID() != new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 1).getFluid().getID()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null) {
                return Math.min(this.bufferCapacity, resource.amount);
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.amount, resource.amount);
        }
        if (this.fluidInput == null) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.amount));
            if (tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this, this.fluidInput.amount));
            }
            return this.fluidInput.amount;
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.amount;
        if (resource.amount < filled) {
            this.fluidInput.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluidInput.amount = this.bufferCapacity;
        }
        if (tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this, this.fluidInput.amount));
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluidOutput.amount < drained) {
            drained = this.fluidOutput.amount;
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.amount -= drained;
            if (this.fluidOutput.amount <= 0) {
                this.fluidOutput = null;
            }
            if (this != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluidOutput, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, this.fluidOutput.amount));
            }
        }
        if (this.fluidOutput == null) {
            this.fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public void func_145845_h() {
        this.decrementDemonBlood();
        if (this.hasDemonBlood() && !this.field_145850_b.field_72995_K) {
            SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 20L == 0L) {
            PotionEffect regenEffect;
            List list;
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, block);
            if (AlchemicalWizardry.lockdownAltar) {
                list = SpellHelper.getPlayersInRange((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)15.0, (double)15.0);
                for (EntityPlayer player : list) {
                    regenEffect = player.func_70660_b(Potion.field_76428_l);
                    if (regenEffect == null || regenEffect.func_76458_c() < 2) continue;
                    this.lockdownDuration += 20;
                }
            }
            if (AlchemicalWizardry.causeHungerWithRegen) {
                list = SpellHelper.getPlayersInRange((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)15.0, (double)15.0);
                for (EntityPlayer player : list) {
                    regenEffect = player.func_70660_b(Potion.field_76428_l);
                    if (regenEffect == null || regenEffect.func_76458_c() <= 0) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 40, regenEffect.func_76458_c() * 2 - 2));
                }
            }
        }
        if (this.field_145850_b.func_72820_D() % (long)Math.max(20 - this.accelerationUpgrades, 1) == 0L) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = Math.min(syphonMax, -this.fluid.amount + this.capacity);
            fluidInputted = Math.min(this.fluidInput.amount, fluidInputted);
            this.fluid.amount += fluidInputted;
            this.fluidInput.amount -= fluidInputted;
            int fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.amount);
            fluidOutputted = Math.min(this.fluid.amount, fluidOutputted);
            this.fluidOutput.amount += fluidOutputted;
            this.fluid.amount -= fluidOutputted;
        }
        if (this.field_145850_b.func_72820_D() % 100L == 0L && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
            }
            return;
        }
        if (this.func_70301_a(0) == null) {
            return;
        }
        int worldTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (worldTime % 1 == 0) {
            if (!this.canBeFilled) {
                if (this.fluid != null && this.fluid.amount >= 1) {
                    int stackSize = this.func_70301_a((int)0).field_77994_a;
                    int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                    if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                        liquidDrained = this.liquidRequired * stackSize - this.progress;
                    }
                    this.fluid.amount -= liquidDrained;
                    this.progress += liquidDrained;
                    if (worldTime % 4 == 0) {
                        SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                    }
                    if (this.progress >= this.liquidRequired * stackSize) {
                        ItemStack result = AltarRecipeRegistry.getItemForItemAndTier((ItemStack)this.func_70301_a(0), (int)this.upgradeLevel);
                        if (result != null) {
                            result.field_77994_a *= stackSize;
                        }
                        this.func_70299_a(0, result);
                        this.progress = 0;
                        for (int i = 0; i < 8; ++i) {
                            SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)4, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f));
                        }
                        this.isActive = false;
                    }
                } else if (this.progress > 0) {
                    this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                    if (worldTime % 2 == 0) {
                        SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)2, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                    }
                }
            } else {
                ItemStack returnedItem = this.func_70301_a(0);
                if (!(returnedItem.func_77973_b() instanceof IBloodOrb)) {
                    return;
                }
                IBloodOrb item = (IBloodOrb)returnedItem.func_77973_b();
                NBTTagCompound itemTag = returnedItem.field_77990_d;
                if (itemTag == null) {
                    return;
                }
                String ownerName = itemTag.func_74779_i("ownerName");
                if (ownerName.equals("")) {
                    return;
                }
                if (this.fluid != null && this.fluid.amount >= 1) {
                    int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                    int drain = SoulNetworkHandler.addCurrentEssenceToMaximum((String)ownerName, (int)liquidDrained, (int)((int)((float)item.getMaxEssence() * this.orbCapacityMultiplier)));
                    this.fluid.amount -= drain;
                    if (worldTime % 4 == 0) {
                        SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)3, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                    }
                }
            }
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (!isSacrifice && this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.amount += amt;
        } else {
            this.fluid.amount = (int)((float)this.fluid.amount + Math.min((float)(this.capacity - this.fluid.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount));
        }
    }

    public Packet func_145844_m() {
        return PacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData, int[] fluidData, int capacity) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
        FluidStack flMain = new FluidStack(fluidData[0], fluidData[1]);
        FluidStack flIn = new FluidStack(fluidData[2], fluidData[3]);
        FluidStack flOut = new FluidStack(fluidData[4], fluidData[5]);
        this.setMainFluid(flMain);
        this.setInputFluid(flIn);
        this.setOutputFluid(flOut);
        this.capacity = capacity;
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public void startCycle() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.checkAndSetAltar();
        if (this.fluid == null || this.fluid.amount <= 0) {
            return;
        }
        if (this.func_70301_a(0) == null) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (AltarRecipeRegistry.isRequiredItemValid((ItemStack)this.func_70301_a(0), (int)this.upgradeLevel)) {
            AltarRecipe recipe = AltarRecipeRegistry.getAltarRecipeForItemAndTier((ItemStack)this.func_70301_a(0), (int)this.upgradeLevel);
            this.isActive = true;
            this.liquidRequired = recipe.getLiquidRequired();
            this.canBeFilled = recipe.getCanBeFilled();
            this.consumptionRate = recipe.getConsumptionRate();
            this.drainRate = recipe.drainRate;
            return;
        }
        this.isActive = false;
    }

    public void checkAndSetAltar() {
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        if (this.fluidOutput.amount > this.bufferCapacity) {
            this.fluidOutput.amount = this.bufferCapacity;
        }
        if (this.fluidInput.amount > this.bufferCapacity) {
            this.fluidInput.amount = this.bufferCapacity;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        int used = this.fill(resource, doFill);
        resource.amount -= used;
        this.startCycle();
        return totalUsed += used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.fluidOutput)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(maxEmpty, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidInput != null && this.fluid.getFluid().equals(this.fluidInput.getFluid());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank compositeTank = new FluidTank(this.capacity);
        compositeTank.setFluid(this.fluid);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public int[] buildFluidList() {
        int[] sortList = new int[6];
        if (this.fluid == null) {
            sortList[0] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[1] = 0;
        } else {
            sortList[0] = this.fluid.getFluid().getID();
            sortList[1] = this.fluid.amount;
        }
        if (this.fluidInput == null) {
            sortList[2] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[3] = 0;
        } else {
            sortList[2] = this.fluidInput.getFluid().getID();
            sortList[3] = this.fluidInput.amount;
        }
        if (this.fluidOutput == null) {
            sortList[4] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[5] = 0;
        } else {
            sortList[4] = this.fluidOutput.getFluid().getID();
            sortList[5] = this.fluidOutput.amount;
        }
        return sortList;
    }

    public void sendChatInfoToPlayer(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altarEssence") + " " + this.fluid.amount + "LP"));
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altarCurrentTier") + " " + this.upgradeLevel));
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.capacity") + " " + this.getCapacity() + "LP"));
    }

    public void sendMoreChatInfoToPlayer(EntityPlayer player) {
        if (this.func_70301_a(0) != null) {
            int stackSize = this.func_70301_a((int)0).field_77994_a;
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altarProgress") + " " + this.progress + "LP/" + this.liquidRequired * stackSize + "LP"));
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.consumptionRate") + " " + (int)((float)this.consumptionRate * (1.0f + this.consumptionMultiplier)) + "LP/t"));
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.altarEssence") + " " + this.fluid.amount + "LP"));
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.inputTank") + " " + this.fluidInput.amount + "LP"));
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.outputTank") + " " + this.fluidOutput.amount + "LP"));
    }

    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }
}

