/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.init;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.BackpackUtils;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.ChestGenHooks;

public class ModWorldGen {
    public static void init() {
        ItemStack backpack = BackpackUtils.createBackpackStack(BackpackTypes.VILLAGER);
        VillagerRegistry.instance().registerVillageTradeHandler(1, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
        VillagerRegistry.instance().registerVillageTradeHandler(2, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
        VillagerRegistry.instance().registerVillageTradeHandler(3, (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
        if (ConfigHandler.allowGolemGen) {
            backpack = BackpackUtils.createBackpackStack(BackpackTypes.IRON_GOLEM);
            ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 2));
        }
        if (ConfigHandler.allowBatGen) {
            backpack = BackpackUtils.createBackpackStack(BackpackTypes.BAT);
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 2));
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 12));
        }
        if (ConfigHandler.allowPigmanGen) {
            backpack = BackpackUtils.createBackpackStack(BackpackTypes.PIGMAN);
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 1, 1, 12));
            VillagerRegistry.instance().registerVillageTradeHandler((int)BackpackTypes.getMeta(BackpackTypes.PIGMAN), (VillagerRegistry.IVillageTradeHandler)new TradeHandler(backpack));
        }
        if (ConfigHandler.allowBonusGen) {
            backpack = BackpackUtils.createBackpackStack(BackpackTypes.STANDARD);
            ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(backpack, 0, 1, 5));
        }
    }

    public static class TradeHandler
    implements VillagerRegistry.IVillageTradeHandler {
        ItemStack backpack;

        TradeHandler(ItemStack backpack) {
            this.backpack = backpack;
        }

        public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
            ItemStack payment;
            if (villager.func_70946_n() == 1 || villager.func_70946_n() == 2) {
                payment = BackpackUtils.createBackpackStack(BackpackTypes.STANDARD);
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 10), payment, this.backpack));
            }
            if (villager.func_70946_n() == 3) {
                payment = BackpackUtils.createBackpackStack(BackpackTypes.IRON_GOLEM);
                recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 10), payment, this.backpack));
            }
        }
    }
}

