/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.helper.GuiHelper;
import de.katzenpapst.amunra.inventory.ContainerRocketEngine;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineAbstract;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiRocketEngine
extends GuiContainerGC {
    protected final ResourceLocation guiTexture;
    protected final TileEntityMothershipEngineAbstract tileEngine;
    protected GuiButton buttonEnable;
    protected GuiElementInfoRegion tankInfo;
    protected boolean isEngineObstructed;

    public GuiRocketEngine(Container container, TileEntityMothershipEngineAbstract tileEngine, ResourceLocation texture) {
        super(container);
        this.tileEngine = tileEngine;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
        if (tileEngine == null) {
            throw new RuntimeException("TileEntity of engine is null");
        }
        this.isEngineObstructed = tileEngine.isObstructed();
        this.guiTexture = texture;
    }

    public GuiRocketEngine(InventoryPlayer player, TileEntityMothershipEngineAbstract tileEngine) {
        this(new ContainerRocketEngine(player, tileEngine), tileEngine, new ResourceLocation("amunra", "textures/gui/ms_rocket.png"));
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.tileEngine.field_145851_c, this.tileEngine.field_145848_d, this.tileEngine.field_145849_e, 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        fuelTankDesc.add("");
        this.tankInfo = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 27, 18, 76, fuelTankDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.infoRegions.add(this.tankInfo);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offsetY = 35;
        this.buttonEnable.field_146126_j = !this.tileEngine.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        String displayString = this.tileEngine.func_145825_b();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.mothership.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, 32, 9 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.mothership.numEngineParts") + ": " + this.tileEngine.getNumBoosters();
        this.field_146289_q.func_78276_b(displayString, 32, 9 + (offsetY += 10), 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.mothership.travelThrust") + ": " + GuiHelper.formatMetric(this.tileEngine.getThrust(), "N");
        this.field_146289_q.func_78276_b(displayString, 32, 9 + (offsetY += 10), 0x404040);
        offsetY += 10;
        this.tankInfo.tooltipStrings.clear();
        displayString = GCCoreUtil.translate((String)"gui.message.mothership.fuel") + ": " + GuiHelper.formatMetric((float)this.tileEngine.fuelTank.getFluidAmount() / 1000.0f, "B") + "/" + GuiHelper.formatMetric((float)this.tileEngine.fuelTank.getCapacity() / 1000.0f, "B");
        this.tankInfo.tooltipStrings.add(displayString);
    }

    private String getStatus() {
        if (this.tileEngine.isInUse()) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.message.mothership.status.active");
        }
        if (this.tileEngine.getDisabled(0)) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.isEngineObstructed) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.message.mothership.status.obstructed");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.message.mothership.status.idle");
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        int fuelLevel = this.tileEngine.getScaledFuelLevel(74);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2 + 8, (this.field_146295_m - this.field_147000_g) / 2 + 28 + 74 - fuelLevel, 176, 74 - fuelLevel, 16, fuelLevel);
        int jetX = 32;
        int jetY = 28;
        this.func_73729_b(xPos + 32, yPos + 28, 192, 0, 22, 11);
        if (this.tileEngine.isInUse()) {
            this.func_73729_b(xPos + 32 + 22, yPos + 28, 214, 0, 12, 11);
        } else if (this.tileEngine.getDisabled(0)) {
            this.func_73729_b(xPos + 32 + 1, yPos + 28 - 1, 192, 11, 13, 13);
        } else if (this.isEngineObstructed) {
            this.func_73729_b(xPos + 32 + 22, yPos + 28 - 2, 192, 24, 15, 15);
        }
    }
}

