/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.crafting;

import alkalus.main.core.WitcheryExtras;
import alkalus.main.core.util.Utils;
import com.emoniph.witchery.Witchery;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class OvenRecipes {
    private static final ArrayList<OvenRecipe> mRecipeMap = new ArrayList();

    public static ArrayList<OvenRecipe> getRecipeMap() {
        return mRecipeMap;
    }

    public static void generateDefaultOvenRecipes() {
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 0, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemExhaleOfTheHornedOne.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 1, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 2, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 3, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemFoulFume.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 4, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Blocks.field_150345_g, 5, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Witchery.Blocks.SAPLING, 0, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Witchery.Blocks.SAPLING, 1, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemReekOfMisfortune.createStack(1));
        OvenRecipes.addRecipe(Utils.simpleMetaStack(Witchery.Blocks.SAPLING, 2, 1), 1, Witchery.Items.GENERIC.itemAshWood.createStack(1), Witchery.Items.GENERIC.itemOdourOfPurity.createStack(1));
        OvenRecipes.addRecipe("logWood", 1, Witchery.Items.GENERIC.itemFoulFume.createStack(1));
        OvenRecipes.addRecipe("meatRaw", 1, Witchery.Items.GENERIC.itemFoulFume.createStack(1));
    }

    private static ItemStack createStack(int stackSize) {
        return new ItemStack((Item)Witchery.Items.GENERIC, stackSize, 27);
    }

    public static ItemStack getEmptyJar(int amount) {
        return OvenRecipes.createStack(amount);
    }

    public static ItemStack getWitcheryItemByID(int id, int stackSize) {
        return new ItemStack((Item)Witchery.Items.GENERIC, stackSize, id);
    }

    private OvenRecipes() {
    }

    public static OvenRecipe addRecipe(ItemStack input1, int jars, ItemStack jarOutput) {
        return OvenRecipes.addRecipe(input1, "", jars, null, 0, jarOutput, jars);
    }

    public static OvenRecipe addRecipe(ItemStack input1, int jars, ItemStack customOutput, ItemStack jarOutput) {
        return OvenRecipes.addRecipe(input1, "", jars, customOutput, customOutput.field_77994_a, jarOutput, jars);
    }

    public static OvenRecipe addRecipe(String input1, int jars, ItemStack jarOutput) {
        return OvenRecipes.addRecipe(null, input1, jars, null, 0, jarOutput, jars);
    }

    public static OvenRecipe addRecipe(ItemStack input1, int jars, ItemStack output0, int amt0, ItemStack output1, int amt1) {
        return OvenRecipes.addRecipe(input1, "", jars, output0, amt0, output1, amt1);
    }

    public static OvenRecipe addRecipe(ItemStack input1, String inputString1, int jars, ItemStack customOutput, int amt1, ItemStack outputJarStack, int amt2) {
        ItemStack mInputStack = null;
        String mInputString = null;
        int mJars = 0;
        if (input1 != null) {
            mInputStack = input1;
        } else if (inputString1 != null && !inputString1.equals("")) {
            mInputString = inputString1;
        } else {
            WitcheryExtras.log(0, "Failed adding a Oven recipe for: INVALID.");
            return null;
        }
        WitcheryExtras.log(0, "Trying to add an Oven Recipe for " + (mInputStack != null ? mInputStack.func_82833_r() : mInputString));
        mJars = jars;
        ItemStack mOutputStack = null;
        int mOutputAmount = 0;
        ItemStack mJarOutputStack = null;
        int mJarOutputAmount = 0;
        boolean[] y = new boolean[2];
        if (customOutput != null && amt1 > 0) {
            mOutputStack = customOutput;
            mOutputAmount = amt1;
            y[0] = true;
        } else {
            ItemStack[] w = Utils.getAllItemsFromOreDictEntry(inputString1);
            ItemStack s = null;
            if (w != null && w.length > 0) {
                for (int i = 0; i < w.length; ++i) {
                    ItemStack gh = FurnaceRecipes.func_77602_a().func_151395_a(w[i]);
                    if (gh == null) continue;
                    gh = gh.func_77946_l();
                    if (gh.field_77994_a > 64 || gh.field_77994_a <= 0) {
                        gh.field_77994_a = 1;
                    }
                    s = Utils.getSimpleStack(gh.func_77946_l(), gh.field_77994_a);
                    break;
                }
            } else {
                WitcheryExtras.log(0, "Found no entries in OreDict for " + inputString1);
            }
            if (s != null) {
                mOutputStack = s;
                mOutputAmount = s.field_77994_a;
                y[0] = true;
            } else {
                WitcheryExtras.log(0, "Set Y0 to False");
                y[0] = false;
            }
        }
        if (outputJarStack != null && amt2 > 0 && amt2 == jars) {
            mJarOutputStack = outputJarStack;
            mJarOutputAmount = amt2;
            y[1] = true;
        } else {
            y[1] = false;
            WitcheryExtras.log(0, "Set Y1 to False");
        }
        if (y[0] && y[1]) {
            OvenRecipe recipe = mInputStack != null ? new OvenRecipe(mInputStack.func_77946_l(), mJars, mOutputStack.func_77946_l(), mOutputAmount, mJarOutputStack.func_77946_l(), mJarOutputAmount) : new OvenRecipe(mInputString, mJars, mOutputStack.func_77946_l(), mOutputAmount, mJarOutputStack.func_77946_l(), mJarOutputAmount);
            mRecipeMap.add(recipe);
            WitcheryExtras.log(0, "Added an Oven Recipe" + recipe.getDescription());
            return recipe;
        }
        WitcheryExtras.log(0, "Failed when trying to add an Oven Recipe for " + (mInputStack != null ? mInputStack.func_82833_r() : mInputString));
        return null;
    }

    public static OvenRecipe getOvenResult(ItemStack input1, int jars) {
        for (OvenRecipe recipe : mRecipeMap) {
            if (!recipe.isInputMatch(input1, jars)) continue;
            return recipe;
        }
        return null;
    }

    public static OvenRecipe findRecipeFor(ItemStack result) {
        for (OvenRecipe recipe : mRecipeMap) {
            if (!recipe.resultsIn(result)) continue;
            return recipe;
        }
        return null;
    }

    public static OvenRecipe findRecipeUsing(ItemStack ingredient) {
        for (OvenRecipe recipe : mRecipeMap) {
            if (!recipe.uses(ingredient)) continue;
            return recipe;
        }
        return null;
    }

    public static class OvenRecipe {
        public final String validOreDictInput;
        public final ItemStack inputs;
        public final int jars;
        public final ItemStack output;
        public final ItemStack outputJar;
        public final int outputAmount1;
        public final int outputAmountJar;
        public final ArrayList<OvenOutputs> outputs = new ArrayList();

        private OvenRecipe(String oreDictSub, int jars, ItemStack output1, int amount1, ItemStack output2, int amount2) {
            this(null, oreDictSub, jars, output1, amount1, output2, amount2);
        }

        private OvenRecipe(ItemStack input1, int jars, ItemStack output1, int amount1, ItemStack output2, int amount2) {
            this(input1, "", jars, output1, amount1, output2, amount2);
        }

        private OvenRecipe(ItemStack input1, String oreDict, int jars, ItemStack output1, int amount1, ItemStack output2, int amount2) {
            this.inputs = input1;
            this.validOreDictInput = oreDict;
            this.jars = jars;
            this.output = output1;
            this.outputJar = output2;
            this.outputAmount1 = amount1;
            this.outputAmountJar = amount2;
            OvenOutputs a1 = new OvenOutputs(output1, amount1);
            OvenOutputs a2 = new OvenOutputs(output1, amount1);
            this.outputs.add(a1);
            this.outputs.add(a2);
        }

        private boolean isInputMatch(ItemStack intput1, int amt1) {
            return this.jars == 0 || OvenRecipe.isMatch(intput1, this.inputs) && amt1 >= this.jars || !this.validOreDictInput.equals("") && Utils.hasValidOreDictTag(this.validOreDictInput, intput1);
        }

        private boolean isMatch(ItemStack output1, int amt1, ItemStack output2, int amt2) {
            return this.jars == 0 || amt1 == this.outputAmount1 && amt2 == this.outputAmountJar && OvenRecipe.isMatch(output1, this.output) && OvenRecipe.isMatch(output2, this.outputJar);
        }

        public static boolean isMatch(ItemStack a, ItemStack b) {
            return a == null && b == null || a != null && b != null && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j());
        }

        public static boolean isMatch(ItemStack a, ItemStack b, String oreName) {
            return Utils.hasValidOreDictTag(oreName, a) && Utils.hasValidOreDictTag(oreName, b) || a == null && b == null || a != null && b != null && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j());
        }

        public int getJars() {
            return this.jars;
        }

        public ItemStack[] getOutputs() {
            ItemStack[] x = new ItemStack[2];
            OvenOutputs a1 = this.outputs.get(0);
            OvenOutputs a2 = this.outputs.get(1);
            x[0] = Utils.getSimpleStack(a1.stack, a1.amount);
            x[1] = Utils.getSimpleStack(a2.stack, a2.amount);
            return x;
        }

        public String getDescription() {
            String[] y = new String[]{"descriptor", "Input: " + (this.inputs != null ? this.inputs.func_82833_r() : "No Item") + " x" + (this.inputs != null ? this.inputs.field_77994_a : 0), "Jars Required: " + this.jars, "Output: " + (this.output != null ? this.output.func_82833_r() : "No Item") + " x" + (this.output != null ? this.output.field_77994_a : 0), "Jar Output: " + this.outputJar.func_82833_r() + " x" + this.jars, "OreDict: " + this.validOreDictInput};
            String z = "";
            for (String x : y) {
                WitcheryExtras.log(0, x);
            }
            for (String x : y) {
                z = z + "." + x;
            }
            return z;
        }

        public boolean resultsIn(ItemStack result) {
            for (ItemStack stack : this.getOutputs()) {
                if (stack == null || !stack.func_77969_a(result)) continue;
                return true;
            }
            return false;
        }

        public boolean uses(ItemStack ingredient) {
            if (this.inputs != null && this.inputs.func_77969_a(ingredient)) {
                return true;
            }
            return Witchery.Items.GENERIC.itemEmptyClayJar.isMatch(ingredient) && this.jars > 0;
        }

        public boolean isValid() {
            return this.inputs != null && this.output != null;
        }

        public static class OvenOutputs {
            public final ItemStack stack;
            public final int amount;

            public OvenOutputs(ItemStack stack, int amount) {
                this.stack = stack;
                this.amount = amount;
            }
        }
    }
}

