/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock.eigbuckets;

import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EIGFlowerBucket
extends EIGBucket {
    public static final IEIGBucketFactory factory = new Factory();
    private static final String NBT_IDENTIFIER = "FLOWER";
    private static final int REVISION_NUMBER = 0;

    private EIGFlowerBucket(ItemStack input) {
        super(input, 1, null);
    }

    private EIGFlowerBucket(NBTTagCompound nbt) {
        super(nbt);
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = super.save();
        nbt.func_74768_a("version", 0);
        return nbt;
    }

    @Override
    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    @Override
    public void addProgress(double multiplier, EIGDropTable tracker) {
        tracker.addDrop(this.seed, (double)this.seedCount * multiplier);
    }

    @Override
    public boolean revalidate(MTEExtremeIndustrialGreenhouse greenhouse) {
        return this.isValid();
    }

    public static class Factory
    implements IEIGBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EIGFlowerBucket.NBT_IDENTIFIER;
        }

        @Override
        public EIGBucket tryCreateBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
            Item item = input.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if (item != Items.field_151120_aE && block != Blocks.field_150434_aF && !(block instanceof BlockFlower)) {
                return null;
            }
            return new EIGFlowerBucket(input);
        }

        @Override
        public EIGBucket restore(NBTTagCompound nbt) {
            return new EIGFlowerBucket(nbt);
        }
    }
}

