/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders.item.items;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import kubatech.api.utils.ModUtils;
import kubatech.loaders.ItemLoader;
import kubatech.loaders.item.ItemProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.AchievementPage;

public class ItemTeaCollection
extends ItemProxy {
    protected static TeaPage teapage;
    protected static LinkedList<Achievement> achievements;
    protected Achievement achievement;
    private final String achievementname;
    private static final int[][] achievement_poses;

    public ItemTeaCollection(String unlocalizedName) {
        super("teacollection." + unlocalizedName, "tea/" + unlocalizedName);
        this.achievementname = "teacollection." + unlocalizedName;
    }

    boolean checkTeaOwner(ItemStack stack, UUID player) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null || !stack.field_77990_d.func_74764_b("TeaOwnerUUID")) {
            return true;
        }
        return stack.field_77990_d.func_74779_i("TeaOwnerUUID").equals(player.toString());
    }

    boolean checkTeaOwner(ItemStack stack, String player) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null || !stack.field_77990_d.func_74764_b("TeaOwner")) {
            return true;
        }
        return stack.field_77990_d.func_74779_i("TeaOwner").equals(player);
    }

    private boolean checkOrSetTeaOwner(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag == null || !stack.field_77990_d.func_74764_b("TeaOwnerUUID")) {
            stack.func_77983_a("TeaOwnerUUID", (NBTBase)new NBTTagString(player.getPersistentID().toString()));
            stack.func_77983_a("TeaOwner", (NBTBase)new NBTTagString(player.func_70005_c_()));
            return true;
        }
        if (stack.field_77990_d.func_74779_i("TeaOwnerUUID").equals(player.getPersistentID().toString())) {
            stack.func_77983_a("TeaOwner", (NBTBase)new NBTTagString(player.func_70005_c_()));
            return true;
        }
        return false;
    }

    @Override
    public void ItemInit(int index) {
        super.ItemInit(index);
        if (teapage == null) {
            teapage = new TeaPage();
            AchievementPage.registerAchievementPage((AchievementPage)teapage);
            achievements = ItemTeaCollection.teapage.getAchievementsOriginal();
        }
        this.achievement = new Achievement(this.achievementname, this.achievementname, achievement_poses[index][0], achievement_poses[index][1], new ItemStack((Item)ItemLoader.kubaitems, 1, index), null).func_75971_g();
        achievements.add(this.achievement);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer entity, List<String> tooltipList, boolean showDebugInfo) {
        if (!this.checkTeaOwner(stack, entity.func_70005_c_())) {
            tooltipList.add(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.BOLD + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"kubaitem.notyours"));
            return;
        }
        tooltipList.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"kubaitem.fromcollection"));
        tooltipList.add(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.BOLD + EnumChatFormatting.ITALIC + EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"kubaitem.teacollection"));
    }

    @Override
    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.drink;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer entity) {
        if (!this.checkTeaOwner(stack, entity.func_70005_c_())) {
            return stack;
        }
        entity.func_71008_a(stack, 32);
        return stack;
    }

    @Override
    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer entity) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return stack;
        }
        entity.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"kubaitem.teacollection.mmm")));
        entity.func_71029_a((StatBase)this.achievement);
        return stack;
    }

    @Override
    public int getMaxItemUseDuration() {
        return 32;
    }

    @Override
    public String getDisplayName(ItemStack stack) {
        if (!ModUtils.isClientSided || Minecraft.func_71410_x().field_71439_g == null) {
            return super.getDisplayName(stack);
        }
        if (this.checkTeaOwner(stack, Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            return super.getDisplayName(stack);
        }
        return EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + EnumChatFormatting.ITALIC + "???????";
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        this.checkOrSetTeaOwner(stack, (EntityPlayer)entity);
        NBTTagCompound tag = stack.field_77990_d;
        if (tag.func_74764_b("display")) {
            tag.func_82580_o("display");
        }
    }

    static {
        achievement_poses = new int[][]{{0, 0}, {2, 0}, {3, 1}, {4, 2}, {4, 4}, {3, 5}, {2, 6}, {0, 6}, {-1, 5}, {-2, 4}, {-2, 2}, {-1, 1}, {1, 3}};
    }

    private static class TeaPage
    extends AchievementPage {
        final LinkedList<Achievement> unlockedAchievements = new LinkedList();

        public TeaPage() {
            super("Tea", new Achievement[0]);
        }

        public List<Achievement> getAchievements() {
            if (!ModUtils.isClientSided) {
                return super.getAchievements();
            }
            if (new Throwable().getStackTrace()[1].getMethodName().equals("isAchievementInPages")) {
                return super.getAchievements();
            }
            this.unlockedAchievements.clear();
            for (Achievement achievement : achievements) {
                if (!Minecraft.func_71410_x().field_71439_g.func_146107_m().func_77443_a(achievement)) continue;
                this.unlockedAchievements.add(achievement);
            }
            return this.unlockedAchievements;
        }

        private LinkedList<Achievement> getAchievementsOriginal() {
            return (LinkedList)super.getAchievements();
        }
    }
}

