/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchNanite;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.metadata.PCBFactoryTierKey;
import gregtech.api.recipe.metadata.PCBFactoryUpgrade;
import gregtech.api.recipe.metadata.PCBFactoryUpgradeKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.blocks.BlockCasings8;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTEPCBFactory
extends MTEExtendedPowerMultiBlockBase<MTEPCBFactory>
implements ISurvivalConstructable,
INEIPreviewModifier {
    private static final String xOffsetText = "GT5U.MBTT.PCB.XOffset";
    private static final String zOffsetText = "GT5U.MBTT.PCB.ZOffset";
    private static final String tier1 = "tier1";
    private static final String tier2 = "tier2";
    private static final String tier3 = "tier3";
    private static final String bioUpgrade = "bioUpgrade";
    private static final String ocTier1Upgrade = "ocTier1Upgrade";
    private static final String ocTier2Upgrade = "ocTier2Upgrade";
    private float mRoughnessMultiplier = 1.0f;
    private int mTier = 1;
    private int mSetTier = 1;
    private int mUpgradesInstalled = 0;
    private int mMaxParallel = 0;
    private boolean mBioUpgrade = false;
    private boolean mBioRotate = false;
    private boolean mOCTier1 = false;
    private boolean mOCTier2 = false;
    private final int[] mBioOffsets = new int[]{-5, -1};
    private final int[] mOCTier1Offsets = new int[]{2, -11};
    private final int[] mOCTier2Offsets = new int[]{2, -11};
    private MTEHatchInput mCoolantInputHatch;
    private final ArrayList<MTEHatchNanite> naniteBuses = new ArrayList();
    private static final int mBioRotateBitMap = 64;
    private static final int mOCTier2BitMap = 32;
    private static final int mOCTier1BitMap = 16;
    private static final int mBioBitMap = 8;
    private static final int mTier3BitMap = 4;
    private static final int mTier2BitMap = 2;
    private static final int mTier1BitMap = 1;
    private static final int COOLANT_CONSUMED_PER_SEC = 10;
    private static final IStructureDefinition<MTEPCBFactory> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("tier1", StructureUtility.transpose((String[][])new String[][]{{"       ", "E     E", "E     E", "EEEEEEE", "E     E", "E     E", "       "}, {"EEEEEEE", "CAAAAAC", "CAAAAAC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "E     E"}, {"EAAAAAE", "C-----C", "C-----C", "C-----C", "C-----C", "C-----C", "ECCCCCE"}, {"EAAAAAE", "C-----C", "B-----B", "B-----B", "B-----B", "C-----C", "ECCCCCE"}, {"EAAAAAE", "C-----C", "B-FFF-B", "B-FFF-B", "B-FFF-B", "C-----C", "EPPPPPE"}, {"ECC~CCE", "CDDDDDC", "CDDDDDC", "CDDDDDC", "CDDDDDC", "CDDDDDC", "EPPPPPE"}})).addShape("tier2", StructureUtility.transpose((String[][])new String[][]{{"    ", "    ", "    ", "HGGH", "HGGH", "HGGH", "HGGH", "HGGH", "    ", "    ", "    "}, {"    ", "    ", "HGGH", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "HGGH", "    ", "    "}, {"    ", "HGGH", "GGGG", "G  G", "G  G", "G  G", "G  G", "G  G", "GGGG", "HGGH", "    "}, {"    ", "HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH", "    "}, {"HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH"}, {"HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH"}, {"HGGH", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "HGGH"}})).addShape("tier3", StructureUtility.transpose((String[][])new String[][]{{"       ", "       ", "       ", "       ", "   I   ", "   I   ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   I   ", "   I   ", "   I   ", "   I   ", "       ", "       ", "       "}, {"       ", "       ", "  KKK  ", "  KIK  ", "  K K  ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "  KIK  ", "       ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  KIK  ", "       ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  K K  ", "  KKK  ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  K K  ", "  KKK  ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", "  K K  ", "  K K  ", "  K K  ", "  K K  ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {" II~II ", "IIJJJII", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IIJJJII", " IIIII "}})).addShape("bioUpgrade", StructureUtility.transpose((String[][])new String[][]{{"            ", "            ", "   LLLLLL   ", "            ", "            "}, {"            ", "            ", "  L      L  ", "            ", "            "}, {"E   E  E   E", " LLL    LLL ", " LLL    LLL ", " LLL    LLL ", "E   E  E   E"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"ELLLE  ELLLE", "LLLLL  LLLLL", "LLLLL  LLLLL", "LLLLL  LLLLL", "ELLLE  ELLLE"}})).addShape("ocTier1Upgrade", StructureUtility.transpose((String[][])new String[][]{{"EKKKE", "K   K", "K   K", "K   K", "EKKKE"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " NNN ", " N N ", " NNN ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"EOOOE", "OKKKO", "OK KO", "OKKKO", "EOOOE"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"ENNNE", "NKKKN", "NK KN", "NKKKN", "ENNNE"}, {"EGGGE", "GGGGG", "GGMGG", "GGGGG", "EGGGE"}})).addShape("ocTier2Upgrade", StructureUtility.transpose((String[][])new String[][]{{"RGGGR", "G   G", "G   G", "G   G", "RGGGR"}, {"R   R", " GGG ", " GTG ", " GGG ", "R   R"}, {"R   R", " NNN ", " NTN ", " NNN ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"RNNNR", "NQQQN", "NQTQN", "NQQQN", "RNNNR"}, {"RGGGR", "GGGGG", "GGSGG", "GGGGG", "RGGGR"}})).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('C', StructureUtility.withChannel((String)"enableBioUpgrade", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == GregTechAPI.sBlockCasings8 && meta == 11 ? Integer.valueOf(1) : null, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings8, (Object)11)), (Object)-1, (t, m) -> {}, t -> -1))).addElement('D', StructureUtility.withChannel((String)"enableOCTier1", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == GregTechAPI.sBlockReinforced && meta == 2 ? Integer.valueOf(1) : null, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockReinforced, (Object)2)), (Object)-1, (t, m) -> {}, t -> -1))).addElement('E', GTStructureUtility.ofFrame(Materials.DamascusSteel)).addElement('F', GTStructureUtility.ofFrame(Materials.VibrantAlloy)).addElement('G', StructureUtility.withChannel((String)"enableOCTier2", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == GregTechAPI.sBlockCasings8 && meta == 12 ? Integer.valueOf(1) : null, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings8, (Object)12)), (Object)-1, (t, m) -> {}, t -> -1))).addElement('H', GTStructureUtility.ofFrame(Materials.Duranium)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)13)).addElement('J', GTStructureUtility.buildHatchAdder(MTEPCBFactory.class).atLeast(HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.InputBus, HatchElement.Maintenance, HatchElement.Energy.or(HatchElement.ExoticEnergy), SpecialHatchElement.NaniteBus).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(13)).buildAndChain(GregTechAPI.sBlockCasings8, 13)).addElement('K', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('L', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('M', GTStructureUtility.buildHatchAdder(MTEPCBFactory.class).hatchClass(MTEHatchInput.class).adder(MTEPCBFactory::addCoolantInputToMachineList).casingIndex(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 12)).dot(2).buildAndChain(GregTechAPI.sBlockCasings8, 12)).addElement('N', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('O', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)4)).addElement('P', GTStructureUtility.buildHatchAdder(MTEPCBFactory.class).atLeast(HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.InputBus, HatchElement.Maintenance, HatchElement.Energy.or(HatchElement.ExoticEnergy), SpecialHatchElement.NaniteBus).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(11)).buildAndChain(GregTechAPI.sBlockCasings8, 11)).addElement('Q', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)14)).addElement('R', GTStructureUtility.ofFrame(Materials.Americium)).addElement('S', GTStructureUtility.buildHatchAdder(MTEPCBFactory.class).hatchClass(MTEHatchInput.class).adder(MTEPCBFactory::addCoolantInputToMachineList).casingIndex(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 12)).dot(2).buildAndChain(GregTechAPI.sBlockCasings8, 12)).addElement('T', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)15)).build();
    private int ticker = 0;

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        if (this.mSetTier < 3) {
            this.buildPiece(tier1, stackSize, hintsOnly, 3, 5, 0);
            if (this.mSetTier == 2) {
                this.buildPiece(tier2, stackSize, hintsOnly, 7, 6, 2);
            }
        } else {
            this.buildPiece(tier3, stackSize, hintsOnly, 3, 21, 0);
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                this.getStructureDefinition().buildOrHints((Object)this, stackSize, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], hintsOnly);
            } else {
                this.buildPiece(bioUpgrade, stackSize, hintsOnly, this.mBioOffsets[0], 6, this.mBioOffsets[1]);
            }
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            this.buildPiece(ocTier1Upgrade, stackSize, hintsOnly, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1]);
        }
        if (!this.mOCTier1 && this.mOCTier2) {
            this.buildPiece(ocTier2Upgrade, stackSize, hintsOnly, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1]);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int built = 0;
        if (this.mMachine) {
            return -1;
        }
        if (this.mSetTier < 3) {
            built += this.survivalBuildPiece(tier1, stackSize, 3, 5, 0, elementBudget, env, false, true);
            if (this.mSetTier == 2) {
                built += this.survivalBuildPiece(tier2, stackSize, 7, 6, 2, elementBudget, env, false, true);
            }
        } else {
            built += this.survivalBuildPiece(tier3, stackSize, 3, 21, 0, elementBudget, env, false, true);
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                this.getStructureDefinition().survivalBuild((Object)this, stackSize, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], elementBudget, env, false);
            } else {
                built += this.survivalBuildPiece(bioUpgrade, stackSize, this.mBioOffsets[0], 6, this.mBioOffsets[1], elementBudget, env, false, true);
            }
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            built += this.survivalBuildPiece(ocTier1Upgrade, stackSize, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1], elementBudget, env, false, true);
        }
        if (!this.mOCTier1 && this.mOCTier2) {
            built += this.survivalBuildPiece(ocTier2Upgrade, stackSize, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1], elementBudget, env, false, true);
        }
        return built;
    }

    public MTEPCBFactory(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPCBFactory(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPCBFactory(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getTier() < 3 ? GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 11) : GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getTier() < 3 ? GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 11) : GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.mSetTier < 3 ? ((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(11) : ((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(13))};
    }

    @Override
    public IStructureDefinition<MTEPCBFactory> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mTier = 0;
        this.mUpgradesInstalled = 0;
        this.mCoolantInputHatch = null;
        this.naniteBuses.clear();
        if (this.mSetTier < 3) {
            if (!this.checkPiece(tier1, 3, 5, 0)) {
                return false;
            }
            if (this.mSetTier == 2) {
                if (!this.checkPiece(tier2, 7, 6, 2)) {
                    return false;
                }
                this.mTier = 2;
            } else {
                this.mTier = 1;
            }
        } else {
            if (!this.checkPiece(tier3, 3, 21, 0)) {
                return false;
            }
            this.mTier = 3;
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                if (!this.getStructureDefinition().check((Object)this, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], !this.mMachine)) {
                    return false;
                }
            } else if (!this.checkPiece(bioUpgrade, this.mBioOffsets[0], 6, this.mBioOffsets[1])) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            if (!this.checkPiece(ocTier1Upgrade, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1])) {
                return false;
            }
            if (this.mCoolantInputHatch == null) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        if (this.mOCTier2 && !this.mOCTier1) {
            if (!this.checkPiece(ocTier2Upgrade, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1])) {
                return false;
            }
            if (this.mCoolantInputHatch == null) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (!this.checkExoticAndNormalEnergyHatches()) {
            return false;
        }
        return this.mTier > 0;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.pcbFactoryRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                int numberOfNanites = 0;
                Materials naniteMaterial = recipe.getMetadata(GTRecipeConstants.PCB_NANITE_MATERIAL);
                if (naniteMaterial != null) {
                    if (MTEPCBFactory.this.naniteBuses.isEmpty()) {
                        return SimpleCheckRecipeResult.ofFailure("nanites_missing");
                    }
                    boolean nanitesFound = false;
                    for (MTEHatchNanite naniteBus : MTEPCBFactory.this.naniteBuses) {
                        ItemStack storedNanites = naniteBus.getItemStack();
                        Materials storedNaniteMaterial = naniteBus.getStoredNaniteMaterial();
                        if (storedNanites == null || storedNaniteMaterial != naniteMaterial) continue;
                        numberOfNanites = naniteBus.getItemCount();
                        nanitesFound = true;
                        break;
                    }
                    if (!nanitesFound) {
                        return SimpleCheckRecipeResult.ofFailure("nanites_missing");
                    }
                }
                this.maxParallel = (int)Math.min(Math.max(Math.ceil(Math.pow(numberOfNanites, 0.75)), 1.0), 256.0);
                MTEPCBFactory.this.mMaxParallel = this.maxParallel;
                PCBFactoryUpgrade requiredUpgrade = recipe.getMetadata(PCBFactoryUpgradeKey.INSTANCE);
                if (requiredUpgrade == PCBFactoryUpgrade.BIO && !MTEPCBFactory.this.mBioUpgrade) {
                    return SimpleCheckRecipeResult.ofFailure("bio_upgrade_missing");
                }
                int requiredPCBTier = recipe.getMetadataOrDefault(PCBFactoryTierKey.INSTANCE, 1);
                if (requiredPCBTier > MTEPCBFactory.this.mTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(requiredPCBTier);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setNoOverclock(MTEPCBFactory.this.isNoOC()).setEUtDiscount(Math.sqrt(MTEPCBFactory.this.mUpgradesInstalled == 0 ? 1.0 : (double)MTEPCBFactory.this.mUpgradesInstalled)).setDurationModifier(MTEPCBFactory.this.getDurationMultiplierFromRoughness()).setDurationDecreasePerOC(MTEPCBFactory.this.mOCTier2 ? 4.0 : 2.0);
            }

            @Override
            @Nonnull
            protected ParallelHelper createParallelHelper(@Nonnull GTRecipe recipe) {
                return super.createParallelHelper(recipe).setEUtModifier((float)Math.sqrt(MTEPCBFactory.this.mUpgradesInstalled == 0 ? 1.0 : (double)MTEPCBFactory.this.mUpgradesInstalled)).setChanceMultiplier(MTEPCBFactory.this.mRoughnessMultiplier);
            }
        };
    }

    private boolean isNoOC() {
        return !this.mOCTier1 && !this.mOCTier2;
    }

    private double getDurationMultiplierFromRoughness() {
        return this.mRoughnessMultiplier * this.mRoughnessMultiplier;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        if (this.ticker % 20 == 0) {
            if (!this.isNoOC()) {
                FluidStack tFluid;
                FluidStack fluidStack = tFluid = this.mOCTier1 ? GTModHandler.getDistilledWater(10L) : Materials.SuperCoolant.getFluid(10L);
                if (!this.drain(this.mCoolantInputHatch, tFluid, true)) {
                    this.stopMachine(ShutDownReasonRegistry.outOfFluid(tFluid));
                    return false;
                }
            }
            this.ticker = 0;
        }
        ++this.ticker;
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mUpdate <= -150) {
            this.mUpdate = 50;
        }
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return (int)(10000.0f * this.mRoughnessMultiplier);
    }

    private int getTier() {
        return this.mSetTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        if (aEventID == 1) {
            if ((aValue & 1) == 1) {
                this.mSetTier = 1;
            }
            if ((aValue & 2) == 2) {
                this.mSetTier = 2;
            }
            if ((aValue & 4) == 4) {
                this.mSetTier = 3;
            }
            if ((aValue & 8) == 8) {
                this.mBioUpgrade = true;
            }
            if ((aValue & 0x40) == 64) {
                this.mBioRotate = true;
            }
            if ((aValue & 0x10) == 16) {
                this.mOCTier1 = true;
            }
            if ((aValue & 0x20) == 32) {
                this.mOCTier2 = true;
            }
        }
    }

    private ExtendedFacing transformFacing(ExtendedFacing facing) {
        ForgeDirection curDirection = facing.getDirection();
        Rotation curRotation = facing.getRotation();
        Flip curFlip = facing.getFlip();
        ForgeDirection newDirection = curDirection;
        Rotation newRotation = curRotation;
        Flip newFlip = curFlip;
        if (curDirection == ForgeDirection.UP || curDirection == ForgeDirection.DOWN) {
            switch (curRotation) {
                case CLOCKWISE: 
                case COUNTER_CLOCKWISE: {
                    newFlip = curFlip == Flip.NONE ? Flip.HORIZONTAL : Flip.NONE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
                    break;
                }
                case NORMAL: {
                    newRotation = curDirection == ForgeDirection.UP ? Rotation.CLOCKWISE : Rotation.COUNTER_CLOCKWISE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.EAST : ForgeDirection.WEST;
                    newFlip = Flip.NONE;
                    break;
                }
                case UPSIDE_DOWN: {
                    newRotation = curDirection == ForgeDirection.UP ? Rotation.COUNTER_CLOCKWISE : Rotation.CLOCKWISE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.EAST : ForgeDirection.WEST;
                    newFlip = Flip.NONE;
                }
            }
        } else if (curRotation == Rotation.CLOCKWISE || curRotation == Rotation.COUNTER_CLOCKWISE) {
            newFlip = curRotation == Rotation.CLOCKWISE ? (curFlip == Flip.NONE ? Flip.NONE : Flip.HORIZONTAL) : (curFlip != Flip.NONE ? Flip.NONE : Flip.HORIZONTAL);
            newDirection = curRotation == Rotation.CLOCKWISE ? ForgeDirection.UP : ForgeDirection.DOWN;
        } else {
            switch (curDirection) {
                case EAST: {
                    ForgeDirection forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case NORTH: {
                    ForgeDirection forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case WEST: {
                    ForgeDirection forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case SOUTH: {
                    ForgeDirection forgeDirection = ForgeDirection.WEST;
                    break;
                }
                default: {
                    ForgeDirection forgeDirection = newDirection = curDirection;
                }
            }
        }
        if (curRotation == Rotation.UPSIDE_DOWN && curDirection != ForgeDirection.UP && curDirection != ForgeDirection.DOWN) {
            newFlip = curFlip == Flip.NONE ? Flip.HORIZONTAL : Flip.NONE;
        }
        return ExtendedFacing.of((ForgeDirection)newDirection, (Rotation)newRotation, (Flip)newFlip);
    }

    public boolean addCoolantInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = null;
            this.mCoolantInputHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    protected long getActualEnergyUsage() {
        return -this.lEUt * 10000L / (long)Math.min(Math.max(1000, this.mEfficiency), 10000);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.inputSeparation = !this.inputSeparation;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatch tHatch : this.getExoticAndNormalEnergyHatchList()) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        long voltage = this.getAverageInputVoltage();
        long amps = this.getMaxInputAmps();
        int mCurrentParallel = 0;
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(voltage) + EnumChatFormatting.RESET + " EU/t(*" + amps + " A)" + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(voltage)] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.GREEN + this.mMaxParallel, StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.GREEN + mCurrentParallel};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Circuit Board Fabricator").addInfo(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + "IMPORTANT! Check the configuration menu before building!").addInfo("Tier of the machine determines the available recipes").addInfo("Machine tier (1-3) is set in the controller GUI").addInfo("The configuration menu can be used to add upgrades").addInfo("Each tier and upgrade requires additional structures").addInfo("Power consumption is multiplied by Sqrt(structures)").addInfo("Tier 2 and 3 allow parallel by using extra nanites").addInfo("Nanites have to be placed in a Nanite Containment Bus").addInfo("The formula for parallels is the " + TooltipHelper.parallelText("amount of nanites^0.75") + ", rounded up").addInfo("Maximum parallel is " + TooltipHelper.parallelText("256")).addInfo("Recipes require a cooling upgrade to be overclocked").addInfo("Liquid Cooling uses " + EnumChatFormatting.BLUE + "10 L/s" + EnumChatFormatting.GRAY + " of " + EnumChatFormatting.BLUE + "distilled water" + EnumChatFormatting.GRAY + " and enables default overclocks").addInfo("Thermosink uses " + EnumChatFormatting.AQUA + "10 L/s" + EnumChatFormatting.GRAY + " of " + EnumChatFormatting.AQUA + "Super Coolant" + EnumChatFormatting.GRAY + " and enables " + EnumChatFormatting.LIGHT_PURPLE + "perfect overclocks").addInfo("Trace size can be changed to modify the material usage and machine speed").addTecTechHatchInfo().beginStructureBlock(30, 38, 13, false).addMaintenanceHatch(EnumChatFormatting.GOLD + "1", 1).addEnergyHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "2" + EnumChatFormatting.GRAY + " or " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " TT energy hatch", 1).addInputBus(EnumChatFormatting.GOLD + "0" + EnumChatFormatting.GRAY + "+", 1).addOutputBus(EnumChatFormatting.GOLD + "0" + EnumChatFormatting.GRAY + "+", 1).addInputHatch(EnumChatFormatting.GOLD + "0" + EnumChatFormatting.GRAY + "+", 1).addStructureInfo(EnumChatFormatting.WHITE + "Nanite Containment Bus: " + EnumChatFormatting.GOLD + "0" + EnumChatFormatting.GRAY + "+").addStructureInfo(EnumChatFormatting.WHITE + "Coolant Hatch (Input Hatch): " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Center of the Liquid Cooling/Thermosink").addStructureInfo(EnumChatFormatting.BLUE + "Base Multi (Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "9" + EnumChatFormatting.GRAY + " Vibrant Alloy Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "25" + EnumChatFormatting.GRAY + " Any Tiered Glass").addStructureInfo(EnumChatFormatting.GOLD + "77" + EnumChatFormatting.GRAY + " Basic Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "12" + EnumChatFormatting.GRAY + " Grate Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "25" + EnumChatFormatting.GRAY + " Plascrete Block").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.BLUE + " (Adds to Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "34" + EnumChatFormatting.GRAY + " Duranium Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "158" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 3 + EnumChatFormatting.BLUE + ":").addStructureInfo(EnumChatFormatting.GOLD + "292" + EnumChatFormatting.GRAY + " Radiation Proof Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "76" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.BLUE + "Biochamber Upgrade").addStructureInfo(EnumChatFormatting.GOLD + "68" + EnumChatFormatting.GRAY + " Clean Stainless Steel Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "72" + EnumChatFormatting.GRAY + " Any Tiered Glass").addStructureInfo(EnumChatFormatting.BLUE + "Liquid Cooling Tower (Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "68" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.GOLD + "12" + EnumChatFormatting.GRAY + " Extreme Engine Intake Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Tungstensteel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "21" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.BLUE + "Thermosink Radiator(Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Americium Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "41" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "8" + EnumChatFormatting.GRAY + " Superconducting Coil Block").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Tungstensteel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "48" + EnumChatFormatting.GRAY + " Infinity Cooled Casing").toolTipFinisher(GTValues.AuthorBlueWeabo);
        return tt;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBioUpgrade", this.mBioUpgrade);
        aNBT.func_74757_a("mBioRotate", this.mBioRotate);
        aNBT.func_74768_a("mBioOffsetX", this.mBioOffsets[0]);
        aNBT.func_74768_a("mBioOffsetZ", this.mBioOffsets[1]);
        aNBT.func_74757_a("mOCTier1Upgrade", this.mOCTier1);
        aNBT.func_74768_a("mOCTier1OffsetX", this.mOCTier1Offsets[0]);
        aNBT.func_74768_a("mOCTier1OffsetZ", this.mOCTier1Offsets[1]);
        aNBT.func_74757_a("mOCTier2Upgrade", this.mOCTier2);
        aNBT.func_74768_a("mOCTier2OffsetX", this.mOCTier2Offsets[0]);
        aNBT.func_74768_a("mOCTier2OffsetZ", this.mOCTier2Offsets[1]);
        aNBT.func_74776_a("mRoughnessMultiplier", this.mRoughnessMultiplier);
        aNBT.func_74768_a("mSetTier", this.mSetTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparate");
        }
        this.mBioUpgrade = aNBT.func_74767_n("mBioUpgrade");
        this.mBioRotate = aNBT.func_74767_n("mBioRotate");
        this.mBioOffsets[0] = aNBT.func_74762_e("mBioOffsetX");
        this.mBioOffsets[1] = aNBT.func_74762_e("mBioOffsetZ");
        this.mOCTier1 = aNBT.func_74767_n("mOCTier1Upgrade");
        this.mOCTier1Offsets[0] = aNBT.func_74762_e("mOCTier1OffsetX");
        this.mOCTier1Offsets[1] = aNBT.func_74762_e("mOCTier1OffsetZ");
        this.mOCTier2 = aNBT.func_74767_n("mOCTier2Upgrade");
        this.mOCTier2Offsets[0] = aNBT.func_74762_e("mOCTier2OffsetX");
        this.mOCTier2Offsets[1] = aNBT.func_74762_e("mOCTier2OffsetZ");
        this.mRoughnessMultiplier = aNBT.func_74760_g("mRoughnessMultiplier");
        this.mSetTier = aNBT.func_74762_e("mSetTier");
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GTCEU_LOOP_ASSEMBLER;
    }

    @Override
    public byte getUpdateData() {
        byte data = 0;
        if (this.mSetTier == 1) {
            data = (byte)(data + 1);
        } else if (this.mSetTier == 2) {
            data = (byte)(data + 2);
        } else if (this.mSetTier == 3) {
            data = (byte)(data + 4);
        }
        if (this.mBioUpgrade) {
            data = (byte)(data + 8);
        }
        if (this.mBioRotate) {
            data = (byte)(data + 64);
        }
        if (this.mOCTier1) {
            data = (byte)(data + 16);
        }
        if (this.mOCTier2) {
            data = (byte)(data + 32);
        }
        return data;
    }

    @Override
    public Pos2d getStructureUpdateButtonPos() {
        return new Pos2d(80, 91);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10, this::createConfigurationWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_CYCLIC);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.ConfigMenu")).setPos(174, 130))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"GT5U.machines.tier"))).setTextAlignment(Alignment.Center).setScale(0.91f).setSize(20, 16).setPos(173, 98))).widget(new NumericWidget().setGetter(() -> this.mSetTier).setSetter(val -> {
            this.mSetTier = (int)val;
        }).setBounds(1.0, 3.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tier")).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(18, 18).setPos(173, 110));
    }

    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)160);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setPos(5, 5).setSize(16, 16))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.MBTT.ConfigMenu")).setPos(25, 9))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(((Column)((Column)((Column)((Column)((Column)((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mBioUpgrade, val -> {
            this.mBioUpgrade = val;
            if (!this.mBioUpgrade) {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.BioOff"));
            } else {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.BioOn"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.1"))).addChild(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Bio")).setTextAlignment(Alignment.Center).setPos(23, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mBioRotate, val -> {
            this.mBioRotate = val;
            if (!this.mBioRotate) {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.RotBioOff"));
            } else {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.RotBioOn"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.2"))).addChild(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.RotBio")).setTextAlignment(Alignment.Center).setPos(23, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mOCTier1, val -> {
            this.mOCTier1 = val;
            this.mOCTier2 = false;
            if (!this.mOCTier1) {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T1CoolOff"));
            } else {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T1CoolOn"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.3"))).addChild(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.LiqCool")).setTextAlignment(Alignment.Center).setPos(20, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mOCTier2, val -> {
            this.mOCTier2 = val;
            this.mOCTier1 = false;
            if (!this.mOCTier2) {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T2CoolOff"));
            } else {
                GTUtility.sendChatToPlayer(player, StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T2CoolOn"));
            }
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.4"))).addChild(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Sink")).setTextAlignment(Alignment.Center).setPos(20, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Size"))).setSize(90, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(0, 4))).widget(new NumericWidget().setGetter(() -> (int)(1.0f / this.mRoughnessMultiplier * 100.0f)).setSetter(val -> {
            this.mRoughnessMultiplier = 100.0f / (float)((int)val);
        }).setBounds(50.0, 200.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.5")).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(90, 16))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).addTooltip(new Text(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Tooltip.6")).color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()))).setPos(10, 25))).widget(((Column)((Column)((Column)((Column)((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.Offsets"))).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new NumericWidget().setGetter(() -> this.mBioOffsets[0]).setSetter(val -> {
            this.mBioOffsets[0] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)xOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new NumericWidget().setGetter(() -> this.mBioOffsets[1]).setSetter(val -> {
            this.mBioOffsets[1] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)zOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T1CoolOffset"))).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new NumericWidget().setGetter(() -> this.mOCTier1Offsets[0]).setSetter(val -> {
            this.mOCTier1Offsets[0] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)xOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new NumericWidget().setGetter(() -> this.mOCTier1Offsets[1]).setSetter(val -> {
            this.mOCTier1Offsets[1] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)zOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"GT5U.MBTT.PCB.T2CoolOffset"))).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new NumericWidget().setGetter(() -> this.mOCTier2Offsets[0]).setSetter(val -> {
            this.mOCTier2Offsets[0] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)xOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new NumericWidget().setGetter(() -> this.mOCTier2Offsets[1]).setSetter(val -> {
            this.mOCTier2Offsets[1] = (int)val;
        }).setBounds(-16.0, 16.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip(StatCollector.func_74838_a((String)zOffsetText)).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).setPos(110, 25));
        return builder.build();
    }

    public boolean addNaniteBusToMachineList(IGregTechTileEntity tileEntity, int baseCasingIndex) {
        if (tileEntity == null) {
            return false;
        }
        IMetaTileEntity metaTileEntity = tileEntity.getMetaTileEntity();
        if (metaTileEntity instanceof MTEHatchNanite) {
            MTEHatchNanite naniteBus = (MTEHatchNanite)metaTileEntity;
            naniteBus.updateTexture(baseCasingIndex);
            this.naniteBuses.add(naniteBus);
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public void onPreviewConstruct(@NotNull ItemStack trigger) {
        this.mSetTier = trigger.field_77994_a;
        if (ChannelDataAccessor.hasSubChannel((ItemStack)trigger, (String)"enableBioUpgrade")) {
            this.buildPiece(bioUpgrade, trigger, false, -5, 6, 0);
        }
        if (ChannelDataAccessor.hasSubChannel((ItemStack)trigger, (String)"enableOCTier2")) {
            this.buildPiece(ocTier2Upgrade, trigger, false, 2, 9, -11);
        } else if (ChannelDataAccessor.hasSubChannel((ItemStack)trigger, (String)"enableOCTier1")) {
            this.buildPiece(ocTier1Upgrade, trigger, false, 2, 9, -11);
        }
    }

    private static enum SpecialHatchElement implements IHatchElement<MTEPCBFactory>
    {
        NaniteBus(MTEPCBFactory::addNaniteBusToMachineList, new Class[]{MTEHatchNanite.class}){

            @Override
            public long count(MTEPCBFactory gtMetaTileEntityPCBFactory) {
                return gtMetaTileEntityPCBFactory.naniteBuses.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEPCBFactory> adder;

        @SafeVarargs
        private SpecialHatchElement(IGTHatchAdder<MTEPCBFactory> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEPCBFactory> adder() {
            return this.adder;
        }
    }
}

