/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.uifactory;

import appeng.api.util.DimensionalCoord;
import appeng.client.render.BlockPosHighlighter;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.CategoryList;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.net.PacketDebugRedstoneCover;
import gregtech.common.covers.CoverPosition;
import gregtech.common.gui.modularui.uifactory.SnifferEntryListSyncHandler;
import gregtech.common.items.ItemRedstoneSniffer;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class RedstoneSnifferGuiBuilder {
    private final GuiData guiData;
    private final PanelSyncManager guiSyncManager;
    private String freqFilter = "";
    private String ownerFilter = "";

    public RedstoneSnifferGuiBuilder(GuiData guiData, PanelSyncManager guiSyncManager) {
        this.guiData = guiData;
        this.guiSyncManager = guiSyncManager;
    }

    public ModularPanel build() {
        int scale;
        if (NetworkUtils.isClient()) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            scale = settings.field_74335_Z > 0 ? settings.field_74335_Z : 4;
        } else {
            scale = 1;
        }
        int textColor = Color.rgb((int)255, (int)255, (int)255);
        final AtomicInteger lastPage = new AtomicInteger(0);
        if (this.guiData.getMainHandItem().func_77978_p() != null && this.guiData.getMainHandItem().func_77978_p().func_74764_b("last_page")) {
            lastPage.set(this.guiData.getMainHandItem().func_77978_p().func_74762_e("last_page"));
        }
        final IntSyncValue pageSyncer = new IntSyncValue(lastPage::get, page -> {
            lastPage.set(page);
            if (this.guiData.getMainHandItem().func_77978_p() == null) {
                this.guiData.getMainHandItem().func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = this.guiData.getMainHandItem().func_77978_p();
            tag.func_74768_a("last_page", page);
        });
        this.guiSyncManager.syncValue("last_page", (SyncHandler)pageSyncer);
        PagedWidget.Controller controller = new PagedWidget.Controller(){

            public void setPage(int page) {
                super.setPage(page);
                pageSyncer.setValue((Object)page);
            }
        };
        ListWidget regularListWidget = new ListWidget();
        regularListWidget.sizeRel(1.0f);
        ListWidget advancedListWidget = new ListWidget();
        advancedListWidget.sizeRel(1.0f);
        BooleanSyncValue playerIsOpSyncer = new BooleanSyncValue(() -> false, () -> {
            EntityPlayerMP player = (EntityPlayerMP)this.guiData.getPlayer();
            return player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH());
        });
        this.guiSyncManager.syncValue("player_is_op", (SyncHandler)playerIsOpSyncer);
        ModularPanel panel = ModularPanel.defaultPanel((String)"redstone_sniffer");
        ((Flex)panel.flex().sizeRel(0.5f, 0.75f)).align(Alignment.Center);
        PagedWidget data = new PagedWidget(){

            public void afterInit() {
                this.setPage(lastPage.get());
            }
        };
        data.sizeRel(1.0f, 0.7f);
        data.controller(controller);
        SnifferEntryListSyncHandler regularMapSyncer = new SnifferEntryListSyncHandler(() -> {
            ArrayList result = new ArrayList();
            GregTechAPI.sWirelessRedstone.forEach((frequency, ignored) -> {
                boolean isPrivate = frequency > 65535;
                int displayFreq = isPrivate ? frequency - 65536 : frequency;
                result.add(new ItemRedstoneSniffer.SnifferEntry(String.valueOf(displayFreq), isPrivate));
            });
            return result;
        });
        regularMapSyncer.setChangeListener(() -> {
            if (!regularListWidget.getChildren().isEmpty()) {
                return;
            }
            AtomicInteger bgStripe = new AtomicInteger(0);
            int stripe1 = Color.rgb((int)79, (int)82, (int)119);
            int stripe2 = Color.rgb((int)67, (int)58, (int)96);
            ArrayList<ItemRedstoneSniffer.SnifferEntry> entries = new ArrayList<ItemRedstoneSniffer.SnifferEntry>(regularMapSyncer.getValue());
            entries.sort(Comparator.comparingInt(a -> a.isPrivate ? 1 : 0));
            ArrayList regularList = new ArrayList();
            entries.forEach(entry -> {
                bgStripe.getAndIncrement();
                regularList.add((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().setEnabledIf(w -> this.freqFilter.isEmpty() || entry.freq.equals(this.freqFilter))).sizeRel(1.0f, 0.1f * (float)scale)).expanded()).background(new IDrawable[]{bgStripe.get() % 2 == 0 ? new Rectangle().setColor(stripe1) : new Rectangle().setColor(stripe2)})).child((IWidget)((TextWidget)new TextWidget(entry.freq).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(entry.isPrivate ? IKey.lang((String)"gui.yes").toString() : IKey.lang((String)"gui.no").toString()).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)));
            });
            regularList.forEach(arg_0 -> ((ListWidget)regularListWidget).child(arg_0));
        });
        this.guiSyncManager.syncValue("regular_map", (SyncHandler)regularMapSyncer);
        data.addPage((IWidget)((Flow)new Column().child((IWidget)((Flow)((Flow)new Row().heightRel(0.1f)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency")).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.private")).widthRel(0.5f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)))).child((IWidget)((SingleChildWidget)new SingleChildWidget().sizeRel(1.0f, 0.9f)).child((IWidget)regularListWidget)));
        SnifferEntryListSyncHandler advancedMapSyncer = new SnifferEntryListSyncHandler(() -> {
            ArrayList result = new ArrayList();
            GregTechAPI.sAdvancedWirelessRedstone.forEach((uuid, coverMap) -> {
                if (playerIsOpSyncer.getValue().booleanValue() || this.canSeeCovers(this.guiData, (String)uuid)) {
                    String owner = uuid.equals("null") ? "Public" : SpaceProjectManager.getPlayerNameFromUUID(UUID.fromString(uuid));
                    coverMap.forEach((frequency, covers) -> covers.forEach((coverPosition, ignored) -> result.add(new ItemRedstoneSniffer.SnifferEntry(owner, (String)frequency, (CoverPosition)coverPosition))));
                }
            });
            return result;
        });
        advancedMapSyncer.setChangeListener(() -> {
            if (!advancedListWidget.getChildren().isEmpty()) {
                return;
            }
            ArrayList<ItemRedstoneSniffer.SnifferEntry> entries = new ArrayList<ItemRedstoneSniffer.SnifferEntry>(advancedMapSyncer.getValue());
            entries.sort((a, b) -> {
                if (a.owner.equals("Public")) {
                    return -1;
                }
                if (b.owner.equals("Public")) {
                    return 1;
                }
                return a.owner.compareTo(b.owner);
            });
            List<IWidget> advancedList = this.processAdvancedFrequencies(entries, (ListWidget<IWidget, CategoryList.Root>)advancedListWidget, this.guiSyncManager, scale, textColor);
            advancedList.forEach(arg_0 -> ((ListWidget)advancedListWidget).child(arg_0));
        });
        this.guiSyncManager.syncValue("adv_map", (SyncHandler)advancedMapSyncer);
        data.addPage((IWidget)((Flow)new Column().child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.owner")).widthRel(0.15f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency")).widthRel(0.35f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.dimension")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.action")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center)))).child((IWidget)((SingleChildWidget)new SingleChildWidget().sizeRel(1.0f, 0.9f)).child((IWidget)advancedListWidget)));
        panel.child((IWidget)((Flow)((Flow)((Flow)new Column().margin(10)).child((IWidget)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).marginBottom(10)).child((IWidget)((PageButton)((PageButton)new PageButton(0, controller).widthRel(0.5f)).align(Alignment.CenterLeft)).overlay(new IDrawable[]{IKey.lang((String)"gt.item.redstone_sniffer.regular_wireless")}))).child((IWidget)((PageButton)((PageButton)new PageButton(1, controller).widthRel(0.5f)).align(Alignment.CenterRight)).overlay(new IDrawable[]{IKey.lang((String)"gt.item.redstone_sniffer.advanced_wireless")})))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().heightRel(0.1f)).marginBottom(10)).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.frequency_filter")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().sizeRel(0.25f, 0.5f)).setTextColor(textColor)).value((IStringValue)SyncHandlers.string(() -> this.freqFilter, filter -> {
            this.freqFilter = filter;
        })))).child((IWidget)((TextWidget)new TextWidget(IKey.lang((String)"gt.item.redstone_sniffer.owner_filter")).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().sizeRel(0.25f, 0.5f)).setTextColor(textColor)).value((IStringValue)SyncHandlers.string(() -> this.ownerFilter, filter -> {
            this.ownerFilter = filter;
        }))))).child((IWidget)data));
        panel.background(new IDrawable[]{new Rectangle().setColor(Color.rgb((int)53, (int)46, (int)77))});
        return panel;
    }

    public boolean canSeeCovers(GuiData guiData, String uuid) {
        UUID leader = SpaceProjectManager.getLeader(guiData.getPlayer().func_110124_au());
        return uuid.equals("null") || SpaceProjectManager.getLeader(UUID.fromString(uuid)).equals(leader);
    }

    public List<IWidget> processAdvancedFrequencies(List<ItemRedstoneSniffer.SnifferEntry> entryList, ListWidget<IWidget, CategoryList.Root> listWidget, PanelSyncManager guiSyncManager, int scale, int textColor) {
        ArrayList<IWidget> result = new ArrayList<IWidget>();
        BooleanSyncValue playerIsOpSyncer = (BooleanSyncValue)guiSyncManager.getSyncHandler("player_is_op:0");
        AtomicInteger bgStripe = new AtomicInteger(0);
        int stripe1 = Color.rgb((int)79, (int)82, (int)119);
        int stripe2 = Color.rgb((int)67, (int)58, (int)96);
        for (ItemRedstoneSniffer.SnifferEntry entry : entryList) {
            bgStripe.getAndIncrement();
            CoverPosition cover = entry.coverPosition;
            if (cover == null) continue;
            result.add((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().setEnabledIf(w -> (this.ownerFilter.isEmpty() || entry.owner.contains(this.ownerFilter)) && entry.freq.contains(this.freqFilter))).sizeRel(1.0f, 0.1f * (float)scale)).background(new IDrawable[]{bgStripe.get() % 2 == 0 ? new Rectangle().setColor(stripe1) : new Rectangle().setColor(stripe2)})).expanded()).child((IWidget)((TextWidget)new TextWidget(entry.owner).widthRel(0.15f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(entry.freq).widthRel(0.35f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((TextWidget)new TextWidget(cover.getDimName()).widthRel(0.25f)).color(Integer.valueOf(textColor)).alignment(Alignment.Center))).child((IWidget)((Flow)((Flow)new Row().widthRel(0.25f)).child((IWidget)((SingleChildWidget)new SingleChildWidget().widthRel(0.5f)).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(25, 25)).align(Alignment.Center)).overlay(new IDrawable[]{UITexture.fullImage((String)Mods.GregTech.ID, (String)"gui/overlay_button/redstoneSnifferLocate").asIcon().size(19, 19).margin(3)})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"gt.item.redstone_sniffer.locate")))).onMousePressed(mouseButton -> {
                GTValues.NW.sendToServer(new PacketDebugRedstoneCover(cover.dim, cover.x, cover.y, cover.z, false));
                if (NetworkUtils.isClient()) {
                    ArrayList<DimensionalCoord> list = new ArrayList<DimensionalCoord>();
                    list.add(new DimensionalCoord(cover.x, cover.y, cover.z, cover.dim));
                    String foundMsg = StatCollector.func_74837_a((String)"gt.item.redstone_sniffer.highlight_message", (Object[])new Object[]{cover.x, cover.y, cover.z});
                    BlockPosHighlighter.highlightBlocks((EntityPlayer)guiSyncManager.getPlayer(), list, (String)foundMsg, (String)StatCollector.func_74838_a((String)"gt.item.redstone_sniffer.wrong_dim_message"));
                    listWidget.getPanel().closeIfOpen();
                }
                return true;
            })))).child((IWidget)((SingleChildWidget)((SingleChildWidget)new SingleChildWidget().setEnabledIf(w -> playerIsOpSyncer.getValue())).widthRel(0.5f)).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(25, 25)).align(Alignment.Center)).overlay(new IDrawable[]{UITexture.fullImage((String)Mods.GregTech.ID, (String)"gui/overlay_button/redstoneSnifferTeleport").asIcon().size(19, 19).margin(3)})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"gt.item.redstone_sniffer.teleport")))).onMousePressed(mouseButton -> {
                GTValues.NW.sendToServer(new PacketDebugRedstoneCover(cover.dim, cover.x, cover.y, cover.z, true));
                listWidget.getPanel().closeIfOpen();
                return true;
            })))));
        }
        return result;
    }
}

