/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import codechicken.nei.recipe.HandlerInfo;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.enums.Mods;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipeProperties;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendProperties;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class RecipeMapBuilder<B extends RecipeMapBackend> {
    private final String unlocalizedName;
    private final RecipeMapBackendPropertiesBuilder backendPropertiesBuilder = RecipeMapBackendProperties.builder();
    private final RecipeMapBackend.BackendCreator<B> backendCreator;
    private final BasicUIPropertiesBuilder uiPropertiesBuilder;
    private final NEIRecipePropertiesBuilder neiPropertiesBuilder = NEIRecipeProperties.builder();
    private RecipeMapFrontend.FrontendCreator frontendCreator = RecipeMapFrontend::new;

    public static <B extends RecipeMapBackend> RecipeMapBuilder<B> of(String unlocalizedName, RecipeMapBackend.BackendCreator<B> backendCreator) {
        return new RecipeMapBuilder<B>(unlocalizedName, backendCreator);
    }

    public static RecipeMapBuilder<RecipeMapBackend> of(String unlocalizedName) {
        return new RecipeMapBuilder<RecipeMapBackend>(unlocalizedName, RecipeMapBackend::new);
    }

    private RecipeMapBuilder(String unlocalizedName, RecipeMapBackend.BackendCreator<B> backendCreator) {
        this.unlocalizedName = unlocalizedName;
        this.backendCreator = backendCreator;
        this.uiPropertiesBuilder = BasicUIProperties.builder().progressBarTexture(GTUITextures.fallbackableProgressbar(unlocalizedName, GTUITextures.PROGRESSBAR_ARROW)).neiTransferRectId(unlocalizedName);
    }

    public RecipeMapBuilder<B> minInputs(int minItemInputs, int minFluidInputs) {
        this.backendPropertiesBuilder.minItemInputs(minItemInputs).minFluidInputs(minFluidInputs);
        return this;
    }

    public RecipeMapBuilder<B> specialSlotSensitive() {
        this.backendPropertiesBuilder.specialSlotSensitive();
        return this;
    }

    public RecipeMapBuilder<B> builderTransformer(Consumer<? super GTRecipeBuilder> builderTransformer) {
        this.backendPropertiesBuilder.builderTransformer(builderTransformer);
        return this;
    }

    public RecipeMapBuilder<B> recipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter) {
        this.backendPropertiesBuilder.recipeEmitter(recipeEmitter);
        return this;
    }

    public RecipeMapBuilder<B> recipeEmitterSingle(Function<? super GTRecipeBuilder, ? extends GTRecipe> recipeEmitter) {
        return this.recipeEmitter(recipeEmitter.andThen(Collections::singletonList));
    }

    public RecipeMapBuilder<B> combineRecipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter) {
        this.backendPropertiesBuilder.combineRecipeEmitter(recipeEmitter);
        return this;
    }

    public RecipeMapBuilder<B> combineRecipeEmitterSingle(Function<? super GTRecipeBuilder, ? extends GTRecipe> recipeEmitter) {
        return this.combineRecipeEmitter(recipeEmitter.andThen(Collections::singletonList));
    }

    public RecipeMapBuilder<B> recipeTransformer(Consumer<? super GTRecipe> recipeTransformer) {
        this.backendPropertiesBuilder.recipeTransformer(recipeTransformer);
        return this;
    }

    public RecipeMapBuilder<B> maxIO(int maxItemInputs, int maxItemOutputs, int maxFluidInputs, int maxFluidOutputs) {
        this.uiPropertiesBuilder.maxItemInputs(maxItemInputs).maxItemOutputs(maxItemOutputs).maxFluidInputs(maxFluidInputs).maxFluidOutputs(maxFluidOutputs);
        return this;
    }

    public RecipeMapBuilder<B> slotOverlays(BasicUIProperties.SlotOverlayGetter<IDrawable> slotOverlays) {
        this.uiPropertiesBuilder.slotOverlays(slotOverlays);
        return this;
    }

    public RecipeMapBuilder<B> slotOverlaysSteam(BasicUIProperties.SlotOverlayGetter<SteamTexture> slotOverlaysSteam) {
        this.uiPropertiesBuilder.slotOverlaysSteam(slotOverlaysSteam);
        return this;
    }

    public RecipeMapBuilder<B> progressBar(UITexture texture, ProgressBar.Direction direction) {
        return this.progressBarWithFallback(GTUITextures.fallbackableProgressbar(this.unlocalizedName, texture), direction);
    }

    public RecipeMapBuilder<B> progressBar(UITexture texture) {
        return this.progressBar(texture, ProgressBar.Direction.RIGHT);
    }

    private RecipeMapBuilder<B> progressBarWithFallback(FallbackableUITexture texture, ProgressBar.Direction direction) {
        this.uiPropertiesBuilder.progressBarTexture(texture).progressBarDirection(direction);
        return this;
    }

    public RecipeMapBuilder<B> progressBarSteam(SteamTexture texture) {
        return this.progressBarSteamWithFallback(new FallbackableSteamTexture(SteamTexture.fullImage(Mods.GregTech.ID, "gui/progressbar/" + this.unlocalizedName + "_%s"), texture));
    }

    private RecipeMapBuilder<B> progressBarSteamWithFallback(FallbackableSteamTexture texture) {
        this.uiPropertiesBuilder.progressBarTextureSteam(texture);
        return this;
    }

    public RecipeMapBuilder<B> progressBarSize(int x, int y) {
        this.uiPropertiesBuilder.progressBarSize(new Size(x, y));
        return this;
    }

    public RecipeMapBuilder<B> progressBarPos(int x, int y) {
        this.uiPropertiesBuilder.progressBarPos(new Pos2d(x, y));
        return this;
    }

    public RecipeMapBuilder<B> dontUseProgressBar() {
        this.uiPropertiesBuilder.useProgressBar(false);
        return this;
    }

    public RecipeMapBuilder<B> useSpecialSlot() {
        this.uiPropertiesBuilder.useSpecialSlot(true);
        return this;
    }

    public RecipeMapBuilder<B> neiTransferRect(int x, int y, int width, int height) {
        this.uiPropertiesBuilder.addNEITransferRect(new Rectangle(x, y, width, height));
        return this;
    }

    public RecipeMapBuilder<B> neiTransferRectId(String neiTransferRectId) {
        this.uiPropertiesBuilder.neiTransferRectId(neiTransferRectId);
        return this;
    }

    public RecipeMapBuilder<B> addSpecialTexture(int x, int y, int width, int height, IDrawable texture) {
        this.uiPropertiesBuilder.addSpecialTexture(new Size(width, height), new Pos2d(x, y), texture);
        return this;
    }

    public RecipeMapBuilder<B> addSpecialTextureSteam(int x, int y, int width, int height, SteamTexture texture) {
        this.uiPropertiesBuilder.addSpecialTextureSteam(new Size(width, height), new Pos2d(x, y), texture);
        return this;
    }

    public RecipeMapBuilder<B> logo(IDrawable logo) {
        this.uiPropertiesBuilder.logo(logo);
        return this;
    }

    public RecipeMapBuilder<B> logoSize(int width, int height) {
        this.uiPropertiesBuilder.logoSize(new Size(width, height));
        return this;
    }

    public RecipeMapBuilder<B> logoPos(int x, int y) {
        this.uiPropertiesBuilder.logoPos(new Pos2d(x, y));
        return this;
    }

    public RecipeMapBuilder<B> amperage(int amperage) {
        this.uiPropertiesBuilder.amperage(amperage);
        return this;
    }

    public RecipeMapBuilder<B> disableRegisterNEI() {
        this.neiPropertiesBuilder.disableRegisterNEI();
        return this;
    }

    public RecipeMapBuilder<B> neiHandlerInfo(UnaryOperator<HandlerInfo.Builder> handlerInfoCreator) {
        this.neiPropertiesBuilder.handlerInfoCreator(handlerInfoCreator);
        return this;
    }

    public RecipeMapBuilder<B> neiRecipeBackgroundSize(int width, int height) {
        this.neiPropertiesBuilder.recipeBackgroundSize(new Size(width, height));
        return this;
    }

    public RecipeMapBuilder<B> neiRecipeBackgroundOffset(int x, int y) {
        this.neiPropertiesBuilder.recipeBackgroundOffset(new Pos2d(x, y));
        return this;
    }

    public RecipeMapBuilder<B> neiSpecialInfoFormatter(INEISpecialInfoFormatter neiSpecialInfoFormatter) {
        this.neiPropertiesBuilder.neiSpecialInfoFormatter(neiSpecialInfoFormatter);
        return this;
    }

    public RecipeMapBuilder<B> unificateOutputNEI(boolean unificateOutputNEI) {
        this.neiPropertiesBuilder.unificateOutput(unificateOutputNEI);
        return this;
    }

    public RecipeMapBuilder<B> useCustomFilterForNEI() {
        this.neiPropertiesBuilder.useCustomFilter();
        return this;
    }

    public RecipeMapBuilder<B> disableRenderRealStackSizes() {
        this.neiPropertiesBuilder.disableRenderRealStackSizes();
        return this;
    }

    public RecipeMapBuilder<B> neiItemInputsGetter(Function<GTRecipe, ItemStack[]> itemInputsGetter) {
        this.neiPropertiesBuilder.itemInputsGetter(itemInputsGetter);
        return this;
    }

    public RecipeMapBuilder<B> neiFluidInputsGetter(Function<GTRecipe, FluidStack[]> fluidInputsGetter) {
        this.neiPropertiesBuilder.fluidInputsGetter(fluidInputsGetter);
        return this;
    }

    public RecipeMapBuilder<B> neiItemOutputsGetter(Function<GTRecipe, ItemStack[]> itemOutputsGetter) {
        this.neiPropertiesBuilder.itemOutputsGetter(itemOutputsGetter);
        return this;
    }

    public RecipeMapBuilder<B> neiFluidOutputsGetter(Function<GTRecipe, FluidStack[]> fluidOutputsGetter) {
        this.neiPropertiesBuilder.fluidOutputsGetter(fluidOutputsGetter);
        return this;
    }

    public RecipeMapBuilder<B> neiRecipeComparator(Comparator<GTRecipe> comparator) {
        this.neiPropertiesBuilder.recipeComparator(comparator);
        return this;
    }

    public RecipeMapBuilder<B> frontend(RecipeMapFrontend.FrontendCreator frontendCreator) {
        this.frontendCreator = frontendCreator;
        return this;
    }

    public RecipeMap<B> build() {
        return new RecipeMap<B>(this.unlocalizedName, this.backendCreator.create(this.backendPropertiesBuilder), this.frontendCreator.create(this.uiPropertiesBuilder, this.neiPropertiesBuilder));
    }

    private static <T> Function<? super T, ? extends T> withIdentityReturn(Consumer<T> func) {
        return r -> {
            func.accept(r);
            return r;
        };
    }
}

