/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory.standard;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import gregtech.GTMod;
import gregtech.api.factory.IFactoryElement;
import gregtech.api.factory.IFactoryGrid;
import gregtech.api.factory.IFactoryNetwork;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StandardFactoryGrid<TSelf extends StandardFactoryGrid<TSelf, TElement, TNetwork>, TElement extends IFactoryElement<TElement, TNetwork, TSelf>, TNetwork extends IFactoryNetwork<TNetwork, TElement, TSelf>>
implements IFactoryGrid<TSelf, TElement, TNetwork> {
    public static final Logger LOGGER = LogManager.getLogger((String)"Standard Factory Network");
    public final HashSet<TNetwork> networks = new HashSet();
    public final HashSet<TElement> vertices = new HashSet();
    public final SetMultimap<TElement, TElement> edges = MultimapBuilder.hashKeys().hashSetValues().build();

    protected StandardFactoryGrid() {
    }

    @Override
    public void addElement(TElement element) {
        this.removeElement(element);
        this.vertices.add(element);
        this.updateNeighbours(element);
        HashSet discovered = new HashSet();
        HashSet networks = new HashSet();
        long pre = System.nanoTime();
        this.walkAdjacency(element, discovered, networks, false);
        long post = System.nanoTime();
        LOGGER.info("Walked adjacent elements in " + (double)(post - pre) / 1000.0 + " us");
        if (networks.size() == 0) {
            TNetwork network = this.createNetwork();
            this.networks.add(network);
            for (IFactoryElement e : discovered) {
                if (e.getNetwork() == network) continue;
                e.setNetwork(network);
                network.addElement((IFactoryElement)e);
            }
        } else if (networks.size() == 1) {
            IFactoryNetwork network = (IFactoryNetwork)networks.iterator().next();
            for (IFactoryElement e : discovered) {
                if (e.getNetwork() == network) continue;
                e.setNetwork(network);
                network.addElement(e);
            }
        } else {
            Iterator iter = networks.iterator();
            IFactoryNetwork biggestNetwork = (IFactoryNetwork)iter.next();
            while (iter.hasNext()) {
                IFactoryNetwork network = (IFactoryNetwork)iter.next();
                if (network.getElements().size() <= biggestNetwork.getElements().size()) continue;
                biggestNetwork = network;
            }
            pre = System.nanoTime();
            for (IFactoryNetwork network : networks) {
                if (network == biggestNetwork) continue;
                this.subsume(biggestNetwork, network);
            }
            post = System.nanoTime();
            LOGGER.info("Subsumed " + (networks.size() - 1) + " networks in " + (double)(post - pre) / 1000.0 + " us");
            for (IFactoryElement e : discovered) {
                if (e.getNetwork() != null) continue;
                e.setNetwork(biggestNetwork);
                biggestNetwork.addElement(e);
            }
        }
    }

    @Override
    public void addElementQuietly(TNetwork network, TElement element) {
        this.vertices.add(element);
        element.setNetwork(network);
        network.addElement(element);
    }

    protected abstract TNetwork createNetwork();

    @Override
    public void removeElement(TElement element) {
        if (!this.vertices.contains(element)) {
            return;
        }
        this.vertices.remove(element);
        Set neighbours = this.edges.removeAll(element);
        Object network = element.getNetwork();
        network.removeElement(element);
        element.setNetwork(null);
        if (network.getElements().isEmpty()) {
            network.onNetworkRemoved();
            this.networks.remove(network);
            return;
        }
        for (IFactoryElement neighbour : neighbours) {
            this.updateNeighbours(neighbour);
        }
        if (neighbours.size() <= 1) {
            return;
        }
        HashSet neighbouringClumps = new HashSet();
        HashSet discovered = new HashSet();
        long pre = System.nanoTime();
        for (Object neighbour : neighbours) {
            if (discovered.contains(neighbour)) continue;
            HashSet hashSet = new HashSet();
            this.walkAdjacency(neighbour, hashSet, null, true);
            neighbouringClumps.add(hashSet);
            discovered.addAll(hashSet);
        }
        if (neighbouringClumps.size() <= 1) {
            return;
        }
        HashSet biggestClump = null;
        for (HashSet hashSet : neighbouringClumps) {
            if (biggestClump != null && hashSet.size() <= biggestClump.size()) continue;
            biggestClump = hashSet;
        }
        for (HashSet hashSet : neighbouringClumps) {
            if (hashSet == biggestClump) continue;
            for (IFactoryElement e : hashSet) {
                network.removeElement((IFactoryElement)e);
            }
            TNetwork newNetwork = this.createNetwork();
            for (IFactoryElement e : hashSet) {
                e.setNetwork(newNetwork);
                newNetwork.addElement((IFactoryElement)e);
            }
        }
        long post = System.nanoTime();
        LOGGER.info("Split network in " + (double)(post - pre) / 1000.0 + " us (added " + (neighbouringClumps.size() - 1) + " new networks)");
    }

    @Override
    public void removeElementQuietly(TElement element) {
        if (!this.vertices.contains(element)) {
            return;
        }
        element.getNetwork().removeElement(element);
        this.vertices.remove(element);
        element.setNetwork(null);
        for (IFactoryElement neighbour : this.edges.removeAll(element)) {
            this.updateNeighbours(neighbour);
        }
    }

    @Override
    public void subsume(TNetwork dest, TNetwork source) {
        source.onNetworkSubsumedPre(dest);
        for (IFactoryElement element : new ArrayList(source.getElements())) {
            source.removeElement((IFactoryElement)element);
            element.setNetwork(dest);
            dest.addElement((IFactoryElement)element);
        }
        source.onNetworkSubsumedPost(dest);
        source.onNetworkRemoved();
        this.networks.remove(source);
    }

    private void walkAdjacency(TElement start, HashSet<TElement> discovered, HashSet<TNetwork> networks, boolean recurseIntoNetworked) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(start);
        while (queue.size() > 0) {
            IFactoryElement current = (IFactoryElement)queue.removeFirst();
            discovered.add(current);
            if (networks != null) {
                networks.add(current.getNetwork());
            }
            if (!recurseIntoNetworked && current.getNetwork() != null) continue;
            for (IFactoryElement neighbour : this.edges.get((Object)current)) {
                if (discovered.contains(neighbour)) continue;
                queue.add(neighbour);
            }
        }
        if (networks != null) {
            networks.remove(null);
        }
    }

    public void updateNeighbours(TElement element) {
        this.updateNeighbours(element, new HashSet());
    }

    private void updateNeighbours(TElement element, HashSet<TElement> updated) {
        if (updated.contains(element)) {
            return;
        }
        updated.add(element);
        HashSet neighbours = new HashSet();
        element.getNeighbours(neighbours);
        Set oldNeighbours = this.edges.removeAll(element);
        this.edges.putAll(element, neighbours);
        for (IFactoryElement oldNeighbour : oldNeighbours) {
            if (neighbours.contains(oldNeighbour)) continue;
            this.updateNeighbours(oldNeighbour, updated);
            if (this.edges.containsEntry((Object)oldNeighbour, element)) {
                GTMod.GT_FML_LOGGER.error("A factory element isn't following the graph adjacency contract. Edge B -> A was kept when edge A -> B was removed. A = " + element + ", B = " + oldNeighbour);
            }
            oldNeighbour.onNeighbourRemoved(element);
            element.onNeighbourRemoved((IFactoryElement)oldNeighbour);
        }
        for (IFactoryElement currentNeighbour : neighbours) {
            if (oldNeighbours.contains(currentNeighbour)) continue;
            this.updateNeighbours(currentNeighbour, updated);
            if (!this.edges.containsEntry((Object)currentNeighbour, element)) {
                GTMod.GT_FML_LOGGER.error("A factory element isn't following the graph adjacency contract. Edge B -> A was not added when edge A -> B was added. A = " + element + ", B = " + currentNeighbour);
            }
            currentNeighbour.onNeighbourAdded(element);
            element.onNeighbourAdded((IFactoryElement)currentNeighbour);
        }
    }
}

