/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.BWGTMaterialReference;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;

public class CasingLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff == BWGTMaterialReference.Wood) {
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plank);
        } else {
            if (!(werkstoff.hasGenerationFeature(OrePrefixes.blockCasing) && werkstoff.doesOreDictedItemExists(OrePrefixes.plate) && werkstoff.doesOreDictedItemExists(OrePrefixes.screw) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGtSmall) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGt) && werkstoff.doesOreDictedItemExists(OrePrefixes.plateDouble))) {
                return;
            }
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plateDouble);
        }
    }

    private static void addCasingRecipes(Werkstoff werkstoff, OrePrefixes reboltedCasingsOuterStuff) {
        GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.blockCasing), new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGtSmall)});
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plate, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGtSmall)).itemOutputs(werkstoff.get(OrePrefixes.blockCasing)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
        GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.blockCasingAdvanced), new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(reboltedCasingsOuterStuff), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGt)});
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(reboltedCasingsOuterStuff, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGt)).itemOutputs(werkstoff.get(OrePrefixes.blockCasingAdvanced)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
    }
}

