/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API.recipe;

import bartworks.common.tileentities.tiered.MTERadioHatch;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.recipe.Sievert;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RadioHatchFrontend
extends RecipeMapFrontend {
    public RadioHatchFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter(new RadioHatchSpecialInfoFormatter()));
    }

    @Override
    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
    }

    @Override
    protected void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
    }

    private static class RadioHatchSpecialInfoFormatter
    implements INEISpecialInfoFormatter {
        private RadioHatchSpecialInfoFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            Sievert data = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.SIEVERT, new Sievert(0));
            int radioLevel = data.sievert;
            int mass = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.MASS, 0);
            long time = MTERadioHatch.calcDecayTicks(radioLevel);
            return Arrays.asList(StatCollector.func_74837_a((String)"BW.NEI.display.radhatch.0", (Object[])new Object[]{radioLevel}), StatCollector.func_74837_a((String)"BW.NEI.display.radhatch.1", (Object[])new Object[]{mass}), StatCollector.func_74837_a((String)"BW.NEI.display.radhatch.2", (Object[])new Object[]{(double)(time * (long)mass) / 20.0}));
        }
    }
}

