/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.pluto.world.dungeon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomSpawnerPluto
extends DungeonRoom {
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private Random rand;
    private final List<ChunkCoordinates> spawners = new ArrayList<ChunkCoordinates>();

    public RoomSpawnerPluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = this.rand.nextInt(5) + 6;
            this.sizeY = this.rand.nextInt(2) + 7;
            this.sizeZ = this.rand.nextInt(5) + 6;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int x = this.posX - 1; x <= this.posX + this.sizeX; ++x) {
            for (int y = this.posY - 1; y <= this.posY + this.sizeY; ++y) {
                for (int z = this.posZ - 1; z <= this.posZ + this.sizeZ; ++z) {
                    if (x == this.posX - 1 || x == this.posX + this.sizeX || y == this.posY - 1 || y == this.posY + this.sizeY || z == this.posZ - 1 || z == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, x, y, z, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, x, y, z, cx, cz, Blocks.field_150350_a, 0);
                    if (!(this.rand.nextFloat() < 0.05f)) continue;
                    this.placeBlock(chunk, meta, x, y, z, cx, cz, Blocks.field_150321_G, 0);
                }
            }
        }
        if (this.placeBlock(chunk, meta, this.posX + 1, this.posY - 1, this.posZ + 1, cx, cz, Blocks.field_150474_ac, 0)) {
            this.spawners.add(new ChunkCoordinates(this.posX + 1, this.posY - 1, this.posZ + 1));
        }
        if (this.placeBlock(chunk, meta, this.posX + this.sizeX - 1, this.posY - 1, this.posZ + this.sizeZ - 1, cx, cz, Blocks.field_150474_ac, 0)) {
            this.spawners.add(new ChunkCoordinates(this.posX + this.sizeX - 1, this.posY - 1, this.posZ + this.sizeZ - 1));
        }
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomSpawnerPluto(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand_) {
        for (ChunkCoordinates spawnerCoords : this.spawners) {
            TileEntityMobSpawner spawner;
            if (this.worldObj.func_147439_a(spawnerCoords.field_71574_a, spawnerCoords.field_71572_b, spawnerCoords.field_71573_c) != Blocks.field_150474_ac || (spawner = (TileEntityMobSpawner)this.worldObj.func_147438_o(spawnerCoords.field_71574_a, spawnerCoords.field_71572_b, spawnerCoords.field_71573_c)) == null) continue;
            spawner.func_145881_a().func_98272_a(RoomSpawnerPluto.getMob(rand_));
        }
    }

    private static String getMob(Random rand) {
        String string;
        switch (rand.nextInt(6)) {
            case 0: {
                string = "GalacticraftCore.EvolvedSpider";
                break;
            }
            case 1: {
                string = "GalacticraftCore.EvolvedZombie";
                break;
            }
            case 2: {
                string = "GalacticraftCore.EvolvedCreeper";
                break;
            }
            case 3: {
                string = "GalacticraftCore.EvolvedSkeleton";
                break;
            }
            default: {
                string = "GalacticraftCore.EvolvedCreeper";
            }
        }
        return string;
    }
}

