/*
 * Decompiled with CFR 0.152.
 */
package openmods.infobook;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import openmods.Log;
import openmods.OpenMods;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.page.ItemStackTocPage;
import openmods.gui.component.page.StandardRecipePage;
import openmods.gui.listener.IMouseDownListener;
import openmods.infobook.BookDocumentation;
import openmods.infobook.ICustomBookEntryProvider;
import openmods.utils.CachedInstanceFactory;

public class PageBuilder {
    private static final CachedInstanceFactory<ICustomBookEntryProvider> PROVIDERS = CachedInstanceFactory.create();
    private final SortedMap<String, Entry> pages = Maps.newTreeMap();
    private Set<String> modIds;
    private List<ItemStackTocPage> tocPages;

    protected String getMediaLink(String modId, String type, String id) {
        String lang = (String)OpenMods.proxy.getLanguage().or((Object)"unknown");
        return "https://videos.openmods.info/" + lang + "/tutorial." + modId + "." + type + "." + id;
    }

    public <T> void addPages(String type, FMLControlledNamespacedRegistry<T> registry, StackProvider<T> provider) {
        Set ids = registry.func_148742_b();
        Splitter splitter = Splitter.on((char)':');
        for (String id : ids) {
            BookDocumentation doc;
            Object obj = registry.func_82594_a(id);
            if (obj == null) continue;
            Class<?> cls = obj.getClass();
            try {
                doc = cls.getAnnotation(BookDocumentation.class);
            }
            catch (Throwable t) {
                Log.warn(t, "Failed to get annotation from %s", cls);
                continue;
            }
            if (doc == null) continue;
            Iterator components = splitter.split((CharSequence)id).iterator();
            String itemModId = (String)components.next();
            if (this.modIds != null && !this.modIds.contains(itemModId)) continue;
            String itemName = (String)components.next();
            Class<? extends ICustomBookEntryProvider> customProviderCls = doc.customProvider();
            if (customProviderCls == BookDocumentation.EMPTY.class) {
                ItemStack stack = provider.createStack(itemModId, itemName, obj);
                if (stack == null) continue;
                String customName = doc.customName();
                this.addPage(Strings.isNullOrEmpty((String)customName) ? itemName : customName, itemModId.toLowerCase(Locale.ENGLISH), type, doc.hasVideo(), stack);
                continue;
            }
            ICustomBookEntryProvider customProvider = (ICustomBookEntryProvider)PROVIDERS.getOrCreate(customProviderCls);
            for (ICustomBookEntryProvider.Entry e : customProvider.getBookEntries()) {
                this.addPage(e.name, itemModId.toLowerCase(Locale.ENGLISH), type, doc.hasVideo(), e.stack);
            }
        }
    }

    public void insertTocPages(GuiComponentBook book, int rows, int columns, float scale) {
        ItemStackTocPage page;
        Preconditions.checkState((this.tocPages == null ? 1 : 0) != 0, (Object)"Table Of Contents page already added");
        this.tocPages = Lists.newArrayList();
        for (int tocEntriesCount = this.pages.size(); tocEntriesCount > 0; tocEntriesCount -= page.getCapacity()) {
            page = new ItemStackTocPage(rows, columns, scale);
            this.tocPages.add(page);
            book.addPage(page);
        }
    }

    public void insertPages(GuiComponentBook book) {
        for (Entry e : this.pages.values()) {
            if (this.tocPages != null) {
                int target = book.getNumberOfPages();
                this.addToToc(book, e.stack, target);
            }
            book.addPage(e.page);
        }
    }

    private void addToToc(final GuiComponentBook book, ItemStack stack, final int target) {
        for (ItemStackTocPage tocPage : this.tocPages) {
            if (!tocPage.addEntry(stack, new IMouseDownListener(){

                @Override
                public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                    book.changePage(target);
                }
            })) continue;
            return;
        }
        throw new IllegalStateException(String.format("Tried to add more TOC entries than allocated", new Object[0]));
    }

    private void addPage(String id, String modId, String type, boolean hasVideo, ItemStack stack) {
        StandardRecipePage page;
        String nameKey = this.getTranslationKey(id, modId, type, "name");
        String descriptionKey = this.getTranslationKey(id, modId, type, "description");
        String translatedName = StatCollector.func_74838_a((String)nameKey);
        if (hasVideo) {
            String mediaKey = this.getMediaLink(modId, type, id);
            page = new StandardRecipePage(nameKey, descriptionKey, mediaKey, stack);
        } else {
            page = new StandardRecipePage(nameKey, descriptionKey, stack);
        }
        this.pages.put(translatedName + ":" + id, new Entry(page, stack));
    }

    protected String getTranslationKey(String name, String modId, String type, String category) {
        return String.format("%s.%s.%s.%s", type, modId, name, category);
    }

    public void includeModId(String modid) {
        if (this.modIds == null) {
            this.modIds = Sets.newHashSet();
        }
        this.modIds.add(modid);
    }

    public void addItemPages(StackProvider<Item> provider) {
        this.addPages("item", GameData.getItemRegistry(), provider);
    }

    public void createItemPages() {
        this.addItemPages(new StackProvider<Item>(){

            @Override
            public ItemStack createStack(String itemModId, String itemName, Item item) {
                return new ItemStack(item);
            }
        });
    }

    public void addBlockPages(StackProvider<Block> provider) {
        this.addPages("tile", GameData.getBlockRegistry(), provider);
    }

    public void createBlockPages() {
        this.addBlockPages(new StackProvider<Block>(){

            @Override
            public ItemStack createStack(String blockModId, String blockName, Block block) {
                return new ItemStack(block);
            }
        });
    }

    private static class Entry {
        public final BaseComponent page;
        public final ItemStack stack;

        public Entry(BaseComponent page, ItemStack stack) {
            this.page = page;
            this.stack = stack;
        }
    }

    public static interface StackProvider<T> {
        public ItemStack createStack(String var1, String var2, T var3);
    }
}

