/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Engines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Engines.ModuleEngine;

public abstract class ModuleThermalBase
extends ModuleEngine {
    private short coolantLevel;
    private static final int RELOAD_LIQUID_SIZE = 1;

    public ModuleThermalBase(MinecartModular cart) {
        super(cart);
    }

    @Override
    public int getEngineTier() {
        return 1;
    }

    private int getCoolantLevel() {
        return this.coolantLevel;
    }

    private void setCoolantLevel(int val) {
        this.coolantLevel = (short)val;
    }

    @Override
    protected void initPriorityButton() {
        this.priorityButton = new int[]{72, 17, 16, 16};
    }

    protected abstract int getEfficiency();

    protected abstract int getCoolantEfficiency();

    private boolean requiresCoolant() {
        return this.getCoolantEfficiency() > 0;
    }

    @Override
    public int guiHeight() {
        return 40;
    }

    @Override
    public boolean hasFuel(int consumption) {
        if (super.hasFuel(consumption)) {
            return !this.requiresCoolant() || this.getCoolantLevel() >= consumption;
        }
        return false;
    }

    @Override
    public void consumeFuel(int consumption) {
        super.consumeFuel(consumption);
        this.setCoolantLevel(this.getCoolantLevel() - consumption);
    }

    @Override
    protected void loadFuel() {
        int amount;
        int consumption = this.getCart().getConsumption(true) * 2;
        while (this.getFuelLevel() <= consumption && (amount = this.getCart().drain(FluidRegistry.LAVA, 1, false)) > 0) {
            this.getCart().drain(FluidRegistry.LAVA, amount, true);
            this.setFuelLevel(this.getFuelLevel() + amount * this.getEfficiency());
        }
        while (this.requiresCoolant() && this.getCoolantLevel() <= consumption && (amount = this.getCart().drain(FluidRegistry.WATER, 1, false)) > 0) {
            this.getCart().drain(FluidRegistry.WATER, amount, true);
            this.setCoolantLevel(this.getCoolantLevel() + amount * this.getCoolantEfficiency());
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel() + this.getCart().drain(FluidRegistry.LAVA, Integer.MAX_VALUE, false) * this.getEfficiency();
        if (this.requiresCoolant()) {
            int totalcoolant = this.getCoolantLevel() + this.getCart().drain(FluidRegistry.WATER, Integer.MAX_VALUE, false) * this.getCoolantEfficiency();
            return Math.min(totalcoolant, totalfuel);
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{1.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ENGINES.THERMAL.translate(new String[0]), 8, 6, 0x404040);
        int consumption = this.getCart().getConsumption();
        if (consumption == 0) {
            consumption = 1;
        }
        String str = this.getFuelLevel() >= consumption && (!this.requiresCoolant() || this.getCoolantLevel() >= consumption) ? Localization.MODULES.ENGINES.POWERED.translate(new String[0]) : (this.getFuelLevel() >= consumption ? Localization.MODULES.ENGINES.NO_WATER.translate(new String[0]) : Localization.MODULES.ENGINES.NO_LAVA.translate(new String[0]));
        this.drawString(gui, str, 8, 22, 0x404040);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
        if (this.requiresCoolant()) {
            this.updateGuiData(info, 1, (short)this.getCoolantLevel());
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
        } else if (id == 1) {
            this.setCoolantLevel(data);
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74777_a(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
        if (this.requiresCoolant()) {
            tagCompound.func_74777_a(this.generateNBTName("Coolant", id), (short)this.getCoolantLevel());
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.func_74765_d(this.generateNBTName("Fuel", id)));
        if (this.requiresCoolant()) {
            this.setCoolantLevel(tagCompound.func_74765_d(this.generateNBTName("Coolant", id)));
        }
    }
}

