/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import javax.annotation.Nullable;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Widget;

public interface IOpenableGui
extends Runnable {
    public void openGui();

    default public void openGuiLater() {
        ClientUtils.runLater(this);
    }

    default public void closeGui() {
        this.closeGui(true);
    }

    default public void closeGui(boolean openPrevScreen) {
    }

    default public void openContextMenu(@Nullable Panel panel) {
        if (this instanceof Widget) {
            ((Widget)this).getGui().openContextMenu(panel);
        }
    }

    default public void closeContextMenu() {
        if (this instanceof Widget) {
            ((Widget)this).getGui().closeContextMenu();
        } else {
            this.openContextMenu(null);
        }
    }

    @Override
    default public void run() {
        this.openGui();
    }
}

