/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading.fml.transformers;

import com.gtnewhorizons.angelica.loading.fml.compat.CompatHandlers;
import com.gtnewhorizons.angelica.loading.fml.compat.ICompatHandler;
import com.gtnewhorizons.angelica.loading.fml.compat.transformers.generic.FieldLevelTessellatorTransformer;
import com.gtnewhorizons.angelica.loading.fml.compat.transformers.generic.HUDCachingEarlyReturnTransformer;
import com.gtnewhorizons.angelica.loading.fml.compat.transformers.generic.ThreadSafeISBRHAnnotationTransformer;
import com.gtnewhorizons.angelica.loading.fml.compat.transformers.generic.TileEntityNullGuardTransformer;
import com.gtnewhorizons.angelica.loading.shared.AngelicaClassDump;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.transformers.MixinClassWriter;

public class GenericCompatTransformer
implements IClassTransformer {
    private final Map<String, List<String>> fieldLevelTessellator = new Object2ObjectOpenHashMap();
    private final Map<String, List<String>> tileEntityNullGuard = new Object2ObjectOpenHashMap();
    private final Map<String, Boolean> threadSafeIBSRH = new Object2BooleanOpenHashMap();
    private final Map<String, List<String>> hudCachingEarlyReturn = new Object2ObjectOpenHashMap();
    private final Set<String> targetedClasses = new ObjectOpenHashSet();

    public GenericCompatTransformer() {
        for (ICompatHandler handler : CompatHandlers.getHandlers()) {
            this.registerHandler(handler);
        }
        this.buildTargetClassSet();
    }

    private void registerHandler(ICompatHandler handler) {
        if (handler.getFieldLevelTessellator() != null) {
            this.fieldLevelTessellator.putAll(handler.getFieldLevelTessellator());
        }
        if (handler.getTileEntityNullGuard() != null) {
            this.tileEntityNullGuard.putAll(handler.getTileEntityNullGuard());
        }
        if (handler.getThreadSafeISBRHAnnotations() != null) {
            this.threadSafeIBSRH.putAll(handler.getThreadSafeISBRHAnnotations());
        }
        if (handler.getHUDCachingEarlyReturn() != null) {
            this.hudCachingEarlyReturn.putAll(handler.getHUDCachingEarlyReturn());
        }
    }

    private void buildTargetClassSet() {
        this.targetedClasses.addAll(this.fieldLevelTessellator.keySet());
        this.targetedClasses.addAll(this.tileEntityNullGuard.keySet());
        this.targetedClasses.addAll(this.threadSafeIBSRH.keySet());
        this.targetedClasses.addAll(this.hudCachingEarlyReturn.keySet());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!this.targetedClasses.contains(transformedName)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (this.fieldLevelTessellator.containsKey(transformedName)) {
            FieldLevelTessellatorTransformer.transform(cn, this.fieldLevelTessellator.get(transformedName));
        }
        if (this.tileEntityNullGuard.containsKey(transformedName)) {
            TileEntityNullGuardTransformer.transform(cn, this.tileEntityNullGuard.get(transformedName));
        }
        if (this.threadSafeIBSRH.containsKey(transformedName)) {
            ThreadSafeISBRHAnnotationTransformer.transform(cn, this.threadSafeIBSRH.get(transformedName));
        }
        if (this.hudCachingEarlyReturn.containsKey(transformedName)) {
            HUDCachingEarlyReturnTransformer.transform(cn, this.hudCachingEarlyReturn.get(transformedName));
        }
        MixinClassWriter cw = new MixinClassWriter(3);
        cn.accept((ClassVisitor)cw);
        byte[] bytes = cw.toByteArray();
        AngelicaClassDump.dumpClass(transformedName, basicClass, bytes, this);
        return bytes;
    }
}

