/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins;

import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import com.mitchej123.hodgepodge.config.ASMConfig;
import com.mitchej123.hodgepodge.config.DebugConfig;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import javax.annotation.Nonnull;

public enum Mixins implements IMixins
{
    ONLY_LOAD_LANGUAGES_ONCE_PER_FILE(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinLanguageRegistry"}).setApplyIf(() -> FixesConfig.onlyLoadLanguagesOnce).setPhase(IBaseTransformer.Phase.EARLY)),
    CHANGE_CATEGORY_SPRINT_KEY(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinGameSettings_SprintKey"}).setApplyIf(() -> TweaksConfig.changeSprintCategory).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_TOO_MANY_ALLOCATIONS_CHUNK_POSITION_INT_PAIR(new MixinBuilder("Stops MC from allocating too many ChunkPositionIntPair objects").addCommonMixins(new String[]{"minecraft.MixinChunkCoordIntPair_FixAllocations", "minecraft.MixinWorld_FixAllocations", "minecraft.MixinAnvilChunkLoader_FixAllocations"}).addClientMixins(new String[]{"minecraft.MixinWorldClient_FixAllocations"}).setApplyIf(() -> FixesConfig.fixTooManyAllocationsChunkPositionIntPair).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_TOO_MANY_ALLOCATIONS_CHUNK_POSITION_INT_PAIR_OPTIFINE_INCOMPAT(new MixinBuilder("Stops MC from allocating too many ChunkPositionIntPair objects").addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).addCommonMixins(new String[]{"minecraft.MixinWorldServer_FixAllocations"}).setApplyIf(() -> FixesConfig.fixTooManyAllocationsChunkPositionIntPair).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_SIMULATION_DISTANCE_OPTION(new MixinBuilder("Add option to separate simulation distance from render distance").addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).addExcludedMod((ITargetMod)TargetedMod.ULTRAMINE).addCommonMixins(new String[]{"minecraft.MixinWorld_SimulationDistance", "minecraft.MixinWorldServer_SimulationDistance", "minecraft.MixinChunk_SimulationDistance"}).setApplyIf(() -> FixesConfig.addSimulationDistance).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_RCON_THREADING(new MixinBuilder("Fix RCON Threading by forcing it to run on the main thread").addServerMixins(new String[]{"minecraft.MixinMinecraftServer_RconThreadingFix"}).setApplyIf(() -> FixesConfig.fixRconThreading).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_SIMULATION_DISTANCE_OPTION_THERMOS_FIX(new MixinBuilder("Add option to separate simulation distance from render distance (Thermos fix)").addRequiredMod((ITargetMod)TargetedMod.BUKKIT).addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).addExcludedMod((ITargetMod)TargetedMod.ULTRAMINE).addCommonMixins(new String[]{"minecraft.MixinWorldServer_SimulationDistanceThermosFix"}).setApplyIf(() -> FixesConfig.addSimulationDistance).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_RESOURCEPACK_FOLDER_OPENING(new MixinBuilder("Fix resource pack folder sometimes not opening on windows").addClientMixins(new String[]{"minecraft.MixinGuiScreenResourcePacks"}).setApplyIf(() -> FixesConfig.fixResourcePackOpening).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_ENCHANTMENT_LEVEL_NUMERALS(new MixinBuilder("Fix enchantment levels not displaying properly above a certain value").addCommonMixins(new String[]{"minecraft.MixinEnchantment_FixRomanNumerals"}).setApplyIf(() -> FixesConfig.fixEnchantmentNumerals || TweaksConfig.arabicNumbersForEnchantsPotions).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_CONTAINER_PUT_STACKS_IN_SLOTS(new MixinBuilder("Prevents crash if server sends container with wrong itemStack size").addClientMixins(new String[]{"minecraft.MixinContainer"}).setApplyIf(() -> FixesConfig.fixContainerPutStacksInSlots).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_CONTAINER_SHIFT_CLICK_RECURSION(new MixinBuilder("Backports 1.12 logic for shift clicking slots to prevent recursion").addCommonMixins(new String[]{"minecraft.MixinContainer_FixShiftRecursion"}).setApplyIf(() -> FixesConfig.fixContainerShiftClickRecursion).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_NETHANDLERPLAYCLIENT_HANDLE_SET_SLOT(new MixinBuilder("Prevents crash if server sends itemStack with index larger than client's container").addClientMixins(new String[]{"minecraft.MixinNetHandlerPlayClient_FixHandleSetSlot"}).setApplyIf(() -> FixesConfig.fixNetHandlerPlayClientHandleSetSlot).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_NETHANDLERLOGINSERVER_OFFLINEMODE(new MixinBuilder("Allows the server to assign the logged in UUID to the same username when online_mode is false").addServerMixins(new String[]{"minecraft.MixinNetHandlerLoginServer_OfflineMode"}).setApplyIf(() -> FixesConfig.fixNetHandlerLoginServerOfflineMode).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_INVENTORY_POTION_EFFECT_NUMERALS(new MixinBuilder("Fix potion effects level not displaying properly above a certain value").addClientMixins(new String[]{"minecraft.MixinInventoryEffectRenderer_FixPotionEffectNumerals", "minecraft.MixinItemPotion_FixRomanNumerals"}).setApplyIf(() -> FixesConfig.fixPotionEffectNumerals || TweaksConfig.arabicNumbersForEnchantsPotions).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HASTE_ARM_SWING_ANIMATION(new MixinBuilder("Fix arm not swinging when having too much haste").addCommonMixins(new String[]{"minecraft.MixinEntityLivingBase_FixHasteArmSwing"}).setApplyIf(() -> FixesConfig.fixHasteArmSwing).setPhase(IBaseTransformer.Phase.EARLY)),
    DISABLE_REALMS_BUTTON(new MixinBuilder("Disable Realms button in main menu").addClientMixins(new String[]{"minecraft.MixinGuiMainMenu_DisableRealmsButton"}).setApplyIf(() -> TweaksConfig.disableRealmsButton).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_TIME_GET(new MixinBuilder("Add /time get command").addCommonMixins(new String[]{"minecraft.MixinCommandTime"}).setApplyIf(() -> TweaksConfig.addTimeGet).setPhase(IBaseTransformer.Phase.EARLY)),
    OPTIMIZE_WORLD_UPDATE_LIGHT(new MixinBuilder("Optimize world updateLightByType method").addCommonMixins(new String[]{"minecraft.MixinWorld_FixLightUpdateLag"}).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).addExcludedMod((ITargetMod)TargetedMod.ANGELICA).setApplyIf(() -> FixesConfig.optimizeWorldUpdateLight).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_FRIENDLY_CREATURE_SOUNDS(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinSoundHandler"}).setApplyIf(() -> FixesConfig.fixFriendlyCreatureSounds).setPhase(IBaseTransformer.Phase.EARLY)),
    LOGARITHMIC_VOLUME_CONTROL(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinSoundManager", "minecraft.MixinSoundManagerLibraryLoader"}).setApplyIf(() -> FixesConfig.logarithmicVolumeControl).setPhase(IBaseTransformer.Phase.EARLY)),
    THROTTLE_ITEMPICKUPEVENT(new MixinBuilder("Throttle Item Pickup Event").addCommonMixins(new String[]{"minecraft.MixinEntityPlayer_ThrottlePickup"}).setApplyIf(() -> FixesConfig.throttleItemPickupEvent).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_THROWER_TO_DROPPED_ITEM(new MixinBuilder("Adds the thrower tag to all dropped EntityItems").addCommonMixins(new String[]{"minecraft.MixinEntityPlayer_ItemThrower"}).setApplyIf(() -> FixesConfig.addThrowerTagToDroppedItems).setPhase(IBaseTransformer.Phase.EARLY)),
    SYNC_ITEM_THROWER(new MixinBuilder("Synchonize from server to client the thrower and pickup delay of an item entity").addCommonMixins(new String[]{"minecraft.packets.MixinS0EPacketSpawnObject_ItemThrower"}).addClientMixins(new String[]{"minecraft.MixinNetHandlerPlayClient_ItemThrower"}).setApplyIf(() -> FixesConfig.syncItemThrower).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_PERSPECTIVE_CAMERA(new MixinBuilder("Camera Perspective Fix").addClientMixins(new String[]{"minecraft.MixinEntityRenderer"}).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).addExcludedMod((ITargetMod)TargetedMod.ANGELICA).setApplyIf(() -> FixesConfig.fixPerspectiveCamera).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_DEBUG_BOUNDING_BOX(new MixinBuilder("Fix Bounding Box").addClientMixins(new String[]{"minecraft.MixinRenderManager"}).setApplyIf(() -> FixesConfig.fixDebugBoundingBox).setPhase(IBaseTransformer.Phase.EARLY)),
    FENCE_CONNECTIONS_FIX(new MixinBuilder("Fix Fence Connections").addCommonMixins(new String[]{"minecraft.MixinBlockFence"}).setApplyIf(() -> FixesConfig.fixFenceConnections).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinInventoryEffectRenderer_PotionOffset"}).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_POTION_EFFECT_RENDERING(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinInventoryEffectRenderer_PotionEffectRendering"}).setApplyIf(() -> TweaksConfig.fixPotionEffectRender).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_IMMOBILE_FIREBALLS(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinEntityFireball"}).setApplyIf(() -> FixesConfig.fixImmobileFireballs).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_REED_PLACING(new MixinBuilder("Fix placement of Sugar Canes").addCommonMixins(new String[]{"minecraft.MixinItemReed"}).setApplyIf(() -> FixesConfig.fixSugarCanePlacement).setPhase(IBaseTransformer.Phase.EARLY)),
    LONGER_CHAT(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinGuiNewChat_LongerChat"}).setApplyIf(() -> TweaksConfig.longerChat).setPhase(IBaseTransformer.Phase.EARLY)),
    TRANSPARENT_CHAT(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinGuiNewChat_TransparentChat"}).setApplyIf(() -> TweaksConfig.transparentChat).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_ENTITY_ATTRIBUTES_RANGE(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinNetHandlerPlayClient_FixEntityAttributesRange"}).setApplyIf(() -> FixesConfig.fixEntityAttributesRange).setPhase(IBaseTransformer.Phase.EARLY)),
    ENDERMAN_BLOCK_GRAB_DISABLE(new MixinBuilder("Disable Endermen Grabbing Blocks").addCommonMixins(new String[]{"minecraft.MixinEntityEndermanGrab"}).setApplyIf(() -> TweaksConfig.endermanBlockGrabDisable).setPhase(IBaseTransformer.Phase.EARLY)),
    ENDERMAN_BLOCK_PLACE_DISABLE(new MixinBuilder("Disable Endermen Placing Held Blocks").addCommonMixins(new String[]{"minecraft.MixinEntityEndermanPlace"}).setApplyIf(() -> TweaksConfig.endermanBlockPlaceDisable).setPhase(IBaseTransformer.Phase.EARLY)),
    ENDERMAN_BLOCK_PLACE_BLACKLIST(new MixinBuilder("Disable Endermen Placing Held Blocks on Configured Blocks").addCommonMixins(new String[]{"minecraft.MixinEntityEndermanPlaceBlacklist"}).setApplyIf(() -> TweaksConfig.endermanBlockPlaceBlacklist).setPhase(IBaseTransformer.Phase.EARLY)),
    WITCH_POTION_METADATA(new MixinBuilder("Fix Metadata of Witch Potions").addCommonMixins(new String[]{"minecraft.MixinEntityWitch"}).setApplyIf(() -> TweaksConfig.witchPotionMetadata).setPhase(IBaseTransformer.Phase.EARLY)),
    LONGER_MESSAGES(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinGuiChat_LongerMessages"}).addCommonMixins(new String[]{"minecraft.MixinC01PacketChatMessage_LongerMessages"}).setPhase(IBaseTransformer.Phase.EARLY)),
    SPEEDUP_REMOVE_FORMATTING_CODES(new MixinBuilder("Speed up the vanilla method to remove formatting codes").addClientMixins(new String[]{"minecraft.MixinEnumChatFormatting_FastFormat"}).setApplyIf(() -> SpeedupsConfig.speedupRemoveFormatting).setPhase(IBaseTransformer.Phase.EARLY)),
    SPEEDUP_GRASS_BLOCK_RANDOM_TICKING(new MixinBuilder("Speed up grass block random ticking").addCommonMixins(new String[]{"minecraft.MixinBlockGrass"}).setApplyIf(() -> SpeedupsConfig.speedupGrassBlockRandomTicking).setPhase(IBaseTransformer.Phase.EARLY)),
    SPEEDUP_CHUNK_PROVIDER_CLIENT(new MixinBuilder("Speed up ChunkProviderClient").addClientMixins(new String[]{"minecraft.MixinChunkProviderClient_RemoveChunkListing"}).addExcludedMod((ITargetMod)TargetedMod.FASTCRAFT).setApplyIf(() -> SpeedupsConfig.speedupChunkProviderClient && ASMConfig.speedupLongIntHashMap).setPhase(IBaseTransformer.Phase.EARLY)),
    BETTER_HASHCODES(new MixinBuilder("Optimize various Hashcode").addCommonMixins(new String[]{"minecraft.MixinChunkCoordinates_BetterHash", "minecraft.MixinChunkCoordIntPair_BetterHash"}).setApplyIf(() -> SpeedupsConfig.speedupChunkCoordinatesHashCode).setPhase(IBaseTransformer.Phase.EARLY)),
    TCP_NODELAY(new MixinBuilder("Set TCP NODELAY").addCommonMixins(new String[]{"minecraft.MixinTcpNoDelay"}).setApplyIf(() -> SpeedupsConfig.tcpNoDelay).setPhase(IBaseTransformer.Phase.EARLY)),
    WORLD_UNPROTECTED_GET_BLOCK(new MixinBuilder("Fix world unprotected getBlock").addCommonMixins(new String[]{"minecraft.MixinWorldGetBlock"}).setApplyIf(() -> FixesConfig.fixVanillaUnprotectedGetBlock).setPhase(IBaseTransformer.Phase.EARLY)),
    WORLD_UNPROTECTED_LIGHT_VALUE(new MixinBuilder("Fix world unprotected light value").addCommonMixins(new String[]{"minecraft.MixinWorldLightValue"}).setApplyIf(() -> FixesConfig.fixGetBlockLightValue).setPhase(IBaseTransformer.Phase.EARLY)),
    VILLAGE_UNCHECKED_GET_BLOCK(new MixinBuilder("Fix Village unchecked getBlock").addCommonMixins(new String[]{"minecraft.MixinVillage", "minecraft.MixinVillageCollection"}).setApplyIf(() -> FixesConfig.fixVillageUncheckedGetBlock).setPhase(IBaseTransformer.Phase.EARLY)),
    FORGE_HOOKS_URL_FIX(new MixinBuilder("Fix forge URL hooks").addCommonMixins(new String[]{"minecraft.MixinForgeHooks"}).setApplyIf(() -> FixesConfig.fixUrlDetection).setPhase(IBaseTransformer.Phase.EARLY)),
    FORGE_UPDATE_CHECK_FIX(new MixinBuilder("Fix the forge update checker").addCommonMixins(new String[]{"forge.MixinForgeVersion_FixUpdateCheck"}).setApplyIf(() -> FixesConfig.fixForgeUpdateChecker).setPhase(IBaseTransformer.Phase.EARLY)),
    FORGE_FIX_CLASS_TYPO(new MixinBuilder("Fix a class name typo in MinecraftForge's initialize method").addCommonMixins(new String[]{"forge.MixinMinecraftForge"}).setApplyIf(() -> FixesConfig.fixEffectRendererClassTypo).setPhase(IBaseTransformer.Phase.EARLY)),
    NORTHWEST_BIAS_FIX(new MixinBuilder("Fix Northwest Bias").addCommonMixins(new String[]{"minecraft.MixinRandomPositionGenerator"}).setApplyIf(() -> FixesConfig.fixNorthWestBias).setPhase(IBaseTransformer.Phase.EARLY)),
    SPEEDUP_VANILLA_FURNACE(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinFurnaceRecipes"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addRequiredMod((ITargetMod)TargetedMod.GTNHLIB).setPhase(IBaseTransformer.Phase.EARLY)),
    GAMEOVER_GUI_LOCKED_DISABLED(new MixinBuilder("Fix Gameover GUI").addClientMixins(new String[]{"minecraft.MixinGuiGameOver"}).setApplyIf(() -> FixesConfig.fixGuiGameOver).setPhase(IBaseTransformer.Phase.EARLY)),
    PREVENT_PICKUP_LOOT(new MixinBuilder("Prevent monsters from picking up loot").addCommonMixins(new String[]{"minecraft.MixinEntityLivingPickup"}).setApplyIf(() -> TweaksConfig.preventPickupLoot).setPhase(IBaseTransformer.Phase.EARLY)),
    DROP_PICKED_LOOT_ON_DESPAWN(new MixinBuilder("Drop picked up loot on despawn").addCommonMixins(new String[]{"minecraft.MixinEntityLivingDrop"}).setApplyIf(() -> TweaksConfig.dropPickedLootOnDespawn).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HOPPER_HIT_BOX(new MixinBuilder("Fix Vanilla Hopper hit box").addCommonMixins(new String[]{"minecraft.MixinBlockHopper"}).setApplyIf(() -> FixesConfig.fixHopperHitBox).setPhase(IBaseTransformer.Phase.EARLY)),
    TILE_ENTITY_RENDERER_PROFILER(new MixinBuilder().addClientMixins(new String[]{"minecraft.profiler.TileEntityRendererDispatcherMixin"}).addClientMixins(new String[]{"minecraft.profiler.MinecraftMixin"}).setApplyIf(() -> TweaksConfig.enableTileRendererProfiler).setPhase(IBaseTransformer.Phase.EARLY)),
    DIMENSION_CHANGE_FIX(new MixinBuilder("Dimension Change Heart Fix").addCommonMixins(new String[]{"minecraft.MixinServerConfigurationManager", "minecraft.MixinEntityPlayerMP"}).setApplyIf(() -> FixesConfig.fixDimensionChangeAttributes).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_EATING_STACKED_STEW(new MixinBuilder("Stacked Mushroom Stew Eating Fix").addCommonMixins(new String[]{"minecraft.MixinItemSoup"}).setApplyIf(() -> FixesConfig.fixEatingStackedStew).setPhase(IBaseTransformer.Phase.EARLY)),
    INCREASE_PARTICLE_LIMIT(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinEffectRenderer"}).setApplyIf(() -> TweaksConfig.increaseParticleLimit).setPhase(IBaseTransformer.Phase.EARLY)),
    ENLARGE_POTION_ARRAY(new MixinBuilder("Make the Potion array larger").addCommonMixins(new String[]{"minecraft.MixinPotion"}).setApplyIf(() -> FixesConfig.enlargePotionArray).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_POTION_LIMIT(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinPotionEffect"}).setApplyIf(() -> FixesConfig.fixPotionLimit).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HOPPER_VOIDING_ITEMS(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinTileEntityHopper"}).setApplyIf(() -> FixesConfig.fixHopperVoidingItems).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HUGE_CHAT_KICK(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinS02PacketChat"}).setApplyIf(() -> FixesConfig.fixHugeChatKick).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_BOGUS_INTEGRATED_SERVER_NPE(new MixinBuilder("Fix bogus FMLProxyPacket NPEs on integrated server crashes").addCommonMixins(new String[]{"fml.MixinFMLProxyPacket", "fml.MixinNetworkDispatcher", "minecraft.NetworkManagerAccessor"}).setApplyIf(() -> FixesConfig.fixBogusIntegratedServerNPEs).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_LAG_ON_INVENTORY_SYNC(new MixinBuilder("Fix inventory sync lag").addCommonMixins(new String[]{"minecraft.MixinInventoryCrafting"}).setApplyIf(() -> FixesConfig.fixInventorySyncLag).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_LOGIN_DIMENSION_ID_OVERFLOW(new MixinBuilder("Fix dimension id overflowing when a player first logins on a server").addCommonMixins(new String[]{"minecraft.packets.MixinS01PacketJoinGame_FixDimensionID"}).setApplyIf(() -> FixesConfig.fixLoginDimensionIDOverflow).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_WORLD_SERVER_LEAKING_UNLOADED_ENTITIES(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinWorldServerUpdateEntities"}).setApplyIf(() -> FixesConfig.fixWorldServerLeakingUnloadedEntities).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_SKIN_MANAGER_CLIENT_WORLD_LEAK(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinSkinManager$2"}).setApplyIf(() -> FixesConfig.fixSkinManagerLeakingClientWorld).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_REDSTONE_TORCH_WORLD_LEAK(new MixinBuilder("Fix world leak in redstone torch").addCommonMixins(new String[]{"minecraft.MixinBlockRedstoneTorch"}).setApplyIf(() -> FixesConfig.fixRedstoneTorchWorldLeak).addExcludedMod((ITargetMod)TargetedMod.BUGTORCH).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_ARROW_WRONG_LIGHTING(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinRendererLivingEntity"}).setApplyIf(() -> FixesConfig.fixGlStateBugs).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_RESIZABLE_FULLSCREEN(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinMinecraft_ResizableFullscreen"}).setApplyIf(() -> FixesConfig.fixResizableFullscreen).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_UNFOCUSED_FULLSCREEN(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinMinecraft_UnfocusedFullscreen"}).setApplyIf(() -> FixesConfig.fixUnfocusedFullscreen).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_RENDERERS_WORLD_LEAK(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinMinecraft_ClearRenderersWorldLeak", "minecraft.MixinRenderGlobal_FixWordLeak"}).setApplyIf(() -> FixesConfig.fixRenderersWorldLeak).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_OPTIFINE_CHUNKLOADING_CRASH(new MixinBuilder().setApplyIf(() -> FixesConfig.fixOptifineChunkLoadingCrash).addRequiredMod((ITargetMod)TargetedMod.OPTIFINE).addClientMixins(new String[]{"minecraft.MixinGameSettings_FixOFChunkLoading"}).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_SIDE_FACING_UNLOADED_CHUNKS_BEING_RENDERED(new MixinBuilder().setApplyIf(() -> FixesConfig.fixBlockSidesFacingUnloadedChunksBeingRendered).addClientMixins(new String[]{"minecraft.MixinBlock_SideFacingUnloadedChunk", "minecraft.MixinChunkCache_SideFacingUnloaded"}).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_TOGGLE_DEBUG_MESSAGE(new MixinBuilder("Toggle Debug Message").addClientMixins(new String[]{"minecraft.MixinMinecraft_ToggleDebugMessage"}).setApplyIf(() -> TweaksConfig.addToggleDebugMessage).setPhase(IBaseTransformer.Phase.EARLY)),
    OPTIMIZE_TEXTURE_LOADING(new MixinBuilder().addClientMixins(new String[]{"minecraft.textures.client.MixinTextureUtil"}).addExcludedMod((ITargetMod)TargetedMod.ANGELICA).setApplyIf(() -> SpeedupsConfig.optimizeTextureLoading).setPhase(IBaseTransformer.Phase.EARLY)),
    HIDE_POTION_PARTICLES(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinEntityLivingBase_HidePotionParticles"}).setApplyIf(() -> TweaksConfig.hidePotionParticlesFromSelf).setPhase(IBaseTransformer.Phase.EARLY)),
    DIMENSION_MANAGER_DEBUG(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinDimensionManager"}).setApplyIf(() -> DebugConfig.dimensionManagerDebug).setPhase(IBaseTransformer.Phase.EARLY)),
    OPTIMIZE_TILEENTITY_REMOVAL(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinWorldUpdateEntities"}).setApplyIf(() -> SpeedupsConfig.optimizeTileentityRemoval).addExcludedMod((ITargetMod)TargetedMod.FASTCRAFT).addExcludedMod((ITargetMod)TargetedMod.BUKKIT).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_POTION_ITERATING(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinEntityLivingBase_FixPotionException"}).setApplyIf(() -> FixesConfig.fixPotionIterating).setPhase(IBaseTransformer.Phase.EARLY)),
    ENHANCE_NIGHT_VISION(new MixinBuilder("Remove the blueish sky tint from night vision").setApplyIf(() -> TweaksConfig.enhanceNightVision).addClientMixins(new String[]{"minecraft.MixinEntityRenderer_EnhanceNightVision"}).setPhase(IBaseTransformer.Phase.EARLY)),
    NIGHT_VISION_FADE(new MixinBuilder().setApplyIf(() -> TweaksConfig.fadeNightVision).addClientMixins(new String[]{"minecraft.MixinEntityRenderer_NightVisionFade"}).setPhase(IBaseTransformer.Phase.EARLY)),
    OPTIMIZE_ASMDATATABLE_INDEX(new MixinBuilder("Optimize ASM DataTable Index").addCommonMixins(new String[]{"fml.MixinASMDataTable"}).setApplyIf(() -> SpeedupsConfig.optimizeASMDataTable).setPhase(IBaseTransformer.Phase.EARLY)),
    SQUASH_BED_ERROR_MESSAGE(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinNetHandlerPlayClient"}).setApplyIf(() -> FixesConfig.squashBedErrorMessage).setPhase(IBaseTransformer.Phase.EARLY)),
    CHUNK_SAVE_CME_DEBUG(new MixinBuilder("Add debugging code to Chunk Save CME").addCommonMixins(new String[]{"minecraft.MixinNBTTagCompound"}).setApplyIf(() -> DebugConfig.chunkSaveCMEDebug).setPhase(IBaseTransformer.Phase.EARLY)),
    SPEEDUP_NBT_COPY(new MixinBuilder("Speed up NBT copy").addCommonMixins(new String[]{"minecraft.MixinNBTTagCompound_speedup", "minecraft.MixinNBTTagList_speedup"}).setApplyIf(() -> ASMConfig.speedupNBTTagCompoundCopy).addExcludedMod((ITargetMod)TargetedMod.BUKKIT).addExcludedMod((ITargetMod)TargetedMod.FASTCRAFT).setPhase(IBaseTransformer.Phase.EARLY)),
    STRING_POOLER_NBT_TAG(new MixinBuilder("Pool NBT Strings").addCommonMixins(new String[]{"minecraft.MixinNBTTagCompound_stringPooler"}).setApplyIf(() -> TweaksConfig.enableTagCompoundStringPooling).setPhase(IBaseTransformer.Phase.EARLY)),
    STRING_POOLER_NBT_STRING(new MixinBuilder("Pool NBT Strings").addCommonMixins(new String[]{"minecraft.MixinNBTTagString_stringPooler"}).setApplyIf(() -> TweaksConfig.enableNBTStringPooling).setPhase(IBaseTransformer.Phase.EARLY)),
    THREADED_WORLDDATA_SAVING(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinMapStorage_threadedIO", "minecraft.MixinSaveHandler_threadedIO", "minecraft.MixinScoreboardSaveData_threadedIO", "minecraft.MixinVillageCollection_threadedIO", "minecraft.MixinMapData_threadedIO", "forge.MixinForgeChunkManager_threadedIO"}).setApplyIf(() -> TweaksConfig.threadedWorldDataSaving).setPhase(IBaseTransformer.Phase.EARLY)),
    DONT_SLEEP_ON_THREADED_IO(new MixinBuilder("Don't sleep on threaded IO").addCommonMixins(new String[]{"minecraft.MixinThreadedFileIOBase_noSleep"}).setApplyIf(() -> TweaksConfig.dontSleepOnThreadedIO).setPhase(IBaseTransformer.Phase.EARLY)),
    OPTIMIZE_MOB_SPAWNING(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinSpawnerAnimals_optimizeSpawning", "minecraft.MixinSpawnListEntry_optimizeSpawning"}).setApplyIf(() -> SpeedupsConfig.optimizeMobSpawning).addExcludedMod((ITargetMod)TargetedMod.BUKKIT).setPhase(IBaseTransformer.Phase.EARLY)),
    RENDER_DEBUG(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinRenderGlobal"}).setApplyIf(() -> DebugConfig.renderDebug).addExcludedMod((ITargetMod)TargetedMod.BUKKIT).setPhase(IBaseTransformer.Phase.EARLY)),
    STATIC_LAN_PORT(new MixinBuilder().addClientMixins(new String[]{"minecraft.server.MixinHttpUtil"}).setApplyIf(() -> TweaksConfig.enableDefaultLanPort).setPhase(IBaseTransformer.Phase.EARLY)),
    CROSSHAIR_THIRDPERSON(new MixinBuilder("Crosshairs thirdperson").addClientMixins(new String[]{"forge.MixinGuiIngameForge_CrosshairThirdPerson"}).setApplyIf(() -> TweaksConfig.hideCrosshairInThirdPerson).setPhase(IBaseTransformer.Phase.EARLY)),
    DONT_INVERT_CROSSHAIR_COLORS(new MixinBuilder("Don't invert crosshair colors").addClientMixins(new String[]{"forge.MixinGuiIngameForge_CrosshairInvertColors"}).setApplyIf(() -> TweaksConfig.dontInvertCrosshairColor).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_OPENGUIHANDLER_WINDOWID(new MixinBuilder("Fix OpenGuiHandler").addCommonMixins(new String[]{"fml.MixinOpenGuiHandler"}).setApplyIf(() -> FixesConfig.fixForgeOpenGuiHandlerWindowId).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_KEYBIND_CONFLICTS(new MixinBuilder("Trigger all conflicting keybinds").addClientMixins(new String[]{"minecraft.MixinKeyBinding", "minecraft.MixinMinecraft_UpdateKeys"}).setApplyIf(() -> FixesConfig.triggerAllConflictingKeybindings).addExcludedMod((ITargetMod)TargetedMod.MODERNKEYBINDING).setPhase(IBaseTransformer.Phase.EARLY)),
    REMOVE_SPAWN_MINECART_SOUND(new MixinBuilder("Remove sound when spawning a minecart").addClientMixins(new String[]{"minecraft.MixinWorldClient"}).setApplyIf(() -> TweaksConfig.removeSpawningMinecartSound).setPhase(IBaseTransformer.Phase.EARLY)),
    MACOS_KEYS_TEXTFIELD_SHORTCUTS(new MixinBuilder("Macos use CMD to copy/select/delete text").addClientMixins(new String[]{"minecraft.MixinGuiTextField"}).setApplyIf(() -> TweaksConfig.enableMacosCmdShortcuts && System.getProperty("os.name").toLowerCase().contains("mac")).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_FONT_RENDERER_LINEWRAP_RECURSION(new MixinBuilder("Replace recursion with iteration in FontRenderer line wrapping code").addClientMixins(new String[]{"minecraft.MixinFontRenderer"}).setApplyIf(() -> FixesConfig.fixFontRendererLinewrapRecursion).setPhase(IBaseTransformer.Phase.EARLY)),
    BED_MESSAGE_ABOVE_HOTBAR(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinBlockBed"}).setApplyIf(() -> TweaksConfig.bedMessageAboveHotbar).setPhase(IBaseTransformer.Phase.EARLY)),
    BED_ALWAYS_SETS_SPAWN(new MixinBuilder("Clicking a bed in a valid dim will always set your spawn immediately").setApplyIf(() -> TweaksConfig.bedAlwaysSetsSpawn).addCommonMixins(new String[]{"minecraft.MixinBlockBed_AlwaysSetsSpawn"}).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_PLAYER_SKIN_FETCHING(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinAbstractClientPlayer", "minecraft.MixinThreadDownloadImageData"}).setApplyIf(() -> FixesConfig.fixPlayerSkinFetching).setPhase(IBaseTransformer.Phase.EARLY)),
    VALIDATE_PACKET_ENCODING_BEFORE_SENDING(new MixinBuilder().addCommonMixins(new String[]{"minecraft.packets.MixinDataWatcher", "minecraft.packets.MixinS3FPacketCustomPayload_Validation"}).setApplyIf(() -> FixesConfig.validatePacketEncodingBeforeSending).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_FLUID_CONTAINER_REGISTRY_KEY(new MixinBuilder("Fix Forge fluid container registry key").addCommonMixins(new String[]{"forge.FluidContainerRegistryAccessor", "forge.MixinFluidRegistry"}).setApplyIf(() -> FixesConfig.fixFluidContainerRegistryKey).setPhase(IBaseTransformer.Phase.EARLY)),
    CHANGE_MAX_NETWORK_NBT_SIZE_LIMIT(new MixinBuilder("Modify the maximum NBT size limit as received from network packets").addCommonMixins(new String[]{"minecraft.MixinPacketBuffer"}).setApplyIf(() -> FixesConfig.changeMaxNetworkNbtSizeLimit).setPhase(IBaseTransformer.Phase.EARLY)),
    INCREASE_PACKET_SIZE_LIMIT(new MixinBuilder("Increase the packet size limit from 2MiB to a theoretical maximum of 4GiB").addCommonMixins(new String[]{"minecraft.MixinMessageSerializer2", "minecraft.MixinMessageDeserializer2", "minecraft.packets.MixinS3FPacketCustomPayload_LengthLimit"}).setApplyIf(() -> FixesConfig.increasePacketSizeLimit).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_XRAY_BLOCK_WITHOUT_COLLISION_AABB(new MixinBuilder("Fix Xray through block without collision boundingBox").addCommonMixins(new String[]{"minecraft.MixinBlock_FixXray", "minecraft.MixinWorld_FixXray"}).setApplyIf(() -> FixesConfig.fixPerspectiveCamera).setPhase(IBaseTransformer.Phase.EARLY)),
    DISABLE_CREATIVE_TAB_ALL_SEARCH(new MixinBuilder("Disable the creative tab with search bar").addClientMixins(new String[]{"minecraft.MixinGuiContainerCreative"}).setApplyIf(() -> FixesConfig.removeCreativeSearchTab).addRequiredMod((ITargetMod)TargetedMod.NOTENOUGHITEMS).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_CHAT_COLOR_WRAPPING(new MixinBuilder("Fix wrapped chat lines missing colors").addClientMixins(new String[]{"minecraft.MixinGuiNewChat_FixColorWrapping"}).setApplyIf(() -> FixesConfig.fixChatWrappedColors).setPhase(IBaseTransformer.Phase.EARLY)),
    COMPACT_CHAT(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinGuiNewChat_CompactChat"}).setApplyIf(() -> TweaksConfig.compactChat).setPhase(IBaseTransformer.Phase.EARLY)),
    NETTY_PATCH(new MixinBuilder("Fix NPE in Netty's Bootstrap class").addClientMixins(new String[]{"netty.MixinBootstrap"}).setApplyIf(() -> FixesConfig.fixNettyNPE).setPhase(IBaseTransformer.Phase.EARLY)),
    MODERN_PICK_BLOCK(new MixinBuilder("Allows pick block to pull items from your inventory").addClientMixins(new String[]{"forge.MixinForgeHooks_ModernPickBlock"}).setApplyIf(() -> TweaksConfig.modernPickBlock).setPhase(IBaseTransformer.Phase.EARLY)),
    TESSELATOR_PRESERVE_QUAD_ORDER(new MixinBuilder("Preserve the rendering order of layered quads on terrain pass 1").addClientMixins(new String[]{"minecraft.MixinTessellator"}).setApplyIf(() -> FixesConfig.fixPreserveQuadOrder).setPhase(IBaseTransformer.Phase.EARLY)),
    FAST_BLOCK_PLACING(new MixinBuilder("Allows blocks to be placed faster").addClientMixins(new String[]{"minecraft.MixinMinecraft_FastBlockPlacing"}).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_NEGATIVE_KELVIN(new MixinBuilder("Fix the local temperature can go below absolute zero").addCommonMixins(new String[]{"minecraft.MixinBiomeGenBase"}).setApplyIf(() -> FixesConfig.fixNegativeKelvin).setPhase(IBaseTransformer.Phase.EARLY)),
    SPIGOT_EXTENDED_CHUNKS(new MixinBuilder("Spigot-style extended chunk format to remove the 2MB chunk size limit").addExcludedMod((ITargetMod)TargetedMod.BUKKIT).addCommonMixins(new String[]{"minecraft.MixinRegionFile"}).setApplyIf(() -> FixesConfig.remove2MBChunkLimit).setPhase(IBaseTransformer.Phase.EARLY)),
    AUTOSAVE_INTERVAL(new MixinBuilder("Sets the auto save interval in ticks").addCommonMixins(new String[]{"minecraft.server.MixinMinecraftServer_AutoSaveInterval"}).setApplyIf(() -> TweaksConfig.autoSaveInterval != 900).setPhase(IBaseTransformer.Phase.EARLY)),
    LIGHTER_WATER(new MixinBuilder("Decreases water opacity from 3 to 1, like in modern").addCommonMixins(new String[]{"minecraft.MixinBlock_LighterWater"}).setApplyIf(() -> TweaksConfig.useLighterWater).setPhase(IBaseTransformer.Phase.EARLY)),
    EARLY_CHUNK_TILE_COORDINATE_CHECK(new MixinBuilder("Checks saved TileEntity coordinates earlier to provide a more descriptive error message").addCommonMixins(new String[]{"minecraft.MixinChunk"}).setApplyIf(() -> FixesConfig.earlyChunkTileCoordinateCheck).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_DUPLICATE_SOUNDS(new MixinBuilder("Fix duplicate sounds being played when you close a gui while one is playing").addClientMixins(new String[]{"minecraft.MixinMinecraft_FixDuplicateSounds"}).setApplyIf(() -> FixesConfig.fixDuplicateSounds).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_MOD_ITEM_STATS(new MixinBuilder("Add stats for modded items").addCommonMixins(new String[]{"fml.MixinGameRegistry"}).addClientMixins(new String[]{"minecraft.MixinStats"}).setApplyIf(() -> TweaksConfig.addModItemStats).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_MOD_ENTITY_STATS(new MixinBuilder("Add stats for modded entities").addCommonMixins(new String[]{"minecraft.MixinStatList"}).addClientMixins(new String[]{"minecraft.MixinStatsMobsList", "minecraft.MixinStatsBlock", "minecraft.MixinStatsItem"}).setApplyIf(() -> TweaksConfig.addModEntityStats).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_SLASH_COMMAND(new MixinBuilder("Fix forge command handler not checking for a / and also not running commands with any case").addClientMixins(new String[]{"minecraft.MixinClientCommandHandler_CommandFix"}).setApplyIf(() -> FixesConfig.fixSlashCommands).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_CASE_COMMAND(new MixinBuilder("Fix the command handler not allowing you to run commands typed in any case").addCommonMixins(new String[]{"minecraft.MixinCommandHandler_CommandFix"}).setApplyIf(() -> FixesConfig.fixCaseCommands).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_GAMESETTINGS_OUTOFBOUNDS(new MixinBuilder("Fix array out of bound error in GameSettings menu").addClientMixins(new String[]{"minecraft.MixinGameSettings_FixArrayOutOfBounds"}).setApplyIf(() -> FixesConfig.fixGameSettingsArrayOutOfBounds).addExcludedMod((ITargetMod)TargetedMod.LWJGL3IFY).setPhase(IBaseTransformer.Phase.EARLY)),
    LIMIT_RECURSIVE_BLOCK_UPDATE_DEPTH(new MixinBuilder("Limit the number of recursive cascading block updates during world generation to prevent stack overflow crashes").addCommonMixins(new String[]{"minecraft.MixinWorldServer_LimitUpdateRecursion"}).setApplyIf(() -> FixesConfig.limitRecursiveBlockUpdateDepth >= 0).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_MOD_CONFIG_SEARCHBAR(new MixinBuilder("Adds a search bar to the mod config GUI").addClientMixins(new String[]{"fml.MixinGuiConfig"}).setApplyIf(() -> TweaksConfig.addModConfigSearchBar).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_BUTTON_POS_GUIOPENLINK(new MixinBuilder("Fix the buttons not being centered in the GuiConfirmOpenLink").addClientMixins(new String[]{"minecraft.MixinGuiConfirmOpenLink"}).setApplyIf(() -> FixesConfig.fixButtonsGuiConfirmOpenLink).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_CHAT_OPEN_LINK(new MixinBuilder("Fix the vanilla method to open chat links not working for every OS").addClientMixins(new String[]{"minecraft.MixinGuiChat_OpenLinks"}).setApplyIf(() -> FixesConfig.fixChatOpenLink).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_NAMETAG_BRIGHTNESS(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinRendererLivingEntity_NametagBrightness"}).setApplyIf(() -> FixesConfig.fixNametagBrightness).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HIT_EFFECT_BRIGHTNESS(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinRendererLivingEntity_HitEffectBrightness"}).setApplyIf(() -> FixesConfig.fixHitEffectBrightness).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_BUKKIT_PLAYER_CONTAINER(new MixinBuilder("Fix Bukkit BetterQuesting crash").addRequiredMod((ITargetMod)TargetedMod.BUKKIT).addCommonMixins(new String[]{"minecraft.MixinContainerPlayer"}).setApplyIf(() -> FixesConfig.fixBukkitBetterQuestingCrash).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_BUKKIT_FIRE_SPREAD_NPE(new MixinBuilder("Fix vanilla fire spread sometimes causing NPE on thermos").addRequiredMod((ITargetMod)TargetedMod.BUKKIT).addCommonMixins(new String[]{"minecraft.MixinBlockFireSpread"}).setApplyIf(() -> FixesConfig.fixFireSpread).setPhase(IBaseTransformer.Phase.EARLY)),
    MEMORY_FIXES_CLIENT(new MixinBuilder("Memory fixes").addClientMixins(new String[]{"memory.MixinFMLClientHandler"}).setApplyIf(() -> FixesConfig.enableMemoryFixes).setPhase(IBaseTransformer.Phase.EARLY)),
    FAST_RANDOM(new MixinBuilder("Replaces uses of stdlib Random with a faster one").addCommonMixins(new String[]{"minecraft.fastload.rand.MixinChunkProviderGenerate", "minecraft.fastload.rand.MixinMapGenBase", "minecraft.fastload.rand.MixinMapGenCaves"}).setApplyIf(() -> SpeedupsConfig.fastRandom).setPhase(IBaseTransformer.Phase.EARLY)),
    FAST_INT_CACHE(new MixinBuilder("Rewrite internal caching methods to be safer and faster").addCommonMixins(new String[]{"minecraft.fastload.intcache.MixinCollectOneCache", "minecraft.fastload.intcache.MixinCollectTwoCaches", "minecraft.fastload.intcache.MixinGenLayerEdge", "minecraft.fastload.intcache.MixinIntCache", "minecraft.fastload.intcache.MixinWorldChunkManager"}).setApplyIf(() -> SpeedupsConfig.fastIntCache).setPhase(IBaseTransformer.Phase.EARLY)),
    NUKE_LONG_BOXING(new MixinBuilder("Remove Long boxing in MapGenStructure").addCommonMixins(new String[]{"minecraft.fastload.MixinMapGenStructure"}).setApplyIf(() -> SpeedupsConfig.unboxMapGen).setPhase(IBaseTransformer.Phase.EARLY)),
    EMBED_BLOCKIDS(new MixinBuilder("Embed IDs directly in the objects, to accelerate lookups").addExcludedMod((ITargetMod)TargetedMod.FASTCRAFT).addExcludedMod((ITargetMod)TargetedMod.BUKKIT).addCommonMixins(new String[]{"minecraft.fastload.embedid.MixinEmbedIDs", "minecraft.fastload.embedid.MixinFMLControlledNamespacedRegistry", "minecraft.fastload.embedid.MixinObjectIntIdentityMap"}).setApplyIf(() -> ASMConfig.embedID_experimental).setPhase(IBaseTransformer.Phase.EARLY)),
    FAST_CHUNK_LOADING(new MixinBuilder("Invasively accelerates chunk handling").addCommonMixins(new String[]{"minecraft.fastload.MixinEntityPlayerMP", "minecraft.fastload.MixinChunkProviderServer"}).setApplyIf(() -> SpeedupsConfig.fastChunkHandling).setPhase(IBaseTransformer.Phase.EARLY)),
    CANCEL_NONE_SOUNDS(new MixinBuilder("Skips playing empty sounds.").addCommonMixins(new String[]{"minecraft.shutup.MixinWorld"}).setApplyIf(() -> FixesConfig.skipEmptySounds).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_PLAYER_BLOCK_PLACEMENT_DISTANCE_CHECK(new MixinBuilder("Fix wrong block placement distance check").addCommonMixins(new String[]{"minecraft.MixinNetHandlePlayServer_FixWrongBlockPlacementCheck"}).setApplyIf(() -> FixesConfig.fixWrongBlockPlacementDistanceCheck).setPhase(IBaseTransformer.Phase.EARLY)),
    PREVENT_LAVA_CHUNK_LOADING(new MixinBuilder("Prevent lava blocks from loading chunks").addCommonMixins(new String[]{"minecraft.MixinBlockStaticLiquid"}).setApplyIf(() -> SpeedupsConfig.lavaChunkLoading).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_GLASS_BOTTLE_NON_WATER_BLOCKS(new MixinBuilder("Fix Glass Bottles filling with Water from some other Fluid blocks").addCommonMixins(new String[]{"minecraft.MixinItemGlassBottle"}).setApplyIf(() -> FixesConfig.fixGlassBottleWaterFilling).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_IOOBE_RENDER_DISTANCE(new MixinBuilder("Fix out of bounds render distance when Optifine/Angelica is uninstalled").addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).addExcludedMod((ITargetMod)TargetedMod.ANGELICA).addExcludedMod((ITargetMod)TargetedMod.FALSETWEAKS).addExcludedMod((ITargetMod)TargetedMod.ARCHAICFIX).addClientMixins(new String[]{"minecraft.MixinGameSettings_ReduceRenderDistance"}).setApplyIf(() -> FixesConfig.fixVanillaIOOBERenderDistance).setPhase(IBaseTransformer.Phase.EARLY)),
    BETTER_MOD_LIST(new MixinBuilder().addClientMixins(new String[]{"fml.MixinGuiModList", "fml.MixinGuiSlotModList", "fml.MixinGuiScrollingList"}).setApplyIf(() -> TweaksConfig.betterModList).addExcludedMod((ITargetMod)TargetedMod.ENDERCORE_WITH_MODLIST).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_EGG_PARTICLE(new MixinBuilder("Use correct egg particles instead of snowball ones (MC-7807)").addClientMixins(new String[]{"minecraft.MixinEntityEgg"}).setApplyIf(() -> FixesConfig.fixEggParticles).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_EVENTBUS_MEMORY_LEAK(new MixinBuilder("Fix EventBus keeping object references after unregistering event handlers.").addCommonMixins(new String[]{"fml.MixinListenerListInst", "fml.MixinEventBus"}).setApplyIf(() -> FixesConfig.fixEventBusMemoryLeak).setPhase(IBaseTransformer.Phase.EARLY)),
    ADD_HUNGER_GAMERULE(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinEntityPlayer_HungerRule", "minecraft.MixinFoodStats_HungerRule", "minecraft.MixinGameRules_HungerRule"}).setApplyIf(() -> TweaksConfig.hungerGameRule).setPhase(IBaseTransformer.Phase.EARLY)),
    DEBUG_EVENT_REGISTRATION(new MixinBuilder().addCommonMixins(new String[]{"fml.MixinEventBus_DebugRegistration"}).setApplyIf(() -> Boolean.getBoolean("hodgepodge.logEventTimes")).addCommonMixins(new String[]{"fml.MixinEventBus_DebugRegistration"}).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_HOUSE_CHAR_RENDERING(new MixinBuilder().addClientMixins(new String[]{"minecraft.MixinFontRenderer_House"}).setApplyIf(() -> FixesConfig.fixHouseCharRendering).setPhase(IBaseTransformer.Phase.EARLY)),
    CACHE_LAST_MATCHING_RECIPES(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinCraftingManager"}).setApplyIf(() -> SpeedupsConfig.cacheLastMatchingRecipe).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_UNPROTECTED_GET_BLOCK_FIX(new MixinBuilder("IC2 Kinetic Fix").addCommonMixins(new String[]{"ic2.MixinIc2WaterKinetic"}).setApplyIf(() -> FixesConfig.fixIc2UnprotectedGetBlock).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_DIRECT_INV_ACCESS(new MixinBuilder("IC2 Direct Inventory Access Fix").addCommonMixins(new String[]{"ic2.MixinItemCropSeed", "ic2.MixinTileEntityCrop"}).setApplyIf(() -> FixesConfig.fixIc2DirectInventoryAccess).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_NIGHT_VISION_NANO(new MixinBuilder("IC2 Nightvision Fix").addCommonMixins(new String[]{"ic2.MixinIc2NanoSuitNightVision", "ic2.MixinIc2QuantumSuitNightVision", "ic2.MixinIc2NightVisionGoggles"}).setApplyIf(() -> FixesConfig.fixIc2Nightvision).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_REACTOR_DUPE(new MixinBuilder("IC2 Reactor Dupe Fix").addCommonMixins(new String[]{"ic2.MixinTileEntityReactorChamberElectricNoDupe"}).setApplyIf(() -> FixesConfig.fixIc2ReactorDupe).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_REACTOR_INVENTORY_SPEEDUP(new MixinBuilder("IC2 Reactor Inventory Speedup Fix").addCommonMixins(new String[]{"ic2.MixinTileEntityReactorChamberElectricInvSpeedup"}).setApplyIf(() -> FixesConfig.optimizeIc2ReactorInventoryAccess).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    HIDE_IC2_REACTOR_COOLANT_SLOTS(new MixinBuilder("IC2 Reactory Fix").addCommonMixins(new String[]{"ic2.MixinTileEntityNuclearReactorElectric"}).setApplyIf(() -> TweaksConfig.hideIc2ReactorSlots).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_FLUID_CONTAINER_TOOLTIP(new MixinBuilder("IC2 Fluid Container Tooltip Fix").addCommonMixins(new String[]{"ic2.MixinItemIC2FluidContainer"}).setApplyIf(() -> TweaksConfig.displayIc2FluidLocalizedName).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_RESOURCE_PACK_TRANSLATION_FIX(new MixinBuilder().addClientMixins(new String[]{"fml.MixinLanguageRegistry", "fml.MixinFMLClientHandler", "ic2.MixinLocalization"}).setApplyIf(() -> FixesConfig.fixIc2ResourcePackTranslation).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.EARLY)),
    IC2_HOVER_MODE_FIX(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinIc2QuantumSuitHoverMode"}).setApplyIf(() -> FixesConfig.fixIc2HoverMode).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_ARMOR_LAG_FIX(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinElectricItemManager", "ic2.MixinIC2ArmorHazmat", "ic2.MixinIC2ArmorJetpack", "ic2.MixinIC2ArmorNanoSuit", "ic2.MixinIC2ArmorNightvisionGoggles", "ic2.MixinIC2ArmorQuantumSuit", "ic2.MixinIC2ArmorSolarHelmet", "ic2.MixinIC2ArmorStaticBoots"}).setApplyIf(() -> FixesConfig.fixIc2ArmorLag).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_CROP_TRAMPLING_FIX(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinIC2TileEntityCrop"}).setApplyIf(() -> FixesConfig.fixIc2CropTrampling).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_SYNC_REACTORS(new MixinBuilder("Synchronize IC2 reactors for more consistent operation").addCommonMixins(new String[]{"ic2.sync.MixinTEReactorChamber", "ic2.sync.MixinTEReactor"}).setApplyIf(() -> TweaksConfig.synchronizeIC2Reactors).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_CELL(new MixinBuilder("No IC2 Cell Consumption in tanks").addCommonMixins(new String[]{"ic2.MixinIC2ItemCell"}).setApplyIf(() -> TweaksConfig.ic2CellWithContainer).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    IC2_SPEEDUP_REACTOR_SIZE_COMPUTATION(new MixinBuilder().addCommonMixins(new String[]{"ic2.MixinTEReactorCacheReactorSize", "ic2.MixinDirection_Memory"}).setApplyIf(() -> SpeedupsConfig.speedupIC2ReactorSize).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    COFH_CORE_UPDATE_CHECK(new MixinBuilder("Yeet COFH Core Update Check").addCommonMixins(new String[]{"cofhcore.MixinCoFHCoreUpdateCheck"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setPhase(IBaseTransformer.Phase.EARLY)),
    BIBLIOCRAFT_UPDATE_CHECK(new MixinBuilder("Yeet Bibliocraft Update Check").addClientMixins(new String[]{"bibliocraft.MixinVersionCheck"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addRequiredMod((ITargetMod)TargetedMod.BIBLIOCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    DAMAGE_INDICATORS_UPDATE_CHECK(new MixinBuilder("Yeet Damage Indicators Update Check").addClientMixins(new String[]{"damageindicators.MixinDIClientProxy"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addRequiredMod((ITargetMod)TargetedMod.DAMAGE_INDICATORS).setPhase(IBaseTransformer.Phase.LATE)),
    COFH_REMOVE_TE_CACHE(new MixinBuilder("Remove CoFH tile entity cache").addCommonMixins(new String[]{"minecraft.MixinWorld_CoFH_TE_Cache"}).setApplyIf(() -> ASMConfig.cofhWorldTransformer).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_ORE_DICT_NPE(new MixinBuilder("Fix NPE in OreDictionaryArbiter").addCommonMixins(new String[]{"cofhcore.MixinOreDictionaryArbiter"}).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setApplyIf(() -> FixesConfig.fixCofhOreDictNPE).setPhase(IBaseTransformer.Phase.EARLY)),
    FIX_ORE_DICT_CME(new MixinBuilder("Fix race condition in CoFH oredict").addClientMixins(new String[]{"cofhcore.MixinFMLEventHandler"}).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setApplyIf(() -> FixesConfig.fixCofhOreDictCME).setPhase(IBaseTransformer.Phase.EARLY)),
    COFH_IMPROVE_BREAKBLOCK(new MixinBuilder("Improve CoFH breakBlock method to support mods").addClientMixins(new String[]{"cofhcore.MixinBlockHelper"}).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setApplyIf(() -> TweaksConfig.improveCofhBreakBlock).setPhase(IBaseTransformer.Phase.EARLY)),
    MFR_FIX_COFH_VALIDATE(new MixinBuilder("Remove CoFH TE cache usage from MFR").addCommonMixins(new String[]{"minefactoryreloaded.MixinTileEntityBase", "minefactoryreloaded.MixinTileEntityRedNetCable"}).addRequiredMod((ITargetMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> ASMConfig.cofhWorldTransformer).setPhase(IBaseTransformer.Phase.LATE)),
    TE_FIX_COFH_VALIDATE(new MixinBuilder("Remove CoFH TE cache usage from TE").addCommonMixins(new String[]{"thermalexpansion.MixinTileInventoryTileLightFalse"}).addRequiredMod((ITargetMod)TargetedMod.THERMALEXPANSION).setApplyIf(() -> ASMConfig.cofhWorldTransformer).setPhase(IBaseTransformer.Phase.LATE)),
    GC_TIME_COMMAND_FIX(new MixinBuilder("GC Time Fix").addCommonMixins(new String[]{"minecraft.MixinTimeCommandGalacticraftFix"}).setApplyIf(() -> FixesConfig.fixTimeCommandWithGC).addRequiredMod((ITargetMod)TargetedMod.GALACTICRAFT_CORE).setPhase(IBaseTransformer.Phase.EARLY)),
    UNBIND_KEYS_COFH(new MixinBuilder("Unbind COFH Core keybinds").addClientMixins(new String[]{"cofhcore.MixinProxyClient"}).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addRequiredMod((ITargetMod)TargetedMod.COFH_CORE).setPhase(IBaseTransformer.Phase.EARLY)),
    DISABLE_CHUNK_TERRAIN_GENERATION(new MixinBuilder().addCommonMixins(new String[]{"minecraft.MixinChunkProviderServer_DisableTerrain"}).setApplyIf(() -> TweaksConfig.disableChunkTerrainGeneration).setPhase(IBaseTransformer.Phase.EARLY)),
    DISABLE_WORLD_TYPE_CHUNK_POPULATION(new MixinBuilder("Disable chunk population tied to chunk generation (ores/structure)").addCommonMixins(new String[]{"minecraft.MixinChunkProviderServer_DisablePopulation"}).setApplyIf(() -> TweaksConfig.disableWorldTypeChunkPopulation).setPhase(IBaseTransformer.Phase.EARLY)),
    DISABLE_MODDED_CHUNK_POPULATION(new MixinBuilder("Disable all other mod chunk population (e.g. Natura clouds").addCommonMixins(new String[]{"minecraft.MixinChunkProviderServer_DisableModGeneration"}).setApplyIf(() -> TweaksConfig.disableModdedChunkPopulation).setPhase(IBaseTransformer.Phase.EARLY)),
    WAKE_ANCHORS_ON_LOGIN(new MixinBuilder("Wake passive anchors on login").addCommonMixins(new String[]{"railcraft.MixinTileAnchorPassive", "railcraft.MixinTileAnchorPersonal"}).setApplyIf(() -> TweaksConfig.installAnchorAlarm).addRequiredMod((ITargetMod)TargetedMod.RAILCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    HUNGER_OVERHAUL_LOW_STAT_EFFECT(new MixinBuilder("Patch unintended low stat effects").addCommonMixins(new String[]{"hungeroverhaul.MixinHungerOverhaulLowStatEffect"}).setApplyIf(() -> FixesConfig.fixHungerOverhaul).addRequiredMod((ITargetMod)TargetedMod.HUNGER_OVERHAUL).setPhase(IBaseTransformer.Phase.LATE)),
    HUNGER_OVERHAUL_REGEN(new MixinBuilder("Patch Regen").addCommonMixins(new String[]{"hungeroverhaul.MixinHungerOverhaulHealthRegen"}).setApplyIf(() -> FixesConfig.fixHungerOverhaul).addRequiredMod((ITargetMod)TargetedMod.HUNGER_OVERHAUL).setPhase(IBaseTransformer.Phase.LATE)),
    HUNGER_OVERHAUL_0_HUNGER(new MixinBuilder("Fix some items restore 0 hunger").addCommonMixins(new String[]{"hungeroverhaul.MixinHungerOverhaulModuleHarvestCraft"}).setApplyIf(() -> FixesConfig.fixHungerOverhaulRestore0Hunger).addRequiredMod((ITargetMod)TargetedMod.HUNGER_OVERHAUL).addRequiredMod((ITargetMod)TargetedMod.HARVESTCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    THREADED_THAUMCRAFT_MAZE_SAVING(new MixinBuilder().addCommonMixins(new String[]{"thaumcraft.MixinMazeHandler_threadedIO"}).setApplyIf(() -> TweaksConfig.threadedWorldDataSaving).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    ADD_CV_SUPPORT_TO_WAND_PEDESTAL(new MixinBuilder("CV Support for Wand Pedestal").addCommonMixins(new String[]{"thaumcraft.MixinTileWandPedestal"}).setApplyIf(() -> TweaksConfig.addCVSupportToWandPedestal).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_ASPECT_SORTING(new MixinBuilder("Fix Thaumcraft Aspects not being sorted by name").addClientMixins(new String[]{"thaumcraft.MixinGuiResearchRecipe", "thaumcraft.MixinGuiResearchTable", "thaumcraft.MixinGuiThaumatorium", "thaumcraft.MixinItem_SortAspectsByName"}).setApplyIf(() -> FixesConfig.fixThaumcraftAspectSorting).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_GOLEM_MARKER_LOADING(new MixinBuilder("Fix golem marker loading failure when dimensionId larger than MAX_BYTE").addCommonMixins(new String[]{"thaumcraft.MixinEntityGolemBase", "thaumcraft.MixinItemGolemBell"}).setApplyIf(() -> FixesConfig.fixThaumcraftGolemMarkerLoading).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_WORLD_COORDINATE_HASHING_METHOD(new MixinBuilder("Implement a proper hashing method for WorldCoordinates").addCommonMixins(new String[]{"thaumcraft.MixinWorldCoordinates"}).setApplyIf(() -> FixesConfig.fixThaumcraftWorldCoordinatesHashingMethod).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_MAGICAL_LEAVES_LAG(new MixinBuilder("Fix Thaumcraft leaves frequent ticking").addCommonMixins(new String[]{"thaumcraft.MixinBlockMagicalLeaves", "thaumcraft.MixinBlockMagicalLog"}).setApplyIf(() -> FixesConfig.fixThaumcraftLeavesLag).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_THAUMCRAFT_VIS_DUPLICATION(new MixinBuilder().addCommonMixins(new String[]{"thaumcraft.MixinTileWandPedestal_VisDuplication"}).setApplyIf(() -> FixesConfig.fixWandPedestalVisDuplication).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_NULL_HANDLING_ITEMWISPESSENCE(new MixinBuilder("Fix handling of null stacks in ItemWispEssence").addCommonMixins(new String[]{"thaumcraft.MixinItemWispEssence_Both"}).addClientMixins(new String[]{"thaumcraft.MixinItemWispEssence_Client"}).setApplyIf(() -> FixesConfig.fixNullHandlingItemWispEssence).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_THAUMCRAFT_CHECK_FOR_EE3_ITEM(new MixinBuilder().addCommonMixins(new String[]{"thaumcraft.MixinUtils"}).setApplyIf(() -> FixesConfig.fixThaumcraftEE3Check).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_QUICKSAND_XRAY(new MixinBuilder().addCommonMixins(new String[]{"biomesoplenty.MixinBlockMud_FixXray"}).setApplyIf(() -> FixesConfig.fixPerspectiveCamera).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    DEDUPLICATE_FORESTRY_COMPAT_IN_BOP(new MixinBuilder().addCommonMixins(new String[]{"biomesoplenty.MixinForestryIntegration"}).setApplyIf(() -> FixesConfig.deduplicateForestryCompatInBOP).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    SPEEDUP_BOP_BIOME_FOG(new MixinBuilder().addClientMixins(new String[]{"biomesoplenty.MixinFogHandler", "biomesoplenty.AccessorFogHandler"}).setApplyIf(() -> SpeedupsConfig.speedupBOPFogHandling).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    BIG_FIR_TREES(new MixinBuilder().addCommonMixins(new String[]{"biomesoplenty.MixinBlockBOPSapling"}).setApplyIf(() -> TweaksConfig.makeBigFirsPlantable).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    JAVA12_BOP(new MixinBuilder("BOP Java12-safe reflection").addCommonMixins(new String[]{"biomesoplenty.MixinBOPBiomes"}).addCommonMixins(new String[]{"biomesoplenty.MixinBOPReflectionHelper"}).setApplyIf(() -> FixesConfig.java12BopCompat).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    DISABLE_QUICKSAND_GENERATION(new MixinBuilder().addCommonMixins(new String[]{"biomesoplenty.MixinDisableQuicksandGeneration"}).setApplyIf(() -> TweaksConfig.removeBOPQuicksandGeneration).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    DISABLE_DONATOR_EFFECTS(new MixinBuilder().addCommonMixins(new String[]{"biomesoplenty.MixinBOPEventHandler", "biomesoplenty.MixinTrailManager"}).setApplyIf(() -> TweaksConfig.removeBOPDonatorEffect).addRequiredMod((ITargetMod)TargetedMod.BOP).setPhase(IBaseTransformer.Phase.LATE)),
    DISARM_SACRED_TREE(new MixinBuilder("Prevents Sacred Rubber Tree Generation").addCommonMixins(new String[]{"minefactoryreloaded.MixinBlockRubberSapling"}).addRequiredMod((ITargetMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> FixesConfig.disableMassiveSacredTreeGeneration).setPhase(IBaseTransformer.Phase.LATE)),
    MFR_IMPROVE_BLOCKSMASHER(new MixinBuilder("Improve MFR block smasher").addCommonMixins(new String[]{"minefactoryreloaded.MixinTileEntityBlockSmasher"}).addRequiredMod((ITargetMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> TweaksConfig.improveMfrBlockSmasher).setPhase(IBaseTransformer.Phase.LATE)),
    MFR_IMPROVE_BLOCKBREAKER(new MixinBuilder("Improve MFR block breaker").addCommonMixins(new String[]{"minefactoryreloaded.MixinTileEntityBlockBreaker"}).addRequiredMod((ITargetMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> TweaksConfig.improveMfrBlockBreaker).setPhase(IBaseTransformer.Phase.LATE)),
    JAVA12_IMMERSIVE_ENGINERRING(new MixinBuilder("Immersive Engineering Java-12 safe potion array resizing").addCommonMixins(new String[]{"immersiveengineering.MixinIEPotions"}).setApplyIf(() -> FixesConfig.java12ImmersiveEngineeringCompat).addRequiredMod((ITargetMod)TargetedMod.IMMERSIVE_ENGINENEERING).setPhase(IBaseTransformer.Phase.LATE)),
    JAVA12_MINE_CHEM(new MixinBuilder("Minechem Java-12 safe potion array resizing").addCommonMixins(new String[]{"minechem.MixinPotionInjector"}).setApplyIf(() -> FixesConfig.java12MineChemCompat).addRequiredMod((ITargetMod)TargetedMod.MINECHEM).setPhase(IBaseTransformer.Phase.LATE)),
    MPS_PREVENT_RF_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining RF from Inventory").addCommonMixins(new String[]{"mps.MixinElectricAdapterRF"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferRF).addRequiredMod((ITargetMod)TargetedMod.MODULARPOWERSUITS).setPhase(IBaseTransformer.Phase.LATE)),
    MPS_PREVENT_EU_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining EU from Inventory").addCommonMixins(new String[]{"mps.MixinElectricAdapterEU"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferEU).addRequiredMod((ITargetMod)TargetedMod.MODULARPOWERSUITS).setPhase(IBaseTransformer.Phase.LATE)),
    MPS_PREVENT_ME_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining ME from Inventory").addCommonMixins(new String[]{"mps.MixinElectricAdapterME"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferME).addRequiredMod((ITargetMod)TargetedMod.MODULARPOWERSUITS).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_HUD_LIGHTING_GLITCH(new MixinBuilder("HUD Lighting glitch").addCommonMixins(new String[]{"mrtjpcore.MixinFXEngine"}).setApplyIf(() -> TweaksConfig.fixHudLightingGlitch).addRequiredMod((ITargetMod)TargetedMod.MRTJPCORE).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_POPPING_OFF(new MixinBuilder().addCommonMixins(new String[]{"mrtjpcore.MixinPlacementLib"}).setApplyIf(() -> TweaksConfig.fixComponentsPoppingOff).addRequiredMod((ITargetMod)TargetedMod.MRTJPCORE).setPhase(IBaseTransformer.Phase.LATE)),
    IMPLEMENTS_CONTAINER_FOR_THIRSTY_TANK(new MixinBuilder("Thirsty Tank Container").addCommonMixins(new String[]{"automagy.MixinItemBlockThirstyTank"}).setApplyIf(() -> TweaksConfig.thirstyTankContainer).addRequiredMod((ITargetMod)TargetedMod.AUTOMAGY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_BETTERHUD_ARMOR_BAR(new MixinBuilder("Fix better HUD armor display breaking with skulls").addCommonMixins(new String[]{"betterhud.MixinSkullDurabilityDisplay"}).setApplyIf(() -> FixesConfig.fixBetterHUDArmorDisplay).addRequiredMod((ITargetMod)TargetedMod.BETTERHUD).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_BETTERHUD_HEARTS_FREEZE(new MixinBuilder("Fix better HUD freezing the game when trying to render high amounts of hp").addCommonMixins(new String[]{"betterhud.MixinHealthRender"}).setApplyIf(() -> FixesConfig.fixBetterHUDHPDisplay).addRequiredMod((ITargetMod)TargetedMod.BETTERHUD).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_FURNACE_ITERATION(new MixinBuilder("Speedup Furnaces").addCommonMixins(new String[]{"projecte.MixinObjHandler"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addRequiredMod((ITargetMod)TargetedMod.PROJECTE).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_LOTR_FURNACE_ERROR(new MixinBuilder("Patches lotr to work with the vanilla furnace speedup").addCommonMixins(new String[]{"lotr.MixinLOTRRecipes"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addRequiredMod((ITargetMod)TargetedMod.GTNHLIB).addRequiredMod((ITargetMod)TargetedMod.LOTR).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_LOTR_JAVA12(new MixinBuilder("Fix lotr java 12+ compat").addCommonMixins(new String[]{"lotr.MixinLOTRLogReflection", "lotr.MixinRedirectHuornAI", "lotr.MixinRemoveUnlockFinalField"}).setApplyIf(() -> FixesConfig.java12LotrCompat).addRequiredMod((ITargetMod)TargetedMod.LOTR).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_JOURNEYMAP_KEYBINDS(new MixinBuilder().addClientMixins(new String[]{"journeymap.MixinConstants"}).setApplyIf(() -> FixesConfig.fixJourneymapKeybinds).addRequiredMod((ITargetMod)TargetedMod.JOURNEYMAP).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_JOURNEYMAP_ILLEGAL_FILE_PATH_CHARACTER(new MixinBuilder().addClientMixins(new String[]{"journeymap.MixinWorldData"}).setApplyIf(() -> FixesConfig.fixJourneymapFilePath).addRequiredMod((ITargetMod)TargetedMod.JOURNEYMAP).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_JOURNEYMAP_JUMPY_SCROLLING(new MixinBuilder("Fix Journeymap jumpy scrolling in the waypoint manager").addClientMixins(new String[]{"journeymap.MixinWaypointManager"}).setApplyIf(() -> FixesConfig.fixJourneymapJumpyScrolling).addRequiredMod((ITargetMod)TargetedMod.JOURNEYMAP).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_XAEROS_WORLDMAP_SCROLL(new MixinBuilder("Fix Xaero's World Map map screen scrolling").addClientMixins(new String[]{"xaeroworldmap.MixinGuiMap"}).setApplyIf(() -> FixesConfig.fixXaerosWorldMapScroll).addRequiredMod((ITargetMod)TargetedMod.XAEROWORLDMAP).addRequiredMod((ITargetMod)TargetedMod.LWJGL3IFY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_XAEROS_MINIMAP_ENTITYDOT(new MixinBuilder("Fix Xaero's Minimap player entity dot rendering when arrow is chosen").addClientMixins(new String[]{"xaerominimap.MixinMinimapRenderer"}).setApplyIf(() -> FixesConfig.fixXaerosMinimapEntityDot).addRequiredMod((ITargetMod)TargetedMod.XAEROMINIMAP).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_IGNIS_FRUIT_AABB(new MixinBuilder("Ignis Fruit").addCommonMixins(new String[]{"harvestthenether.MixinBlockPamFruit"}).setApplyIf(() -> FixesConfig.fixIgnisFruitAABB).addRequiredMod((ITargetMod)TargetedMod.HARVESTTHENETHER).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_NETHER_LEAVES_FACE_RENDERING(new MixinBuilder("Nether Leaves").addClientMixins(new String[]{"harvestthenether.MixinBlockNetherLeaves"}).setApplyIf(() -> FixesConfig.fixNetherLeavesFaceRendering).addRequiredMod((ITargetMod)TargetedMod.HARVESTTHENETHER).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_BAUBLES_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Baubles Inventory with Potions").addClientMixins(new String[]{"baubles.MixinGuiEvents"}).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addRequiredMod((ITargetMod)TargetedMod.BAUBLES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_GALACTICRAFT_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Galacticraft Inventory with Potions").addClientMixins(new String[]{"galacticraftcore.MixinGuiExtendedInventory"}).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addRequiredMod((ITargetMod)TargetedMod.GALACTICRAFT_CORE).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_TRAVELLERSGEAR_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Travelers Gear with Potions").addClientMixins(new String[]{"travellersgear.MixinClientProxy"}).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addRequiredMod((ITargetMod)TargetedMod.TRAVELLERSGEAR).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_TINKER_POTION_EFFECT_OFFSET(new MixinBuilder("Prevents the inventory from shifting when the player has active potion effects").addRequiredMod((ITargetMod)TargetedMod.TINKERSCONSTRUCT).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addClientMixins(new String[]{"tconstruct.MixinTabRegistry"}).setPhase(IBaseTransformer.Phase.LATE)),
    Fix_EXTRATIC_TECONFLICT(new MixinBuilder("Disable ExtraTic's Integration with Metallurgy 3 Precious Materials Module: [Brass, Silver, Electrum & Platinum]").addCommonMixins(new String[]{"extratic.MixinPartsHandler", "extratic.MixinRecipeHandler"}).setApplyIf(() -> FixesConfig.fixExtraTiCTEConflict).addRequiredMod((ITargetMod)TargetedMod.EXTRATIC).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_EXTRA_UTILITIES_UNENCHANTING(new MixinBuilder("Fix Exu Unenchanting").addCommonMixins(new String[]{"extrautilities.MixinRecipeUnEnchanting"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesUnEnchanting).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    DISABLE_AID_SPAWN_XU_SPIKES(new MixinBuilder("Fixes the vanilla zombie aid spawn triggering when killed by Extra Utilities Spikes").addCommonMixins(new String[]{"extrautilities.MixinBlockSpike"}).setApplyIf(() -> TweaksConfig.disableAidSpawnByXUSpikes).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_EXTRA_UTILITIES_TRANSPARENT_ITEM_RENDER(new MixinBuilder("Fix extra utilities item rendering for transparent items").addClientMixins(new String[]{"extrautilities.MixinTransparentItemRender"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesItemRendering).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_DRUM_EATING_CELLS(new MixinBuilder("Fix extra utilities drums eating ic2 cells and forestry capsules").addCommonMixins(new String[]{"extrautilities.MixinBlockDrum"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesDrumEatingCells).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_GREENSCREEN_MICROBLOCKS(new MixinBuilder("Fix extra utilities Lapis Caelestis microblocks").addClientMixins(new String[]{"extrautilities.MixinFullBrightMicroMaterial"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesGreenscreenMicroblocks).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_LAST_MILLENIUM_RAIN(new MixinBuilder("Remove rain from the Last Millenium (Extra Utilities)").addCommonMixins(new String[]{"extrautilities.MixinChunkProviderEndOfTime"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesLastMilleniumRain).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_LAST_MILLENIUM_CREATURES(new MixinBuilder("Remove creatures from the Last Millenium (Extra Utilities)").addCommonMixins(new String[]{"extrautilities.MixinWorldProviderEndOfTime"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesLastMilleniumCreatures).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_FLUID_RETRIEVAL_NODE(new MixinBuilder("Prevent fluid retrieval node from voiding (Extra Utilities)").addCommonMixins(new String[]{"extrautilities.MixinFluidBufferRetrieval"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFluidRetrievalNode).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_FILING_CABINET_DUPE(new MixinBuilder("Caps hotkey'd stacks to their maximum stack size in filing cabinets").addCommonMixins(new String[]{"extrautilities.MixinContainerFilingCabinet"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFilingCabinetDupe).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_FILTER_DUPE(new MixinBuilder("Prevent hotkeying other items onto item filters while they are open").addCommonMixins(new String[]{"extrautilities.MixinContainerFilter"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFilterDupe).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    CONFIGURABLE_ENDERQUARRY_ENERGY(new MixinBuilder("Ender Quarry energy storage override").addCommonMixins(new String[]{"extrautilities.MixinTileEntityEnderQuarry"}).setApplyIf(() -> TweaksConfig.extraUtilitiesEnderQuarryOverride > 0).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_ENDERQUARRY_FREEZE(new MixinBuilder("Fix Ender Quarry freezes randomly").addCommonMixins(new String[]{"extrautilities.MixinTileEntityEnderQuarry_FixFreeze"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesEnderQuarryFreeze).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_HEALING_AXE_HEAL(new MixinBuilder("Fix the healing axe not healing entities when attacking them").addCommonMixins(new String[]{"extrautilities.MixinItemHealingAxe"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesHealingAxeHeal).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_HEALING_AXE_UNBREAKABLE(new MixinBuilder("Fix the healing axe to be truely unbreakable for damage calls.").addCommonMixins(new String[]{"extrautilities.MixinItemHealingAxeUnbreakable"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesHealingAxeUnbreakable).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_EROSION_SHOVEL_UNBREAKABLE(new MixinBuilder("Fix thet erosion shovel to be truely unbreakable for damage calls.").addCommonMixins(new String[]{"extrautilities.MixinItemErosionShovelUnbreakable"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesErosionShovelUnbreakable).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_CHEST_COMPARATOR_UPDATE(new MixinBuilder("Fix Extra Utilities chests not updating comparator redstone signals when their inventories change").addCommonMixins(new String[]{"extrautilities.MixinExtraUtilsChest"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesChestComparatorUpdate).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_ETHERIC_SWORD_UNBREAKABLE(new MixinBuilder("Make Etheric Sword truly unbreakable").addCommonMixins(new String[]{"extrautilities.MixinItemEthericSword"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesEthericSwordUnbreakable).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_ENDER_COLLECTOR_CRASH(new MixinBuilder("Prevent Extra Utilities Ender Collector from inserting into auto-dropping Blocks that create a crash-loop").addCommonMixins(new String[]{"extrautilities.MixinTileEnderCollector"}).setApplyIf(() -> FixesConfig.fixExtraUtilitiesEnderCollectorCrash).addRequiredMod((ITargetMod)TargetedMod.EXTRA_UTILITIES).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_GLIBYS_VC_THREAD_SHUTDOWN(new MixinBuilder("Fix Gliby's voice chat not shutting down its threads cleanly").addCommonMixins(new String[]{"glibysvoicechat.MixinVoiceChatServer"}).addClientMixins(new String[]{"glibysvoicechat.MixinClientNetwork"}).setApplyIf(() -> FixesConfig.fixGlibysVoiceChatThreadStop).addRequiredMod((ITargetMod)TargetedMod.GLIBYS_VOICE_CHAT).setPhase(IBaseTransformer.Phase.LATE)),
    PORTALGUN_FIX_URLS(new MixinBuilder("Fix URLs used to download the sound pack").addClientMixins(new String[]{"portalgun.MixinThreadDownloadResources"}).addRequiredMod((ITargetMod)TargetedMod.PORTAL_GUN).setApplyIf(() -> FixesConfig.fixPortalGunURLs).setPhase(IBaseTransformer.Phase.LATE)),
    REPLACE_VOXELMAP_REFLECTION(new MixinBuilder().addClientMixins(new String[]{"voxelmap.reflection.MixinAddonResourcePack", "voxelmap.reflection.MixinColorManager", "voxelmap.reflection.MixinMap", "voxelmap.reflection.MixinRadar", "voxelmap.reflection.MixinVoxelMap", "voxelmap.reflection.MixinWaypointManager$1"}).addRequiredMod((ITargetMod)TargetedMod.VOXELMAP).setApplyIf(() -> SpeedupsConfig.replaceVoxelMapReflection).setPhase(IBaseTransformer.Phase.LATE)),
    VOXELMAP_Y_FIX(new MixinBuilder("Fix off by one Y coord").addClientMixins(new String[]{"voxelmap.MixinMap"}).addRequiredMod((ITargetMod)TargetedMod.VOXELMAP).setApplyIf(() -> FixesConfig.fixVoxelMapYCoord).setPhase(IBaseTransformer.Phase.LATE)),
    VOXELMAP_NPE_FIX(new MixinBuilder("Fix VoxelMap NPEs with Chunks").addClientMixins(new String[]{"voxelmap.chunk.MixinCachedRegion", "voxelmap.chunk.MixinComparisonCachedRegion"}).addRequiredMod((ITargetMod)TargetedMod.VOXELMAP).setApplyIf(() -> FixesConfig.fixVoxelMapChunkNPE).setPhase(IBaseTransformer.Phase.LATE)),
    VOXELMAP_FILE_EXT(new MixinBuilder("Change VoxelMap cache file extension").addClientMixins(new String[]{"voxelmap.cache.MixinCachedRegion", "voxelmap.cache.MixinCachedRegion$1", "voxelmap.cache.MixinComparisonCachedRegion"}).addRequiredMod((ITargetMod)TargetedMod.VOXELMAP).setApplyIf(() -> TweaksConfig.changeCacheFileExtension).setPhase(IBaseTransformer.Phase.LATE)),
    DISABLE_POTION_ARRAY_EXTENDER(new MixinBuilder("Disable Witchery potion array extender").addCommonMixins(new String[]{"witchery.MixinPotionArrayExtender"}).setApplyIf(() -> FixesConfig.disableWitcheryPotionExtender).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_WITCHERY_REFLECTION_SKIN(new MixinBuilder("Fixes Witchery player skins reflections").addClientMixins(new String[]{"witchery.MixinExtendedPlayer", "witchery.MixinEntityReflection"}).setApplyIf(() -> FixesConfig.fixWitcheryReflections).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_WITCHERY_THUNDERING_DETECTION(new MixinBuilder("Fixes Witchery Thunder Detection for rituals and Witch Hunters breaking with mods modifying thunder frequency").addCommonMixins(new String[]{"witchery.MixinBlockCircle", "witchery.MixinEntityWitchHunter", "witchery.MixinRiteClimateChange"}).setApplyIf(() -> FixesConfig.fixWitcheryThunderDetection).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_WITCHERY_RENDERING(new MixinBuilder("Fixes Witchery Rendering errors").addClientMixins(new String[]{"witchery.MixinBlockCircleGlyph"}).setApplyIf(() -> FixesConfig.fixWitcheryRendering).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_WITCHERY_DEMON_SHIFT_CLICK(new MixinBuilder("Prevent the Witchery Demon's trading menu from opening when shift-clicking").addCommonMixins(new String[]{"witchery.MixinEntityDemon"}).setApplyIf(() -> FixesConfig.fixWitcheryDemonShiftClick).addRequiredMod((ITargetMod)TargetedMod.WITCHERY).setPhase(IBaseTransformer.Phase.LATE)),
    BIBLIOCRAFT_PACKET_FIX(new MixinBuilder("Packet Fix").addCommonMixins(new String[]{"bibliocraft.MixinBibliocraftPatchPacketExploits"}).setApplyIf(() -> FixesConfig.fixBibliocraftPackets).addRequiredMod((ITargetMod)TargetedMod.BIBLIOCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    BIBLIOCRAFT_PATH_SANITIZATION_FIX(new MixinBuilder("Path sanitization fix").addCommonMixins(new String[]{"bibliocraft.MixinPathSanitization"}).setApplyIf(() -> FixesConfig.fixBibliocraftPathSanitization).addRequiredMod((ITargetMod)TargetedMod.BIBLIOCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    ZTONES_PACKET_FIX(new MixinBuilder("Packet Fix").addCommonMixins(new String[]{"ztones.MixinZtonesPatchPacketExploits"}).setApplyIf(() -> FixesConfig.fixZTonesPackets).addRequiredMod((ITargetMod)TargetedMod.ZTONES).setPhase(IBaseTransformer.Phase.LATE)),
    ASP_RECIPE_FIX(new MixinBuilder("MT Core recipe fix").addCommonMixins(new String[]{"advancedsolarpanels.MixinAdvancedSolarPanel"}).addRequiredMod((ITargetMod)TargetedMod.ADVANCED_SOLAR_PANELS).addExcludedMod((ITargetMod)TargetedMod.DREAMCRAFT).setApplyIf(() -> FixesConfig.fixMTCoreRecipe).setPhase(IBaseTransformer.Phase.LATE)),
    TD_NASE_PREVENTION(new MixinBuilder("Prevent NegativeArraySizeException on itemduct transfers").addCommonMixins(new String[]{"thermaldynamics.MixinSimulatedInv"}).setApplyIf(() -> FixesConfig.preventThermalDynamicsNASE).addRequiredMod((ITargetMod)TargetedMod.THERMALDYNAMICS).setPhase(IBaseTransformer.Phase.LATE)),
    TD_FLUID_GRID_CCE(new MixinBuilder("Prevent ClassCastException on forming invalid Thermal Dynamic fluid grid").addCommonMixins(new String[]{"thermaldynamics.MixinTileFluidDuctSuper"}).setApplyIf(() -> FixesConfig.preventFluidGridCrash).addRequiredMod((ITargetMod)TargetedMod.THERMALDYNAMICS).setPhase(IBaseTransformer.Phase.LATE)),
    UNBIND_KEYS_TRAVELLERSGEAR(new MixinBuilder("Unbind Traveller's Gear keybinds").addClientMixins(new String[]{"travellersgear.MixinKeyHandler"}).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addRequiredMod((ITargetMod)TargetedMod.TRAVELLERSGEAR).setPhase(IBaseTransformer.Phase.LATE)),
    UNBIND_KEYS_INDUSTRIALCRAFT(new MixinBuilder("Unbind Industrial craft keybinds").addClientMixins(new String[]{"ic2.MixinKeyboardClient"}).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addRequiredMod((ITargetMod)TargetedMod.IC2).setPhase(IBaseTransformer.Phase.LATE)),
    UNBIND_KEYS_THAUMCRAFT(new MixinBuilder("Unbind Thaumcraft keybinds").addClientMixins(new String[]{"thaumcraft.MixinKeyHandlerThaumcraft"}).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addRequiredMod((ITargetMod)TargetedMod.THAUMCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    CHANGE_KEYBIND_CATEGORY_AUTOMAGY(new MixinBuilder("Change keybind category of Automagy").addClientMixins(new String[]{"automagy.MixinAutomagyKeyHandler"}).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addRequiredMod((ITargetMod)TargetedMod.AUTOMAGY).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_SUGARBLOCK_NPE(new MixinBuilder("Fix NPE when interacting with sugar block").addCommonMixins(new String[]{"candycraft.MixinBlockSugar"}).setApplyIf(() -> FixesConfig.fixCandycraftBlockSugarNPE).addRequiredMod((ITargetMod)TargetedMod.CANDYCRAFT).setPhase(IBaseTransformer.Phase.LATE)),
    FIX_NOT_WAKING_PLAYERS(new MixinBuilder("Fix players not being woken properly when not everyone is sleeping").addServerMixins(new String[]{"morpheus.MixinMorpheusWakePlayers"}).setApplyIf(() -> FixesConfig.fixMorpheusWaking).addRequiredMod((ITargetMod)TargetedMod.MORPHEUS).setPhase(IBaseTransformer.Phase.LATE));

    private final MixinBuilder builder;

    private Mixins(MixinBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public MixinBuilder getBuilder() {
        return this.builder;
    }
}

