/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.IconSupplier;
import com.github.weisj.darklaf.util.LogUtil;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class AbstractLazyIconSupplier<T extends Icon>
implements IconSupplier<T> {
    private static final Logger LOGGER = LogUtil.getLogger(AbstractLazyIconSupplier.class);
    protected final String path;
    protected final IconLoader.IconKey key;
    protected final Class<?> parentClass;
    private boolean loaded;
    private T icon;

    public AbstractLazyIconSupplier(String path, IconLoader.IconKey key, Class<?> parentClass) {
        this.path = path;
        this.key = key;
        this.parentClass = parentClass;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            LOGGER.finer(() -> "Loading icon '" + this.path + "'. Resolving from " + this.parentClass);
            this.icon = this.loadIcon();
            this.loaded = true;
            if (this.icon == null) {
                throw new IllegalStateException("Could not load icon '" + this.path + "'");
            }
            this.key.w = this.icon.getIconWidth();
            this.key.h = this.icon.getIconHeight();
        }
    }

    protected abstract T loadIcon();

    @Override
    public T getIcon() {
        this.ensureLoaded();
        return this.icon;
    }
}

